/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowType;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.loot.LootContext;

public class BreedCowWithVariantTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final BreedCowWithVariantTrigger INSTANCE = new BreedCowWithVariantTrigger();
    public static final ResourceLocation ID = BovinesAndButtercups.asResource("breed_cow_with_variant");
    public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)CowType.CODEC.optionalFieldOf("type").forGetter(TriggerInstance::type), (App)RegistryCodecs.homogeneousList(BovinesRegistryKeys.COW_VARIANT).optionalFieldOf("variants", (Object)HolderSet.direct((Holder[])new Holder[0])).forGetter(TriggerInstance::variants), (App)ContextAwarePredicate.CODEC.optionalFieldOf("parent").forGetter(TriggerInstance::parent), (App)ContextAwarePredicate.CODEC.optionalFieldOf("partner").forGetter(TriggerInstance::partner), (App)ContextAwarePredicate.CODEC.optionalFieldOf("child").forGetter(TriggerInstance::child), (App)Codec.BOOL.optionalFieldOf("different_from_parents").forGetter(TriggerInstance::differentFromParents)).apply((Applicative)inst, TriggerInstance::new));

    private BreedCowWithVariantTrigger() {
    }

    public void trigger(ServerPlayer serverPlayer, Animal parent, Animal partner, AgeableMob child, boolean differentFromParents, Holder<CowVariant<?>> type) {
        LootContext parentContext = EntityPredicate.createContext((ServerPlayer)serverPlayer, (Entity)parent);
        LootContext partnerContext = EntityPredicate.createContext((ServerPlayer)serverPlayer, (Entity)partner);
        LootContext childContext = child != null ? EntityPredicate.createContext((ServerPlayer)serverPlayer, (Entity)child) : null;
        this.trigger(serverPlayer, triggerInstance -> triggerInstance.matches(parentContext, partnerContext, childContext, differentFromParents, type));
    }

    public Codec<TriggerInstance> codec() {
        return CODEC;
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<Holder<CowType<?>>> type, HolderSet<CowVariant<?>> variants, Optional<ContextAwarePredicate> parent, Optional<ContextAwarePredicate> partner, Optional<ContextAwarePredicate> child, Optional<Boolean> differentFromParents) implements SimpleCriterionTrigger.SimpleInstance
    {
        public boolean matches(LootContext parentContext, LootContext partnerContext, LootContext childContext, boolean isNewType, Holder<CowVariant<?>> variant) {
            return !(!variant.isBound() || !this.type.isEmpty() && (!this.type.get().isBound() || this.type.get().value() != ((CowVariant)variant.value()).type()) || this.variants.size() != 0 && !this.variants.contains(variant) || !this.child.isEmpty() && !this.child.get().matches(childContext) || (!this.parent.isEmpty() && !this.parent.get().matches(parentContext) || !this.partner.isEmpty() && !this.partner.get().matches(partnerContext)) && (!this.parent.isEmpty() && !this.parent.get().matches(partnerContext) || !this.partner.isEmpty() && !this.partner.get().matches(parentContext)) || !this.differentFromParents.isEmpty() && isNewType != this.differentFromParents.get());
        }
    }
}

