/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.block;

import com.mojang.serialization.MapCodec;
import house.greenhouse.bovinesandbuttercups.content.block.entity.BovinesBlockEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.block.entity.CustomHugeMushroomBlockEntity;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.item.BovinesItems;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CustomHugeMushroomBlock
extends BaseEntityBlock {
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;
    private static final MapCodec<CustomHugeMushroomBlock> CODEC = CustomHugeMushroomBlock.simpleCodec(CustomHugeMushroomBlock::new);

    public CustomHugeMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack stack = new ItemStack((ItemLike)BovinesItems.CUSTOM_MUSHROOM);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CustomHugeMushroomBlockEntity) {
            CustomHugeMushroomBlockEntity cmpbe = (CustomHugeMushroomBlockEntity)blockEntity;
            stack.set(BovinesDataComponents.CUSTOM_MUSHROOM, (Object)cmpbe.getMushroomType());
        }
        return stack;
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (level.getBlockEntity(pos) != null) {
            ((CustomHugeMushroomBlockEntity)level.getBlockEntity(pos)).updateState();
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public BlockState rotate(BlockState $$0, Rotation $$1) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)$$0.setValue((Property)PROPERTY_BY_DIRECTION.get($$1.rotate(Direction.NORTH)), (Comparable)((Boolean)$$0.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.rotate(Direction.SOUTH)), (Comparable)((Boolean)$$0.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.rotate(Direction.EAST)), (Comparable)((Boolean)$$0.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.rotate(Direction.WEST)), (Comparable)((Boolean)$$0.getValue((Property)WEST)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.rotate(Direction.UP)), (Comparable)((Boolean)$$0.getValue((Property)UP)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.rotate(Direction.DOWN)), (Comparable)((Boolean)$$0.getValue((Property)DOWN)));
    }

    public BlockState mirror(BlockState $$0, Mirror $$1) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)$$0.setValue((Property)PROPERTY_BY_DIRECTION.get($$1.mirror(Direction.NORTH)), (Comparable)((Boolean)$$0.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.mirror(Direction.SOUTH)), (Comparable)((Boolean)$$0.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.mirror(Direction.EAST)), (Comparable)((Boolean)$$0.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.mirror(Direction.WEST)), (Comparable)((Boolean)$$0.getValue((Property)WEST)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.mirror(Direction.UP)), (Comparable)((Boolean)$$0.getValue((Property)UP)))).setValue((Property)PROPERTY_BY_DIRECTION.get($$1.mirror(Direction.DOWN)), (Comparable)((Boolean)$$0.getValue((Property)DOWN)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BovinesBlockEntityTypes.CUSTOM_MUSHROOM_BLOCK.create(pos, state);
    }
}

