/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.block;

import com.mojang.serialization.MapCodec;
import house.greenhouse.bovinesandbuttercups.api.block.CustomMushroomType;
import house.greenhouse.bovinesandbuttercups.content.block.BovinesBlocks;
import house.greenhouse.bovinesandbuttercups.content.block.entity.BovinesBlockEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.block.entity.CustomMushroomBlockEntity;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.item.BovinesItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CustomMushroomBlock
extends BaseEntityBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    private static final MapCodec<CustomMushroomBlock> CODEC = CustomMushroomBlock.simpleCodec(CustomMushroomBlock::new);

    public CustomMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack stack = new ItemStack((ItemLike)BovinesItems.CUSTOM_MUSHROOM);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CustomMushroomBlockEntity) {
            CustomMushroomBlockEntity cmpbe = (CustomMushroomBlockEntity)blockEntity;
            stack.set(BovinesDataComponents.CUSTOM_MUSHROOM, (Object)cmpbe.getMushroomType());
        }
        return stack;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.nextInt(25) == 0) {
            int i = 5;
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
                if (!level.getBlockState(blockpos).is((Block)this) || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.offset(randomSource.nextInt(3) - 1, randomSource.nextInt(2) - randomSource.nextInt(2), randomSource.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (level.isEmptyBlock(blockpos1) && state.canSurvive((LevelReader)level, blockpos1)) {
                    pos = blockpos1;
                }
                blockpos1 = pos.offset(randomSource.nextInt(3) - 1, randomSource.nextInt(2) - randomSource.nextInt(2), randomSource.nextInt(3) - 1);
            }
            if (level.isEmptyBlock(blockpos1) && state.canSurvive((LevelReader)level, blockpos1)) {
                level.setBlock(blockpos1, BovinesBlocks.CUSTOM_MUSHROOM_BLOCK.defaultBlockState(), 2);
                ((CustomMushroomBlockEntity)level.getBlockEntity(blockpos1)).setMushroomType(((CustomMushroomBlockEntity)level.getBlockEntity(pos)).getMushroomType());
                level.getBlockEntity(blockpos1).setChanged();
                level.sendBlockUpdated(blockpos1, level.getBlockState(blockpos1), level.getBlockState(pos), 3);
            }
        }
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.isSolidRender();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (belowState.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
            return true;
        }
        return level.getRawBrightness(pos, 0) < 13 && this.mayPlaceOn(belowState, (BlockGetter)level, belowPos);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (state.hasBlockEntity() && (blockEntity = level.getBlockEntity(pos)) instanceof CustomMushroomBlockEntity) {
            CustomMushroomBlockEntity mushroomBlockEntity = (CustomMushroomBlockEntity)blockEntity;
            return mushroomBlockEntity.getMushroomType().holder().isBound() && ((CustomMushroomType)mushroomBlockEntity.getMushroomType().holder().value()).hugeMushroomStructurePool().isPresent();
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        return (double)randomSource.nextFloat() < 0.4;
    }

    public void performBonemeal(ServerLevel level, RandomSource randomSource, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (state.hasBlockEntity() && (blockEntity = level.getBlockEntity(pos)) instanceof CustomMushroomBlockEntity) {
            CustomMushroomBlockEntity mushroomBlockEntity = (CustomMushroomBlockEntity)blockEntity;
            StructureTemplateManager structureTemplateManager = level.getStructureManager();
            Holder<CustomMushroomType> customMushroom = mushroomBlockEntity.getMushroomType().holder();
            if (customMushroom.isBound() && ((CustomMushroomType)customMushroom.value()).hugeMushroomStructurePool().isPresent()) {
                BoundingBox structureBox;
                Optional<StructurePoolElement> structurePoolElement = ((CustomMushroomType)customMushroom.value()).hugeMushroomStructurePool().filter(key -> level.registryAccess().lookupOrThrow(Registries.TEMPLATE_POOL).containsKey(key)).map(key -> ((StructureTemplatePool)level.registryAccess().lookupOrThrow(Registries.TEMPLATE_POOL).getOrThrow(key).value()).getRandomTemplate(randomSource));
                if (structurePoolElement.isEmpty()) {
                    return;
                }
                level.removeBlock(pos, false);
                Rotation rotation = ((CustomMushroomType)customMushroom.value()).randomlyRotateHugeStructure() ? Rotation.getRandom((RandomSource)level.random) : Rotation.NONE;
                int xRotationMultiplier = rotation == Rotation.CLOCKWISE_180 || rotation == Rotation.CLOCKWISE_90 ? -1 : 1;
                int zRotationMultiplier = rotation == Rotation.CLOCKWISE_180 || rotation == Rotation.COUNTERCLOCKWISE_90 ? -1 : 1;
                BlockPos centeredPos = pos.offset(xRotationMultiplier * -structurePoolElement.get().getSize(structureTemplateManager, rotation).getX() / 2, 0, zRotationMultiplier * -structurePoolElement.get().getSize(structureTemplateManager, rotation).getZ() / 2);
                if (ChunkPos.rangeClosed((ChunkPos)new ChunkPos(centeredPos), (ChunkPos)new ChunkPos(centeredPos.offset(structurePoolElement.get().getSize(structureTemplateManager, rotation)))).allMatch(chunkPos -> level.isLoaded(chunkPos.getWorldPosition())) && BlockPos.betweenClosedStream((AABB)AABB.of((BoundingBox)(structureBox = structurePoolElement.get().getBoundingBox(structureTemplateManager, centeredPos, rotation)))).allMatch(p -> pos.equals(p) || level.getBlockState(p).isAir() || level.getBlockState(p).is(BlockTags.LEAVES))) {
                    structurePoolElement.get().place(structureTemplateManager, (WorldGenLevel)level, level.structureManager(), level.getChunkSource().getGenerator(), centeredPos, centeredPos, rotation, structureBox, randomSource, LiquidSettings.APPLY_WATERLOGGING, false);
                    return;
                }
                level.setBlock(pos, state, 3);
                ((CustomMushroomBlockEntity)level.getBlockEntity(pos)).setMushroomType(mushroomBlockEntity.getMushroomType());
                level.getBlockEntity(pos).setChanged();
                level.sendBlockUpdated(pos, state, level.getBlockState(pos), 3);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BovinesBlockEntityTypes.CUSTOM_MUSHROOM.create(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

