/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TagPlaceableFlowerBlock
extends FlowerBlock {
    public static final MapCodec<TagPlaceableFlowerBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)EFFECTS_FIELD.forGetter(FlowerBlock::getSuspiciousEffects), (App)TagKey.codec((ResourceKey)Registries.BLOCK).optionalFieldOf("placeable_on").forGetter(TagPlaceableFlowerBlock::optionalPlaceableOn), (App)TagPlaceableFlowerBlock.propertiesCodec()).apply((Applicative)inst, TagPlaceableFlowerBlock::new));
    @Nullable
    private final TagKey<Block> placeableOn;

    public TagPlaceableFlowerBlock(SuspiciousStewEffects suspiciousStewEffects, Optional<TagKey<Block>> placeableOn, BlockBehaviour.Properties properties) {
        super(suspiciousStewEffects, properties);
        this.placeableOn = placeableOn.orElse(null);
    }

    public TagPlaceableFlowerBlock(Holder<MobEffect> effect, float seconds, TagKey<Block> placeableOn, BlockBehaviour.Properties properties) {
        super(effect, seconds, properties);
        this.placeableOn = placeableOn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.is(BlockTags.DIRT)) return true;
        if (state.getBlock() instanceof FarmBlock) return true;
        if (!(level instanceof LevelReader)) return false;
        LevelReader reader = (LevelReader)level;
        if (this.placeableOn == null) return false;
        if (reader.registryAccess().lookupOrThrow(Registries.BLOCK).get(this.placeableOn).map(holders -> holders.contains(state.getBlockHolder())).orElse(false) == false) return false;
        return true;
    }

    @Nullable
    public TagKey<Block> placeableOn() {
        return this.placeableOn;
    }

    public Optional<TagKey<Block>> optionalPlaceableOn() {
        return Optional.ofNullable(this.placeableOn);
    }

    public MapCodec<TagPlaceableFlowerBlock> codec() {
        return CODEC;
    }
}

