/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.block.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.block.CustomFlowerType;
import house.greenhouse.bovinesandbuttercups.content.block.entity.BovinesBlockEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomFlower;
import house.greenhouse.bovinesandbuttercups.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CustomFlowerPotBlockEntity
extends BlockEntity
implements Nameable {
    @Nullable
    private ItemCustomFlower customFlower;

    public CustomFlowerPotBlockEntity(BlockPos worldPosition, BlockState blockState) {
        super(BovinesBlockEntityTypes.POTTED_CUSTOM_FLOWER, worldPosition, blockState);
    }

    @Nullable
    public ItemCustomFlower getFlowerType() {
        return this.customFlower;
    }

    public void setFlowerType(@Nullable ItemCustomFlower value) {
        this.customFlower = value;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("custom_flower")) {
            this.setFlowerType(new ItemCustomFlower((Holder<CustomFlowerType>)((Holder)((Pair)CustomFlowerType.CODEC.decode((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("custom_flower")).getOrThrow()).getFirst())));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.getFlowerType() != null) {
            tag.put("custom_flower", (Tag)CustomFlowerType.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.getFlowerType().holder()).getOrThrow());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(BovinesDataComponents.CUSTOM_FLOWER, (Object)this.getFlowerType());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        this.setFlowerType((ItemCustomFlower)input.get(BovinesDataComponents.CUSTOM_FLOWER));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Component getName() {
        if (this.customFlower.holder().isBound()) {
            return BlockUtil.getOrCreateBlockNameTranslationKey(((ResourceKey)this.customFlower.holder().unwrapKey().orElseThrow()).location().withPath(s -> "potted_" + s));
        }
        return BlockUtil.getOrCreateBlockNameTranslationKey(BovinesAndButtercups.asResource("potted_missing_flower"));
    }
}

