/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.block.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.block.EdibleBlockType;
import house.greenhouse.bovinesandbuttercups.content.block.PlaceableEdibleBlock;
import house.greenhouse.bovinesandbuttercups.content.block.entity.BovinesBlockEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.ItemEdible;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import house.greenhouse.bovinesandbuttercups.util.BlockUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PlaceableEdibleBlockEntity
extends BlockEntity
implements Nameable {
    private static final Codec<Map<HolderSet<Item>, AttachmentState>> ATTACHMENTS_CODEC = Codec.simpleMap((Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM), AttachmentState.CODEC, (Keyable)Keyable.forStrings(() -> Stream.of("items", "state"))).codec();
    @Nullable
    private ItemEdible type;
    private final Map<HolderSet<Item>, AttachmentState> attachments = new LinkedHashMap<HolderSet<Item>, AttachmentState>();
    private List<EdibleBlockType.ParticleEntry> particles;

    public PlaceableEdibleBlockEntity(BlockPos worldPosition, BlockState blockState) {
        super(BovinesBlockEntityTypes.PLACEABLE_EDIBLE, worldPosition, blockState);
    }

    public ItemEdible getEdibleType() {
        if (this.type == null) {
            this.type = new ItemEdible((Holder<EdibleBlockType>)this.level.registryAccess().lookupOrThrow(BovinesRegistryKeys.EDIBLE_BLOCK_TYPE).getOrThrow(EdibleBlockType.MISSING_KEY), List.of());
            this.resetParticles();
        }
        return this.type;
    }

    public void setEdibleType(ItemEdible value) {
        this.type = value;
        this.resetParticles();
    }

    public Map<HolderSet<Item>, AttachmentState> getAttachments() {
        return ImmutableMap.copyOf(this.attachments);
    }

    public String attachmentsToString() {
        StringBuilder builder = new StringBuilder();
        this.attachments.forEach((holders, attachmentState) -> {
            if (!builder.isEmpty()) {
                builder.append(",");
            }
            String key = holders.unwrapKey().map(itemTagKey -> "#" + String.valueOf(itemTagKey.location())).orElseGet(() -> String.join((CharSequence)",", holders.stream().map(itemHolder -> itemHolder.unwrapKey().map(k -> k.location().toString()).orElseThrow()).toList()));
            builder.append(key).append("=").append(attachmentState.toString());
        });
        return builder.toString();
    }

    public InteractionResult addAttachmentItem(ItemStack stack, Player player) {
        if (this.level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        Optional<Map.Entry> items = ((EdibleBlockType)this.type.holder().value()).attachable().entrySet().stream().filter(holders -> ((HolderSet)holders.getKey()).contains(stack.getItemHolder())).findFirst();
        if (items.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!this.attachments.isEmpty() && this.attachments.get(items.get().getKey()).items().size() >= Math.min(((EdibleBlockType.AttachmentEntry)items.get().getValue()).maxCount(), (Integer)this.getBlockState().getValue((Property)PlaceableEdibleBlock.BITES))) {
            return InteractionResult.CONSUME;
        }
        this.attachments.compute((HolderSet<Item>)((HolderSet)items.get().getKey()), (set, previous) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            boolean active = false;
            if (previous != null) {
                builder.addAll(previous.items);
                active = previous.active;
            }
            ItemStack stack2 = stack.copy();
            stack2.setCount(1);
            builder.add((Object)stack2);
            return new AttachmentState((List<ItemStack>)builder.build(), active);
        });
        if (((EdibleBlockType.AttachmentEntry)items.get().getValue()).sound().isPresent() && this.level.random.nextFloat() < ((EdibleBlockType.AttachmentEntry)items.get().getValue()).sound().get().chance()) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)((EdibleBlockType.AttachmentEntry)items.get().getValue()).sound().get().sound().value(), SoundSource.BLOCKS, ((EdibleBlockType.AttachmentEntry)items.get().getValue()).sound().get().volume().randomise(this.level.random), ((EdibleBlockType.AttachmentEntry)items.get().getValue()).sound().get().pitch().randomise(this.level.random));
        }
        stack.consume(1, (LivingEntity)player);
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PlaceableEdibleBlock.LIGHT, (Comparable)Integer.valueOf(this.getLightValue())), 4);
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        return InteractionResult.SUCCESS_SERVER;
    }

    public InteractionResult removeAttachmentItem(ItemStack stack) {
        if (this.level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        List items = ((EdibleBlockType)this.type.holder().value()).attachable().entrySet().stream().toList();
        if (items.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        Map.Entry item = (Map.Entry)items.getLast();
        if (!this.attachments.containsKey(item.getKey()) || this.attachments.get(item.getKey()).items.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        ItemStack last = this.attachments.get(item.getKey()).items().getLast();
        if (((EdibleBlockType.AttachmentEntry)item.getValue()).activations().stream().noneMatch(activationEntry -> !activationEntry.setTo() && (activationEntry.ingredient().isEmpty() && stack.isEmpty() || activationEntry.ingredient().isPresent() && activationEntry.ingredient().get().test(stack)))) {
            return InteractionResult.CONSUME;
        }
        if (this.attachments.get(item.getKey()).items().size() == 1) {
            this.attachments.remove(item.getKey());
        } else {
            this.attachments.computeIfPresent((HolderSet<Item>)((HolderSet)item.getKey()), (set, previous) -> {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>(previous.items());
                list.removeLast();
                boolean active = previous.active;
                return new AttachmentState((List<ItemStack>)ImmutableList.copyOf(list), active);
            });
        }
        Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)last);
        if (((EdibleBlockType.AttachmentEntry)item.getValue()).sound().isPresent() && this.level.random.nextFloat() < ((EdibleBlockType.AttachmentEntry)item.getValue()).sound().get().chance()) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)((EdibleBlockType.AttachmentEntry)item.getValue()).sound().get().sound().value(), SoundSource.BLOCKS, ((EdibleBlockType.AttachmentEntry)item.getValue()).sound().get().volume().randomise(this.level.random), ((EdibleBlockType.AttachmentEntry)item.getValue()).sound().get().pitch().randomise(this.level.random));
        }
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PlaceableEdibleBlock.LIGHT, (Comparable)Integer.valueOf(this.getLightValue())), 4);
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        return InteractionResult.SUCCESS_SERVER;
    }

    public int getLightValue() {
        return Math.min(this.getAttachments().values().stream().flatMap(attachmentState -> !attachmentState.active() ? Stream.of(Integer.valueOf(0)) : ((EdibleBlockType)this.getEdibleType().holder().value()).attachable().values().stream().flatMap(attachmentEntry -> attachmentEntry.lightLevel().entrySet().stream().map(lightValue -> {
            if (((EdibleBlockType.BlockValuesEntry)lightValue.getKey()).test(this)) {
                return (Integer)lightValue.getValue();
            }
            return 0;
        }))).reduce(0, Integer::sum), 15);
    }

    public InteractionResult activate(ItemStack stack, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.level.isClientSide()) {
            return InteractionResult.CONSUME;
        }
        List<Pair> activations = ((EdibleBlockType)this.type.holder().value()).attachable().entrySet().stream().map(entry -> Pair.of((Object)((HolderSet)entry.getKey()), ((EdibleBlockType.AttachmentEntry)entry.getValue()).activations().stream().filter(activationEntry -> activationEntry.ingredient().isEmpty() && stack.isEmpty() || activationEntry.ingredient().isPresent() && activationEntry.ingredient().get().test(stack)).toList())).toList();
        if (activations.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        LootParams params = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.BLOCK_STATE, (Object)this.getBlockState()).withParameter(LootContextParams.ORIGIN, (Object)hitResult.getLocation()).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_ENTITY, (Object)this).create(LootContextParamSets.BLOCK);
        LootContext context = new LootContext.Builder(params).create(Optional.empty());
        if (this.attachments.isEmpty() || activations.stream().noneMatch(pair -> ((List)pair.getSecond()).stream().anyMatch(activationEntry -> (activationEntry.condition().isEmpty() || activationEntry.condition().stream().allMatch(condition -> condition.test((Object)context))) && activationEntry.setTo() != (this.attachments.containsKey(pair.getFirst()) && this.attachments.get(pair.getFirst()).active())))) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        activations.forEach(entry -> ((List)entry.getSecond()).forEach(activationEntry -> {
            if (activationEntry.condition().stream().anyMatch(condition -> !condition.test((Object)context))) {
                return;
            }
            this.setAttachmentActive((HolderSet<Item>)((HolderSet)entry.getFirst()), activationEntry.setTo());
            if (activationEntry.sound().isPresent() && this.level.getRandom().nextFloat() < activationEntry.sound().get().chance()) {
                this.level.playSound(null, this.getBlockPos(), (SoundEvent)activationEntry.sound().get().sound().value(), SoundSource.BLOCKS, activationEntry.sound().get().volume().randomise(this.level.random), activationEntry.sound().get().pitch().randomise(this.level.random));
            }
            if (!activationEntry.particles().isEmpty()) {
                activationEntry.particles().forEach((key, value) -> {
                    if (key.test(this)) {
                        value.forEach(particleEntry -> {
                            if (this.level.getRandom().nextFloat() < particleEntry.chance()) {
                                this.level.addParticle(particleEntry.particle(), particleEntry.position().x, particleEntry.position().y, particleEntry.position().z, particleEntry.speed().x, particleEntry.speed().y, particleEntry.speed().z);
                            }
                        });
                    }
                });
            }
        }));
        if (stack.isDamageableItem()) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        } else {
            player.getItemInHand(hand).shrink(1);
        }
        this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PlaceableEdibleBlock.LIGHT, (Comparable)Integer.valueOf(this.getLightValue())), 4);
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        return InteractionResult.SUCCESS_SERVER;
    }

    public void setAttachmentActive(HolderSet<Item> items, boolean value) {
        this.attachments.computeIfPresent(items, (set, previous) -> new AttachmentState(previous.items, value));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("data")) {
            this.setEdibleType((ItemEdible)((Pair)ItemEdible.CODEC.decode((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("data")).getOrThrow()).getFirst());
        }
        this.attachments.clear();
        if (tag.contains("attachments")) {
            this.attachments.putAll((Map)((Pair)ATTACHMENTS_CODEC.decode((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("attachments")).getOrThrow()).getFirst());
        }
        this.resetParticles();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.getEdibleType() != null) {
            tag.put("data", (Tag)ItemEdible.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.getEdibleType()).getOrThrow());
        }
        if (!this.attachments.isEmpty()) {
            tag.put("attachments", (Tag)ATTACHMENTS_CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.attachments).getOrThrow());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(BovinesDataComponents.EDIBLE_TYPE, (Object)this.getEdibleType());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        this.setEdibleType((ItemEdible)input.get(BovinesDataComponents.EDIBLE_TYPE));
    }

    public List<EdibleBlockType.ParticleEntry> getParticles() {
        if (this.particles != null || this.type == null || !this.type.holder().isBound()) {
            return this.particles;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.closestBlockValues());
        this.particles = builder.build();
        return this.particles;
    }

    private List<EdibleBlockType.ParticleEntry> closestBlockValues() {
        EdibleBlockType type = (EdibleBlockType)this.type.holder().value();
        return type.particlePositions().entrySet().stream().filter(entry -> (((EdibleBlockType.BlockValuesEntry)entry.getKey()).biteCount().isEmpty() || ((EdibleBlockType.BlockValuesEntry)entry.getKey()).biteCount().get().test((Integer)this.getBlockState().getValue((Property)PlaceableEdibleBlock.BITES))) && ((EdibleBlockType.BlockValuesEntry)entry.getKey()).attachments().entrySet().stream().allMatch(e -> ((EdibleBlockType.BlockValuesEntry.AttachmentValueEntry)e.getValue()).count().test(!this.attachments.containsKey(e.getKey()) ? 0 : this.attachments.get(e.getKey()).items().size()) && (((EdibleBlockType.BlockValuesEntry.AttachmentValueEntry)e.getValue()).active().isEmpty() || ((EdibleBlockType.BlockValuesEntry.AttachmentValueEntry)e.getValue()).active().get() == (this.attachments.containsKey(e.getKey()) && this.attachments.get(e.getKey()).active)))).flatMap(entry -> ((List)entry.getValue()).stream()).toList();
    }

    private void resetParticles() {
        this.particles = null;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Component getName() {
        if (this.type.holder().isBound()) {
            return BlockUtil.getOrCreateBlockNameTranslationKey(((ResourceKey)this.type.holder().unwrapKey().orElseThrow()).location());
        }
        return BlockUtil.getOrCreateBlockNameTranslationKey(BovinesAndButtercups.asResource("missing_edible"));
    }

    public record AttachmentState(List<ItemStack> items, boolean active) {
        public static final Codec<AttachmentState> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.STRICT_SINGLE_ITEM_CODEC.listOf(1, 16).fieldOf("items").forGetter(AttachmentState::items), (App)Codec.BOOL.fieldOf("active").forGetter(AttachmentState::active)).apply((Applicative)inst, AttachmentState::new));

        @Override
        public String toString() {
            return String.join((CharSequence)",", this.items.stream().map(stack -> String.valueOf(((ResourceKey)stack.getItemHolder().unwrapKey().get()).location()) + "=" + stack.getCount()).toList()) + ",active." + this.active;
        }
    }

    public record EdibleBlockEntityValues(ItemEdible placeableEdible, int bites, Map<HolderSet<Item>, AttachmentState> state) {
        public static EdibleBlockEntityValues fromBlockEntity(PlaceableEdibleBlockEntity blockEntity) {
            return new EdibleBlockEntityValues(Optional.of(blockEntity.getEdibleType()).orElseGet(() -> new ItemEdible((Holder<EdibleBlockType>)blockEntity.level.registryAccess().lookupOrThrow(BovinesRegistryKeys.EDIBLE_BLOCK_TYPE).getOrThrow(EdibleBlockType.MISSING_KEY), List.of())), (Integer)blockEntity.getBlockState().getValue((Property)PlaceableEdibleBlock.BITES), blockEntity.getAttachments());
        }
    }
}

