/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.attachment.LockdownAttachment;
import house.greenhouse.bovinesandbuttercups.content.effect.BovinesEffects;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class LockdownCommand {
    private static final SimpleCommandExceptionType LOCKDOWN_OF_LOCKDOWN = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.bovinesandbuttercups.lockdown.give.failed.lockdown"));
    private static final SimpleCommandExceptionType GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.effect.give.failed"));
    private static final SimpleCommandExceptionType CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.bovinesandbuttercups.lockdown.clear.everything.failed"));
    private static final SimpleCommandExceptionType CLEAR_SPECIFIC_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.bovinesandbuttercups.lockdown.clear.specific.failed"));

    public static void register(CommandNode<CommandSourceStack> root, CommandBuildContext context) {
        LiteralCommandNode lockdownNode = Commands.literal((String)"lockdown").build();
        LiteralCommandNode giveEffectNode = ((LiteralArgumentBuilder)Commands.literal((String)"give").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"effect", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.MOB_EFFECT)).suggests((context2, builder) -> ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.MOB_EFFECT).listSuggestions(context2, builder).thenApply(suggestions -> {
            ArrayList<Suggestion> list = new ArrayList<Suggestion>(suggestions.getList());
            list.removeIf(suggestion -> suggestion.getText().equals(BovinesEffects.LOCKDOWN.getRegisteredName()));
            return new Suggestions(suggestions.getRange(), list);
        })).executes(context1 -> LockdownCommand.addEffect((CommandContext<CommandSourceStack>)context1, (Holder<MobEffect>)ResourceArgument.getMobEffect((CommandContext)context1, (String)"effect"), 30, false))).then(((RequiredArgumentBuilder)Commands.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000000)).executes(context1 -> LockdownCommand.addEffect((CommandContext<CommandSourceStack>)context1, (Holder<MobEffect>)ResourceArgument.getMobEffect((CommandContext)context1, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"seconds"), false))).then(Commands.argument((String)"hideParticles", (ArgumentType)BoolArgumentType.bool()).executes(context1 -> LockdownCommand.addEffect((CommandContext<CommandSourceStack>)context1, (Holder<MobEffect>)ResourceArgument.getMobEffect((CommandContext)context1, (String)"effect"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"seconds"), BoolArgumentType.getBool((CommandContext)context1, (String)"hideParticles")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"infinite").executes(context1 -> LockdownCommand.addEffect((CommandContext<CommandSourceStack>)context1, (Holder<MobEffect>)ResourceArgument.getMobEffect((CommandContext)context1, (String)"effect"), -1, false))).then(Commands.argument((String)"hideParticles", (ArgumentType)BoolArgumentType.bool()).executes(context1 -> LockdownCommand.addEffect((CommandContext<CommandSourceStack>)context1, (Holder<MobEffect>)ResourceArgument.getMobEffect((CommandContext)context1, (String)"effect"), -1, BoolArgumentType.getBool((CommandContext)context1, (String)"hideParticles")))))))).build();
        LiteralCommandNode clearEffectNode = ((LiteralArgumentBuilder)Commands.literal((String)"clear").then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(context1 -> LockdownCommand.clearEffect((CommandContext<CommandSourceStack>)context1, null))).then(Commands.argument((String)"effect", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.MOB_EFFECT)).executes(context1 -> LockdownCommand.clearEffect((CommandContext<CommandSourceStack>)context1, (Holder<MobEffect>)ResourceArgument.getMobEffect((CommandContext)context1, (String)"effect")))))).build();
        lockdownNode.addChild((CommandNode)clearEffectNode);
        lockdownNode.addChild((CommandNode)giveEffectNode);
        root.addChild((CommandNode)lockdownNode);
    }

    private static int addEffect(CommandContext<CommandSourceStack> context, Holder<MobEffect> effect, int specifiedSeconds, boolean hideParticles) throws CommandSyntaxException {
        if (effect.is(BovinesEffects.LOCKDOWN)) {
            throw LOCKDOWN_OF_LOCKDOWN.create();
        }
        Collection entities = EntityArgument.getEntities(context, (String)"targets");
        int ticks = specifiedSeconds != -1 ? specifiedSeconds * 20 : -1;
        int successes = 0;
        Entity firstEntity = null;
        for (Entity entity : entities) {
            if (firstEntity == null) {
                firstEntity = entity;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            boolean lockedEffect = BovinesAndButtercups.getHelper().getLockdownAttachment(living).addLockdownMobEffect(effect, ticks);
            boolean addedLockdown = living.addEffect(new MobEffectInstance(BovinesEffects.LOCKDOWN, ticks, 0, false, !hideParticles));
            if (!lockedEffect && !addedLockdown) continue;
            ++successes;
            LockdownAttachment.sync(living);
        }
        if (successes == 0) {
            throw GIVE_FAILED.create();
        }
        if (entities.size() > 1) {
            int finalSuccesses = successes;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.bovinesandbuttercups.lockdown.give.success.multiple", (Object[])new Object[]{((MobEffect)effect.value()).getDisplayName(), finalSuccesses}), true);
        } else {
            Entity finalFirstEntity = firstEntity;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.bovinesandbuttercups.lockdown.give.success.single", (Object[])new Object[]{((MobEffect)effect.value()).getDisplayName(), finalFirstEntity.getDisplayName()}), true);
        }
        return successes;
    }

    private static int clearEffect(CommandContext<CommandSourceStack> context, @Nullable Holder<MobEffect> effect) throws CommandSyntaxException {
        Collection entities = EntityArgument.getEntities(context, (String)"targets");
        int successes = 0;
        Entity firstEntity = null;
        for (Entity entity : entities) {
            if (firstEntity == null) {
                firstEntity = entity;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if ((effect == null || !BovinesAndButtercups.getHelper().getLockdownAttachment(living).removeLockdownMobEffect(effect)) && (effect != null || !living.removeEffect(BovinesEffects.LOCKDOWN))) continue;
            ++successes;
            LockdownAttachment.sync(living);
            if (!BovinesAndButtercups.getHelper().getLockdownAttachment(living).effects().isEmpty()) continue;
            living.removeEffect(BovinesEffects.LOCKDOWN);
        }
        if (effect == null) {
            if (successes == 0) {
                throw CLEAR_EVERYTHING_FAILED.create();
            }
            if (entities.size() > 1) {
                int finalSuccesses = successes;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.bovinesandbuttercups.lockdown.clear.everything.success.multiple", (Object[])new Object[]{finalSuccesses}), true);
            } else {
                finalFirstEntity = firstEntity;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.bovinesandbuttercups.lockdown.clear.everything.success.single", (Object[])new Object[]{finalFirstEntity.getDisplayName()}), true);
            }
        } else {
            if (successes == 0) {
                throw CLEAR_SPECIFIC_FAILED.create();
            }
            if (entities.size() > 1) {
                int finalSuccesses = successes;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.bovinesandbuttercups.lockdown.clear.specific.success.multiple", (Object[])new Object[]{((MobEffect)effect.value()).getDisplayName(), finalSuccesses}), true);
            } else {
                finalFirstEntity = firstEntity;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.bovinesandbuttercups.lockdown.clear.specific.success.single", (Object[])new Object[]{((MobEffect)effect.value()).getDisplayName(), finalFirstEntity.getDisplayName()}), true);
            }
        }
        return successes;
    }
}

