/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.content.data.flowercrown.FlowerCrownMaterial;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record FlowerCrown(Holder<FlowerCrownMaterial> topLeft, Holder<FlowerCrownMaterial> top, Holder<FlowerCrownMaterial> topRight, Holder<FlowerCrownMaterial> centerLeft, Holder<FlowerCrownMaterial> centerRight, Holder<FlowerCrownMaterial> bottomLeft, Holder<FlowerCrownMaterial> bottom, Holder<FlowerCrownMaterial> bottomRight) implements TooltipProvider
{
    public static final Codec<FlowerCrown> LIST_CODEC = FlowerCrownMaterial.CODEC.listOf(8, 8).comapFlatMap(holders -> DataResult.success((Object)new FlowerCrown((Holder<FlowerCrownMaterial>)((Holder)holders.get(1)), (Holder<FlowerCrownMaterial>)((Holder)holders.get(2)), (Holder<FlowerCrownMaterial>)((Holder)holders.get(3)), (Holder<FlowerCrownMaterial>)((Holder)holders.get(0)), (Holder<FlowerCrownMaterial>)((Holder)holders.get(4)), (Holder<FlowerCrownMaterial>)((Holder)holders.get(7)), (Holder<FlowerCrownMaterial>)((Holder)holders.get(6)), (Holder<FlowerCrownMaterial>)((Holder)holders.get(5)))), flowerCrown -> List.of(flowerCrown.topLeft, flowerCrown.top, flowerCrown.topRight, flowerCrown.centerLeft, flowerCrown.centerRight, flowerCrown.bottomLeft, flowerCrown.bottom, flowerCrown.bottomRight));
    public static final Codec<FlowerCrown> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)FlowerCrownMaterial.CODEC.fieldOf("top_left").forGetter(FlowerCrown::topLeft), (App)FlowerCrownMaterial.CODEC.fieldOf("top").forGetter(FlowerCrown::top), (App)FlowerCrownMaterial.CODEC.fieldOf("top_right").forGetter(FlowerCrown::topRight), (App)FlowerCrownMaterial.CODEC.fieldOf("center_left").forGetter(FlowerCrown::centerLeft), (App)FlowerCrownMaterial.CODEC.fieldOf("center_right").forGetter(FlowerCrown::centerRight), (App)FlowerCrownMaterial.CODEC.fieldOf("bottom_left").forGetter(FlowerCrown::bottomLeft), (App)FlowerCrownMaterial.CODEC.fieldOf("bottom").forGetter(FlowerCrown::bottom), (App)FlowerCrownMaterial.CODEC.fieldOf("bottom_right").forGetter(FlowerCrown::bottomRight)).apply((Applicative)inst, FlowerCrown::new));
    public static final Codec<FlowerCrown> CODEC = Codec.either(DIRECT_CODEC, LIST_CODEC).comapFlatMap(e -> DataResult.success((Object)((FlowerCrown)e.map(flowerCrown -> flowerCrown, flowerCrown -> flowerCrown))), Either::left);
    public static final StreamCodec<RegistryFriendlyByteBuf, FlowerCrown> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FlowerCrown>(){

        public FlowerCrown decode(RegistryFriendlyByteBuf buffer) {
            return new FlowerCrown((Holder<FlowerCrownMaterial>)((Holder)FlowerCrownMaterial.STREAM_CODEC.decode((Object)buffer)), (Holder<FlowerCrownMaterial>)((Holder)FlowerCrownMaterial.STREAM_CODEC.decode((Object)buffer)), (Holder<FlowerCrownMaterial>)((Holder)FlowerCrownMaterial.STREAM_CODEC.decode((Object)buffer)), (Holder<FlowerCrownMaterial>)((Holder)FlowerCrownMaterial.STREAM_CODEC.decode((Object)buffer)), (Holder<FlowerCrownMaterial>)((Holder)FlowerCrownMaterial.STREAM_CODEC.decode((Object)buffer)), (Holder<FlowerCrownMaterial>)((Holder)FlowerCrownMaterial.STREAM_CODEC.decode((Object)buffer)), (Holder<FlowerCrownMaterial>)((Holder)FlowerCrownMaterial.STREAM_CODEC.decode((Object)buffer)), (Holder<FlowerCrownMaterial>)((Holder)FlowerCrownMaterial.STREAM_CODEC.decode((Object)buffer)));
        }

        public void encode(RegistryFriendlyByteBuf buffer, FlowerCrown value) {
            FlowerCrownMaterial.STREAM_CODEC.encode((Object)buffer, value.topLeft());
            FlowerCrownMaterial.STREAM_CODEC.encode((Object)buffer, value.top());
            FlowerCrownMaterial.STREAM_CODEC.encode((Object)buffer, value.topRight());
            FlowerCrownMaterial.STREAM_CODEC.encode((Object)buffer, value.centerLeft());
            FlowerCrownMaterial.STREAM_CODEC.encode((Object)buffer, value.centerRight());
            FlowerCrownMaterial.STREAM_CODEC.encode((Object)buffer, value.bottomLeft());
            FlowerCrownMaterial.STREAM_CODEC.encode((Object)buffer, value.bottom());
            FlowerCrownMaterial.STREAM_CODEC.encode((Object)buffer, value.bottomRight());
        }
    };

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FlowerCrown)) {
            return false;
        }
        FlowerCrown flowerCrown = (FlowerCrown)other;
        return flowerCrown.topLeft.equals(this.topLeft) && flowerCrown.top.equals(this.top) && flowerCrown.topRight.equals(this.topRight) && flowerCrown.centerLeft.equals(this.centerLeft) && flowerCrown.centerRight.equals(this.centerRight) && flowerCrown.bottomLeft.equals(this.bottomLeft) && flowerCrown.bottom.equals(this.bottom) && flowerCrown.bottomRight.equals(this.bottomRight);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topLeft, this.top, this.topRight, this.centerLeft, this.centerRight, this.bottomLeft, this.bottom, this.bottomRight);
    }

    public List<Holder<FlowerCrownMaterial>> getMaterialsInOrder() {
        return List.of(this.topLeft, this.top, this.topRight, this.centerLeft, this.centerRight, this.bottomLeft, this.bottom, this.bottomRight);
    }

    public ItemStack getMaterialForRecipeViewer(int i) {
        List<ItemStack> stacks = Stream.of(this.topLeft, this.top, this.topRight, this.centerLeft, this.centerRight, this.bottomLeft, this.bottom, this.bottomRight).map(holder -> ((FlowerCrownMaterial)holder.value()).ingredient()).toList();
        if (stacks.size() < i) {
            return ItemStack.EMPTY;
        }
        return stacks.get(i);
    }

    public ResourceLocation getEquippedTexture(int i) {
        return Stream.of(this.centerLeft, this.topLeft, this.top, this.topRight, this.centerRight, this.bottomRight, this.bottom, this.bottomLeft).map(holder -> ((FlowerCrownMaterial)holder.value()).equippedTextures().get(i)).toList().get(i);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        Object2IntArrayMap<Holder<FlowerCrownMaterial>> amountMap = this.collectAmount();
        for (Map.Entry entry : amountMap.entrySet()) {
            tooltipAdder.accept((Component)Component.translatable((String)"item.bovinesandbuttercups.flower_crown.petal_amount", (Object[])new Object[]{((FlowerCrownMaterial)((Holder)entry.getKey()).value()).description(), entry.getValue()}));
        }
    }

    private Object2IntArrayMap<Holder<FlowerCrownMaterial>> collectAmount() {
        Object2IntArrayMap map = new Object2IntArrayMap();
        map.compute(this.centerLeft, (holder, integer) -> integer == null ? 1 : integer + 1);
        map.compute(this.topLeft, (holder, integer) -> integer == null ? 1 : integer + 1);
        map.compute(this.top, (holder, integer) -> integer == null ? 1 : integer + 1);
        map.compute(this.topRight, (holder, integer) -> integer == null ? 1 : integer + 1);
        map.compute(this.centerRight, (holder, integer) -> integer == null ? 1 : integer + 1);
        map.compute(this.bottomRight, (holder, integer) -> integer == null ? 1 : integer + 1);
        map.compute(this.bottom, (holder, integer) -> integer == null ? 1 : integer + 1);
        map.compute(this.bottomLeft, (holder, integer) -> integer == null ? 1 : integer + 1);
        return map;
    }
}

