/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.data.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowConfiguration;
import house.greenhouse.bovinesandbuttercups.api.block.BlockReference;
import house.greenhouse.bovinesandbuttercups.api.block.CustomMushroomType;
import house.greenhouse.bovinesandbuttercups.api.variant.CowModelLayer;
import house.greenhouse.bovinesandbuttercups.api.variant.OffspringConditions;
import house.greenhouse.bovinesandbuttercups.api.variant.model.BovinesCowModelTypes;
import house.greenhouse.bovinesandbuttercups.api.variant.model.CowModelType;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistries;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.level.biome.Biome;

public record MooshroomConfiguration(CowConfiguration.Settings settings, BlockReference<Holder<CustomMushroomType>> mushroom, CowModelType model, List<CowModelLayer> layers, Optional<Boolean> canEatFlowers, Optional<MushroomCow.Variant> vanillaType, Optional<ResourceLocation> lootTable, OffspringConditions offspringConditions) implements CowConfiguration
{
    public static final MapCodec<MooshroomConfiguration> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)CowConfiguration.Settings.CODEC.forGetter(MooshroomConfiguration::settings), (App)BlockReference.createCodec(CustomMushroomType.CODEC, "custom_mushroom").fieldOf("mushroom").forGetter(MooshroomConfiguration::mushroom), (App)BovinesRegistries.MODEL_TYPE.byNameCodec().optionalFieldOf("model", (Object)BovinesCowModelTypes.DEFAULT).forGetter(MooshroomConfiguration::model), (App)CowModelLayer.CODEC.listOf().optionalFieldOf("layers", List.of()).forGetter(MooshroomConfiguration::layers), (App)Codec.BOOL.optionalFieldOf("can_eat_flowers").forGetter(MooshroomConfiguration::canEatFlowers), (App)MushroomCow.Variant.CODEC.optionalFieldOf("vanilla_type").forGetter(MooshroomConfiguration::vanillaType), (App)ResourceLocation.CODEC.optionalFieldOf("loot_table").forGetter(MooshroomConfiguration::lootTable), (App)OffspringConditions.CODEC.optionalFieldOf("offspring_conditions", (Object)OffspringConditions.EMPTY).forGetter(MooshroomConfiguration::offspringConditions)).apply((Applicative)inst, MooshroomConfiguration::new));

    public MooshroomConfiguration {
        if (canEatFlowers.isEmpty() && vanillaType.isEmpty()) {
            throw new IllegalArgumentException("Cannot create Mooshroom Cow Variant without specifying either the 'can_eat_flowers' or 'vanilla_type' fields");
        }
    }

    @Override
    public void tick(Entity entity) {
        this.layers.forEach(cowModelLayer -> cowModelLayer.tickTextureModifiers(entity));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSnow(Entity entity) {
        if (!(entity instanceof MushroomCow)) return false;
        MushroomCow mooshroom = (MushroomCow)entity;
        if (!BovinesAndButtercups.getHelper().getMooshroomExtrasAttachment((LivingEntity)mooshroom).hasSnow()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean allowsConversion(Entity entity) {
        if (!(entity instanceof MushroomCow)) return false;
        MushroomCow mooshroom = (MushroomCow)entity;
        if (!BovinesAndButtercups.getHelper().getMooshroomExtrasAttachment((LivingEntity)mooshroom).allowConversion()) return false;
        return true;
    }

    public static MooshroomConfiguration createMissing(RegistryOps.RegistryInfoLookup lookup) {
        return new MooshroomConfiguration(new CowConfiguration.Settings(Optional.of(BovinesAndButtercups.asResource("bovinesandbuttercups/moobloom/missing_mooshroom")), (SimpleWeightedRandomList<HolderSet<Biome>>)SimpleWeightedRandomList.empty(), SimpleWeightedRandomList.empty(), Optional.empty()), new BlockReference<Holder.Reference>(Optional.empty(), Optional.empty(), Optional.of(((RegistryOps.RegistryInfo)lookup.lookup(BovinesRegistryKeys.CUSTOM_MUSHROOM_TYPE).orElseThrow()).getter().getOrThrow(CustomMushroomType.MISSING_KEY))), BovinesCowModelTypes.DEFAULT, List.of(new CowModelLayer(BovinesAndButtercups.asResource("bovinesandbuttercups/mooshroom/mooshroom_mycelium_layer"), List.of())), Optional.of(false), Optional.empty(), Optional.empty(), OffspringConditions.EMPTY);
    }
}

