/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.data.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.variant.modifier.TextureModifierFactory;
import house.greenhouse.bovinesandbuttercups.client.renderer.modifier.ConditionedTextureModifier;
import house.greenhouse.bovinesandbuttercups.content.loot.BovinesLootContextParamSets;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncConditionedTextureModifier;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncCowVariantClientboundPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ConditionedTextureModifierFactory
extends TextureModifierFactory<ConditionedTextureModifier> {
    public static final MapCodec<ConditionedTextureModifierFactory> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(f -> f.id), (App)LootItemCondition.DIRECT_CODEC.validate(lootCondition -> {
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        ValidationContext validationcontext = new ValidationContext((ProblemReporter)problemreporter$collector, BovinesLootContextParamSets.ENTITY);
        lootCondition.validate(validationcontext);
        return problemreporter$collector.getReport().map(err -> DataResult.error(() -> "Validation error in texture modifier condition: " + err)).orElseGet(() -> DataResult.success((Object)lootCondition));
    }).listOf().fieldOf("condition").forGetter(f -> f.condition), (App)Codec.intRange((int)1, (int)16).optionalFieldOf("tick_rate", (Object)1).forGetter(f -> f.tickRate)).apply((Applicative)inst, ConditionedTextureModifierFactory::new));
    private static final WeakHashMap<UUID, Map<ResourceLocation, Boolean>> CONDITION_VALUES = new WeakHashMap();
    private final ResourceLocation id;
    private final List<LootItemCondition> condition;
    private final int tickRate;

    public ConditionedTextureModifierFactory(ResourceLocation id, List<LootItemCondition> condition, int tickRate) {
        this.id = id;
        this.condition = condition;
        this.tickRate = tickRate;
    }

    public ResourceLocation getConditionId() {
        return this.id;
    }

    public boolean getConditionValue(Entity entity) {
        return ((Map)CONDITION_VALUES.getOrDefault(entity.getUUID(), new HashMap())).getOrDefault(this.id, false);
    }

    public void setConditionValue(Entity entity, boolean value) {
        CONDITION_VALUES.computeIfAbsent(entity.getUUID(), uuid -> new HashMap()).put(this.id, value);
    }

    @Override
    protected ConditionedTextureModifier createProvider() {
        return new ConditionedTextureModifier(this.id);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void init(Entity entity) {
        if (entity.level().isClientSide) {
            return;
        }
        LootParams.Builder params = new LootParams.Builder((ServerLevel)entity.level());
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        params.withParameter(LootContextParams.ORIGIN, (Object)entity.position());
        LootContext context = new LootContext.Builder(params.create(BovinesLootContextParamSets.ENTITY)).create(Optional.empty());
        boolean conditionValue = this.condition.stream().allMatch(condition1 -> condition1.test((Object)context));
        this.setConditionValue(entity, conditionValue);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (BovinesAndButtercups.getHelper().getCowVariantAttachment(living) != null) {
                BovinesAndButtercups.getHelper().sendTrackingClientboundPacket(entity, new SyncCowVariantClientboundPacket(entity.getId(), BovinesAndButtercups.getHelper().getCowVariantAttachment(living), false), new SyncConditionedTextureModifier(entity.getId(), this.getConditionId(), conditionValue));
                return;
            }
        }
        BovinesAndButtercups.getHelper().sendTrackingClientboundPacket(entity, new SyncConditionedTextureModifier(entity.getId(), this.getConditionId(), conditionValue));
    }

    @Override
    public void tick(Entity entity) {
        if (entity.level().isClientSide() || entity.tickCount % this.tickRate != 0) {
            return;
        }
        LootParams.Builder params = new LootParams.Builder((ServerLevel)entity.level());
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        params.withParameter(LootContextParams.ORIGIN, (Object)entity.position());
        LootContext context = new LootContext.Builder(params.create(BovinesLootContextParamSets.ENTITY)).create(Optional.empty());
        boolean conditionValue = this.condition.stream().allMatch(condition1 -> condition1.test((Object)context));
        boolean oldConditionValue = this.getConditionValue(entity);
        if (conditionValue != oldConditionValue) {
            this.setConditionValue(entity, conditionValue);
            BovinesAndButtercups.getHelper().sendTrackingClientboundPacket(entity, new SyncConditionedTextureModifier(entity.getId(), this.getConditionId(), conditionValue));
        }
    }

    @Override
    public MapCodec<? extends TextureModifierFactory<?>> codec() {
        return CODEC;
    }
}

