/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.entity;

import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.content.data.configuration.MoobloomConfiguration;
import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import house.greenhouse.bovinesandbuttercups.content.sound.BovinesSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.Nullable;

public class MoobloomNeoForge
extends Moobloom
implements IShearable {
    public MoobloomNeoForge(EntityType<? extends Moobloom> entityType, Level level) {
        super(entityType, level);
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack shears, Level level, BlockPos pos) {
        if (!level.isClientSide()) {
            this.level().playSound(null, (Entity)this, BovinesSoundEvents.MOOBLOOM_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
            this.convertTo(EntityType.COW, ConversionParams.single((Mob)this, (boolean)false, (boolean)false), cow -> {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                if (((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).lootTable().isEmpty()) {
                    return;
                }
                this.dropFromShearingLootTable((ServerLevel)level, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).lootTable().orElseThrow()), shears, (p_390218_, p_390219_) -> {
                    for (int i = 0; i < p_390219_.getCount(); ++i) {
                        p_390218_.addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(1.0), this.getZ(), p_390219_.copyWithCount(1)));
                    }
                });
            });
        }
        return List.of();
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return this.isAlive() && !this.isBaby() && this.shouldAllowShearing();
    }
}

