/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.entity.goal;

import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import house.greenhouse.bovinesandbuttercups.mixin.BeeAccessor;
import house.greenhouse.bovinesandbuttercups.mixin.MobAccessor;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PollinateMoobloomGoal
extends Bee.BaseBeeGoal {
    private final Bee bee;
    private static final int MIN_POLLINATION_TICKS = 400;
    private static final int MIN_FIND_FLOWER_COW_RETRY_COOLDOWN = 20;
    private static final int MAX_FIND_FLOWER_COW_RETRY_COOLDOWN = 60;
    private static final double ARRIVAL_THRESHOLD = 0.1;
    private static final int POSITION_CHANGE_CHANCE = 25;
    private static final float SPEED_MODIFIER = 0.6f;
    private static final float HOVER_POS_OFFSET = 0.33333334f;
    private int successfulPollinatingTicks;
    private int lastSoundPlayedTick;
    private boolean pollinating;
    @Nullable
    private Vec3 hoverPos;
    private int pollinatingTicks;
    private static final int MAX_POLLINATING_TICKS = 600;
    private int remainingCooldownBeforeLocatingNewCow;
    private Moobloom moobloom;

    public PollinateMoobloomGoal(Bee bee) {
        super(bee);
        this.bee = bee;
        this.remainingCooldownBeforeLocatingNewCow = Mth.nextInt((RandomSource)bee.getRandom(), (int)20, (int)60);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canBeeUse() {
        if (this.remainingCooldownBeforeLocatingNewCow > 0) {
            return false;
        }
        if (this.bee.hasNectar()) {
            return false;
        }
        if (this.bee.level().isRaining()) {
            return false;
        }
        if (BovinesAndButtercups.getHelper().getPollinatingMoobloom(this.bee).isPresent()) {
            Entity entity;
            Optional<Entity> entity2 = Optional.ofNullable(((ServerLevel)this.bee.level()).getEntity(BovinesAndButtercups.getHelper().getPollinatingMoobloom(this.bee).get()));
            if (entity2.isPresent() && (entity = entity2.get()) instanceof Moobloom) {
                Moobloom moobloom;
                this.moobloom = moobloom = (Moobloom)entity;
                this.setMoobloom();
                return true;
            }
            return false;
        }
        if (this.moobloom == null && this.bee.hasSavedFlowerPos()) {
            return false;
        }
        Optional<Moobloom> moobloom = this.findMoobloom();
        if (moobloom.isPresent()) {
            this.moobloom = moobloom.get();
            BovinesAndButtercups.getHelper().setPollinatingMoobloom(this.bee, moobloom.get().getUUID());
            this.setMoobloom();
            return true;
        }
        this.remainingCooldownBeforeLocatingNewCow = Mth.nextInt((RandomSource)this.bee.getRandom(), (int)20, (int)60);
        return false;
    }

    private void setMoobloom() {
        this.moobloom.setStandingStillForBeeTicks(600);
        this.moobloom.setBee(this.bee);
        this.bee.setSavedFlowerPos(null);
        ((MobAccessor)this.bee).bovinesandbuttercups$getNavigation().moveTo(this.moobloom.position().x(), this.moobloom.position().y() + this.moobloom.getBoundingBox().getYsize() * 1.5, this.moobloom.position().z(), 1.0);
    }

    public boolean canBeeContinueToUse() {
        if (!this.pollinating) {
            return false;
        }
        if (this.moobloom == null) {
            return false;
        }
        if (this.bee.level().isRaining()) {
            return false;
        }
        if (this.hasPollinatedLongEnough()) {
            return this.bee.getRandom().nextFloat() < 0.2f;
        }
        if (!(this.bee.tickCount % 20 != 0 || this.moobloom.isAlive() && this.moobloom.getLastHurtByMobTimestamp() <= this.moobloom.tickCount - 100)) {
            this.moobloom.setStandingStillForBeeTicks(0);
            this.moobloom.setBee(null);
            BovinesAndButtercups.getHelper().setPollinatingMoobloom(this.bee, null);
            this.bee.setSavedFlowerPos(null);
            this.moobloom = null;
            return false;
        }
        return true;
    }

    private boolean hasPollinatedLongEnough() {
        return this.successfulPollinatingTicks > 400;
    }

    public boolean isPollinating() {
        return this.pollinating;
    }

    public void stopPollinating() {
        this.pollinating = false;
    }

    public void tickCooldown() {
        if (this.remainingCooldownBeforeLocatingNewCow > 0) {
            --this.remainingCooldownBeforeLocatingNewCow;
        }
    }

    public void start() {
        this.successfulPollinatingTicks = 0;
        this.pollinatingTicks = 0;
        this.lastSoundPlayedTick = 0;
        this.pollinating = true;
        this.bee.resetTicksWithoutNectarSinceExitingHive();
    }

    public void stop() {
        if (this.hasPollinatedLongEnough()) {
            ((BeeAccessor)this.bee).bovinesandbuttercups$invokeSetHasNectar(true);
            BovinesAndButtercups.getHelper().setProducesRichHoney((Entity)this.bee, true);
            this.moobloom.setPollinatedResetTicks(1800);
            if (!this.moobloom.level().isClientSide) {
                ((ServerLevel)this.moobloom.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.moobloom.position().x(), this.moobloom.position().y() + 1.4, this.moobloom.position().z(), 8, 0.5, 0.1, 0.4, 0.0);
            }
        }
        this.pollinating = false;
        this.bee.getNavigation().stop();
        if (this.moobloom != null) {
            this.moobloom.setStandingStillForBeeTicks(0);
            this.moobloom.setBee(null);
            BovinesAndButtercups.getHelper().setPollinatingMoobloom(this.bee, null);
            this.moobloom = null;
        }
        this.remainingCooldownBeforeLocatingNewCow = 200;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        Entity entity;
        if (this.moobloom == null) {
            return;
        }
        ++this.pollinatingTicks;
        if (this.pollinatingTicks > 600) {
            this.moobloom.setStandingStillForBeeTicks(0);
            this.moobloom.setBee(null);
            this.bee.setSavedFlowerPos(null);
            BovinesAndButtercups.getHelper().setPollinatingMoobloom(this.bee, null);
            this.moobloom = null;
        } else if (BovinesAndButtercups.getHelper().getPollinatingMoobloom(this.bee).isPresent() && !this.bee.level().isClientSide() && (entity = ((ServerLevel)this.bee.level()).getEntity(BovinesAndButtercups.getHelper().getPollinatingMoobloom(this.bee).get())) instanceof Moobloom) {
            Moobloom moobloom = (Moobloom)entity;
            moobloom.setStandingStillForBeeTicks(600);
            moobloom.setBee(this.bee);
            Vec3 vec3 = moobloom.position().add(0.0, moobloom.getBoundingBox().getYsize() * 1.3, 0.0);
            if (vec3.distanceTo(this.bee.position()) > 1.0) {
                this.hoverPos = vec3;
                this.setWantedPos();
            } else {
                if (this.hoverPos == null) {
                    this.hoverPos = vec3;
                }
                boolean flag = this.bee.position().distanceTo(this.hoverPos) <= 0.1;
                boolean flag1 = true;
                if (!flag && this.pollinatingTicks > 600) {
                    moobloom.setStandingStillForBeeTicks(0);
                    moobloom.setBee(null);
                    this.bee.setSavedFlowerPos(null);
                    BovinesAndButtercups.getHelper().setPollinatingMoobloom(this.bee, null);
                    this.moobloom = null;
                } else {
                    if (flag) {
                        boolean flag2;
                        boolean bl = flag2 = this.bee.getRandom().nextInt(25) == 0;
                        if (flag2) {
                            this.hoverPos = new Vec3(vec3.x() + (double)this.getOffset(), vec3.y(), vec3.z() + (double)this.getOffset());
                            this.bee.getNavigation().stop();
                        } else {
                            flag1 = false;
                        }
                        this.bee.getLookControl().setLookAt(vec3.x(), vec3.y(), vec3.z());
                    }
                    if (flag1) {
                        this.setWantedPos();
                    }
                    ++this.successfulPollinatingTicks;
                    if (this.bee.getRandom().nextFloat() < 0.05f && this.successfulPollinatingTicks > this.lastSoundPlayedTick + 60) {
                        this.lastSoundPlayedTick = this.successfulPollinatingTicks;
                        this.bee.playSound(SoundEvents.BEE_POLLINATE, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private void setWantedPos() {
        this.bee.getMoveControl().setWantedPosition(this.hoverPos.x(), this.hoverPos.y(), this.hoverPos.z(), (double)0.6f);
    }

    private float getOffset() {
        return (this.bee.getRandom().nextFloat() * 2.0f - 1.0f) * 0.33333334f;
    }

    private Optional<Moobloom> findMoobloom() {
        Moobloom moobloom = (Moobloom)((ServerLevel)this.bee.level()).getNearestEntity(Moobloom.class, TargetingConditions.forNonCombat().selector((entity, serverLevel) -> entity.getLastHurtByMobTimestamp() <= entity.tickCount - 100 && serverLevel.getBlockState(entity.blockPosition().above(2)).isAir() && !entity.isBaby() && ((Moobloom)entity).bee == null), null, this.bee.getX(), this.bee.getY(), this.bee.getZ(), this.bee.getBoundingBox().inflate(12.0, 8.0, 12.0));
        return Optional.ofNullable(moobloom);
    }
}

