/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.recipe;

import com.google.common.collect.Lists;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.FlowerCrown;
import house.greenhouse.bovinesandbuttercups.content.data.flowercrown.FlowerCrownMaterial;
import house.greenhouse.bovinesandbuttercups.content.item.BovinesItems;
import house.greenhouse.bovinesandbuttercups.content.recipe.BovinesRecipeSerializers;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FlowerCrownRecipe
extends CustomRecipe {
    private static final NonNullList<Optional<Unit>> SHAPE = NonNullList.of(Optional.empty(), (Object[])new Optional[]{Optional.of(Unit.INSTANCE), Optional.of(Unit.INSTANCE), Optional.of(Unit.INSTANCE), Optional.of(Unit.INSTANCE), Optional.empty(), Optional.of(Unit.INSTANCE), Optional.of(Unit.INSTANCE), Optional.of(Unit.INSTANCE), Optional.of(Unit.INSTANCE)});
    private PlacementInfo info;

    public FlowerCrownRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < input.height(); ++i) {
            for (int j = 0; j < input.width(); ++j) {
                Optional hasItem = (Optional)SHAPE.get(j + i * input.width());
                ItemStack stack = input.getItem(j, i);
                if (hasItem.isEmpty() && !stack.isEmpty() || hasItem.isPresent() && level.registryAccess().lookupOrThrow(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL).stream().noneMatch(petal -> ItemStack.isSameItemSameComponents((ItemStack)petal.ingredient(), (ItemStack)stack))) {
                    return false;
                }
                if (hasItem.isEmpty()) continue;
                list.add(stack);
            }
        }
        return list.size() == 8;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < input.size() && list.size() != 8; ++i) {
            ItemStack inputStack = input.getItem(i);
            if (inputStack.isEmpty()) continue;
            Optional<Holder.Reference> petal = registries.lookupOrThrow(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL).listElements().filter(flowerCrownPetal -> flowerCrownPetal.isBound() && ItemStack.isSameItemSameComponents((ItemStack)((FlowerCrownMaterial)flowerCrownPetal.value()).ingredient(), (ItemStack)inputStack)).findFirst();
            if (petal.isEmpty()) {
                return ItemStack.EMPTY;
            }
            list.add((Holder)petal.get());
        }
        if (list.size() == 8) {
            ItemStack crownStack = new ItemStack((ItemLike)BovinesItems.FLOWER_CROWN);
            crownStack.set(BovinesDataComponents.FLOWER_CROWN, (Object)FlowerCrownRecipe.assembleFlowerCrown(list));
            return crownStack;
        }
        return ItemStack.EMPTY;
    }

    private static FlowerCrown assembleFlowerCrown(List<Holder<FlowerCrownMaterial>> materials) {
        return new FlowerCrown(materials.get(0), materials.get(1), materials.get(2), materials.get(3), materials.get(4), materials.get(5), materials.get(6), materials.get(7));
    }

    public RecipeSerializer<FlowerCrownRecipe> getSerializer() {
        return BovinesRecipeSerializers.FLOWER_CROWN;
    }
}

