/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.recipe.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;

public interface RemainderIngredient {
    public static final ResourceLocation ID = BovinesAndButtercups.asResource("remainder");

    public static MapCodec<RemainderIngredient> createCodec(Constructor constructor) {
        Codec ingredientCodec = Ingredient.CODEC;
        return RecordCodecBuilder.mapCodec(inst -> inst.group((App)ingredientCodec.fieldOf("base").forGetter(RemainderIngredient::base), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.validate(stack -> {
            if (stack.is(Items.AIR)) {
                return DataResult.error(() -> "Item must not be minecraft:air");
            }
            return DataResult.success((Object)stack);
        }).fieldOf("remainder").forGetter(RemainderIngredient::remainder)).apply((Applicative)inst, constructor::construct));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, RemainderIngredient> createStreamCodec(Constructor constructor) {
        return StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RemainderIngredient::base, (StreamCodec)ItemStack.STREAM_CODEC, RemainderIngredient::remainder, constructor::construct);
    }

    public Ingredient base();

    public ItemStack remainder();

    default public boolean test(ItemStack stack) {
        return this.base().test(stack);
    }

    default public Stream<Holder<Item>> items() {
        return this.base().items();
    }

    @FunctionalInterface
    public static interface Constructor {
        public RemainderIngredient construct(Ingredient var1, ItemStack var2);
    }
}

