/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowType;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistries;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public record AddCowTypeSpawnsModifier(Holder<CowType<?>> cowType, Optional<HolderSet<Biome>> excludedBiomes, List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
{
    public static final ResourceLocation ID = BovinesAndButtercups.asResource("add_cow_type_spawns");
    public static final MapCodec<AddCowTypeSpawnsModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BovinesRegistries.COW_TYPE.holderByNameCodec().fieldOf("type").forGetter(AddCowTypeSpawnsModifier::cowType), (App)Biome.LIST_CODEC.optionalFieldOf("excluded_biomes").forGetter(AddCowTypeSpawnsModifier::excludedBiomes), (App)Codec.either((Codec)MobSpawnSettings.SpawnerData.CODEC.listOf(), (Codec)MobSpawnSettings.SpawnerData.CODEC).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(AddCowTypeSpawnsModifier::spawners)).apply((Applicative)builder, AddCowTypeSpawnsModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (!this.cowType.isBound()) {
            return;
        }
        if (ServerLifecycleHooks.getCurrentServer().registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).stream().anyMatch(entry -> entry.type() == this.cowType.value() && entry.configuration().settings() != null && entry.configuration().settings().biomes().unwrap().stream().anyMatch(wrapper -> ((HolderSet)wrapper.data()).contains(biome)) && entry.configuration().settings().biomes().unwrap().stream().anyMatch(wrapper -> wrapper.weight().asInt() > 0)) && phase == BiomeModifier.Phase.ADD && (this.excludedBiomes.isEmpty() || !this.excludedBiomes.get().contains(biome))) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                EntityType type = spawner.type;
                spawns.addSpawn(type.getCategory(), spawner);
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

