/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.content.worldgen.BovinesStructureTypes;
import house.greenhouse.bovinesandbuttercups.mixin.JigsawStructureAccessor;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class RanchStructure
extends JigsawStructure {
    public static final int MAX_TOTAL_STRUCTURE_RANGE = 128;
    public static final MapCodec<RanchStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)RanchStructure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(RanchStructure::getStartPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(RanchStructure::getStartJigsawName), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(RanchStructure::getMaxDepth), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(RanchStructure::getStartHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(RanchStructure::shouldUseExpansionHack), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(RanchStructure::getProjectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(RanchStructure::getMaxDistanceFromCenter), (App)Codec.list((Codec)PoolAliasBinding.CODEC).optionalFieldOf("pool_aliases", List.of()).forGetter(RanchStructure::getPoolAliases), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)DEFAULT_DIMENSION_PADDING).forGetter(RanchStructure::getDimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)DEFAULT_LIQUID_SETTINGS).forGetter(RanchStructure::getLiquidSettings), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.CONFIGURED_FEATURE).optionalFieldOf("allowed_features").forGetter(RanchStructure::getAllowedFeatures), (App)Codec.BOOL.optionalFieldOf("generate_in_fluids", (Object)true).forGetter(RanchStructure::isAbleToGenerateInFluids)).apply((Applicative)builder, RanchStructure::new)).flatXmap(RanchStructure.verifyRange(), RanchStructure.verifyRange());
    private final Optional<HolderSet<ConfiguredFeature<?, ?>>> allowedFeatures;
    private final boolean generateInFluids;
    private int currentlyGeneratingHeight;

    private static Function<RanchStructure, DataResult<RanchStructure>> verifyRange() {
        return structure -> {
            int distanceModifier = switch (structure.terrainAdaptation()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX, TerrainAdjustment.ENCAPSULATE -> 12;
            };
            return structure.getMaxDistanceFromCenter() + distanceModifier > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)structure);
        };
    }

    public RanchStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, boolean usesExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, List<PoolAliasBinding> poolAliasBindings, DimensionPadding dimensionPadding, LiquidSettings liquidSettings, Optional<HolderSet<ConfiguredFeature<?, ?>>> allowedFeatures, boolean generateInFluids) {
        super(settings, startPool, startJigsawName, maxDepth, startHeight, usesExpansionHack, projectStartToHeightmap, maxDistanceFromCenter, poolAliasBindings, dimensionPadding, liquidSettings);
        this.generateInFluids = generateInFluids;
        this.allowedFeatures = allowedFeatures;
    }

    public Holder<StructureTemplatePool> getStartPool() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$getStartPool();
    }

    public Optional<ResourceLocation> getStartJigsawName() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$getStartJigsawName();
    }

    public int getMaxDepth() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$getMaxDepth();
    }

    public HeightProvider getStartHeight() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$getStartHeight();
    }

    public boolean shouldUseExpansionHack() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$shouldUseExpansionHack();
    }

    public Optional<Heightmap.Types> getProjectStartToHeightmap() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$getProjectStartToHeightmap();
    }

    public int getMaxDistanceFromCenter() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$getMaxDistanceFromCenter();
    }

    public List<PoolAliasBinding> getPoolAliases() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$getPoolAliases();
    }

    public DimensionPadding getDimensionPadding() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$getDimensionPadding();
    }

    public LiquidSettings getLiquidSettings() {
        return ((JigsawStructureAccessor)((Object)this)).bovinesandbuttercups$getLiquidSettings();
    }

    public Optional<HolderSet<ConfiguredFeature<?, ?>>> getAllowedFeatures() {
        return this.allowedFeatures;
    }

    public boolean isAbleToGenerateInFluids() {
        return this.generateInFluids;
    }

    public int getCurrentlyGeneratingHeight() {
        return this.currentlyGeneratingHeight;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        int height = this.getStartHeight().sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos pos = new BlockPos(chunkPos.getMinBlockX(), height, chunkPos.getMinBlockZ());
        this.currentlyGeneratingHeight = height;
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.getStartPool(), this.getStartJigsawName(), (int)this.getMaxDepth(), (BlockPos)pos, (boolean)false, this.getProjectStartToHeightmap(), (int)this.getMaxDistanceFromCenter(), (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)this.getDimensionPadding(), (LiquidSettings)this.getLiquidSettings());
    }

    public StructureType<?> type() {
        return BovinesStructureTypes.RANCH;
    }
}

