/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.access.ChunkGeneratorAccess;
import house.greenhouse.bovinesandbuttercups.content.worldgen.RanchStructure;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public class ChunkGeneratorMixin
implements ChunkGeneratorAccess {
    @Unique
    private GenerationStep.Decoration bovinesandbuttercups$step;

    @Inject(method={"getStructureGeneratingAt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/StructureManager;checkStructurePresence(Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/levelgen/structure/Structure;Lnet/minecraft/world/level/levelgen/structure/placement/StructurePlacement;Z)Lnet/minecraft/world/level/levelgen/structure/StructureCheckResult;")}, cancellable=true)
    private static void bovinesandbuttercups$dontLocateRanchesInFluids(Set<Holder<Structure>> structureHoldersSet, LevelReader level, StructureManager structureManager, boolean skipKnownStructures, StructurePlacement placement, ChunkPos chunkPos, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> cir, @Local Holder<Structure> structure) {
        Object object;
        if (structure.isBound() && (object = structure.value()) instanceof RanchStructure) {
            RanchStructure ranch = (RanchStructure)((Object)object);
            BlockPos pos = new BlockPos(chunkPos.getMinBlockX(), ranch.getCurrentlyGeneratingHeight(), chunkPos.getMinBlockZ());
            if (!ranch.isAbleToGenerateInFluids() && !level.getFluidState(pos).isEmpty()) {
                cir.setReturnValue(null);
            }
        }
    }

    @WrapWithCondition(method={"applyBiomeDecoration"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/WorldgenRandom;setFeatureSeed(JII)V", ordinal=0)})
    private boolean bovinesandbuttercups$dontSetFeatureSeedWhenFluidFilledRanch(WorldgenRandom instance, long decorationSeed, int index, int decorationStep, WorldGenLevel level, ChunkAccess chunk, StructureManager structureManager, @Local SectionPos sectionPos, @Local Structure structure) {
        if (structure instanceof RanchStructure) {
            RanchStructure ranch = (RanchStructure)structure;
            Optional<AABB> box = structureManager.startsForStructure(sectionPos, structure).stream().map(start -> AABB.of((BoundingBox)start.getBoundingBox())).reduce((start, start2) -> new AABB(Math.min(start.minX, start2.minX), Math.min(start.minY, start2.minY), Math.min(start.minZ, start2.minZ), Math.max(start.maxX, start2.maxX), Math.max(start.maxY, start2.maxY), Math.max(start.maxZ, start2.maxZ)));
            return box.isPresent() && (ranch.isAbleToGenerateInFluids() || BlockPos.betweenClosedStream((AABB)box.get()).allMatch(pos -> level.getFluidState(pos).isEmpty()));
        }
        return true;
    }

    @WrapWithCondition(method={"applyBiomeDecoration"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/WorldGenLevel;setCurrentlyGenerating(Ljava/util/function/Supplier;)V", ordinal=0)})
    private boolean bovinesandbuttercups$dontSetFluidFilledRanchAsCurrentlyGenerating(WorldGenLevel instance, Supplier<String> currentlyGenerating, WorldGenLevel level, ChunkAccess chunk, StructureManager structureManager, @Local SectionPos sectionPos, @Local Structure structure) {
        if (structure instanceof RanchStructure) {
            RanchStructure ranch = (RanchStructure)structure;
            Optional<AABB> box = structureManager.startsForStructure(sectionPos, structure).stream().map(start -> AABB.of((BoundingBox)start.getBoundingBox())).reduce((start, start2) -> new AABB(Math.min(start.minX, start2.minX), Math.min(start.minY, start2.minY), Math.min(start.minZ, start2.minZ), Math.max(start.maxX, start2.maxX), Math.max(start.maxY, start2.maxY), Math.max(start.maxZ, start2.maxZ)));
            return box.isPresent() && (ranch.isAbleToGenerateInFluids() || BlockPos.betweenClosedStream((AABB)box.get()).allMatch(pos -> level.getFluidState(pos).isEmpty()));
        }
        return true;
    }

    @WrapOperation(method={"applyBiomeDecoration"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/StructureManager;startsForStructure(Lnet/minecraft/core/SectionPos;Lnet/minecraft/world/level/levelgen/structure/Structure;)Ljava/util/List;")})
    private List<StructureStart> bovinesandbuttercups$dontGenerateFluidFilledRanch(StructureManager instance, SectionPos sectionPos, Structure structure, Operation<List<StructureStart>> original, WorldGenLevel level, ChunkAccess chunk, StructureManager structureManager) {
        if (structure instanceof RanchStructure) {
            RanchStructure ranch = (RanchStructure)structure;
            Optional<AABB> box = structureManager.startsForStructure(sectionPos, structure).stream().map(start -> AABB.of((BoundingBox)start.getBoundingBox())).reduce((start, start2) -> new AABB(Math.min(start.minX, start2.minX), Math.min(start.minY, start2.minY), Math.min(start.minZ, start2.minZ), Math.max(start.maxX, start2.maxX), Math.max(start.maxY, start2.maxY), Math.max(start.maxZ, start2.maxZ)));
            if (box.isPresent() && (ranch.isAbleToGenerateInFluids() || BlockPos.betweenClosedStream((AABB)box.get()).allMatch(pos -> level.getFluidState(pos).isEmpty()))) {
                return (List)original.call(new Object[]{instance, sectionPos, structure});
            }
            return List.of();
        }
        return (List)original.call(new Object[]{instance, sectionPos, structure});
    }

    @Inject(method={"applyBiomeDecoration"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/StructureManager;shouldGenerateStructures()Z")})
    private void bovinesandbuttercups$setStep(WorldGenLevel level, ChunkAccess chunkAccess, StructureManager structureManager, CallbackInfo ci, @Local(ordinal=2) int stepValue) {
        for (GenerationStep.Decoration step : GenerationStep.Decoration.values()) {
            if (step.ordinal() != stepValue) continue;
            this.bovinesandbuttercups$step = step;
            break;
        }
    }

    @Override
    public GenerationStep.Decoration bovinesandbuttercups$getStep() {
        return this.bovinesandbuttercups$step;
    }
}

