/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.mixin;

import com.google.gson.JsonElement;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Lifecycle;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowType;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.block.CustomFlowerType;
import house.greenhouse.bovinesandbuttercups.api.block.CustomMushroomType;
import house.greenhouse.bovinesandbuttercups.api.block.EdibleBlockType;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistries;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RegistryDataLoader.class})
public class RegistryDataLoaderMixin {
    @Shadow
    @Final
    private static RegistrationInfo NETWORK_REGISTRATION_INFO;

    @Inject(method={"loadContentsFromManager"}, at={@At(value="TAIL")})
    private static <E> void bovinesandbuttercups$loadMissingTypes(ResourceManager manager, final RegistryOps.RegistryInfoLookup lookup, WritableRegistry<E> registry, Decoder<E> decoder, Map<ResourceKey<?>, Exception> exceptionMap, CallbackInfo ci) {
        if (registry.key() == BovinesRegistryKeys.COW_VARIANT) {
            for (Map.Entry entry : BovinesRegistries.COW_TYPE.entrySet()) {
                registry.register(((CowType)entry.getValue()).defaultKey(), new CowVariant((CowType)entry.getValue(), ((CowType)entry.getValue()).createDefaultConfig(lookup)), RegistrationInfo.BUILT_IN);
            }
        }
        if (registry.key() == BovinesRegistryKeys.CUSTOM_FLOWER_TYPE) {
            registry.register(CustomFlowerType.MISSING_KEY, (Object)CustomFlowerType.MISSING, RegistrationInfo.BUILT_IN);
        }
        if (registry.key() == BovinesRegistryKeys.CUSTOM_MUSHROOM_TYPE) {
            registry.register(CustomMushroomType.MISSING_KEY, (Object)CustomMushroomType.MISSING, RegistrationInfo.BUILT_IN);
        }
        if (registry.key() == BovinesRegistryKeys.EDIBLE_BLOCK_TYPE) {
            registry.register(EdibleBlockType.MISSING_KEY, (Object)EdibleBlockType.missingEdible(new BootstrapContext<EdibleBlockType>(){

                public Holder.Reference<EdibleBlockType> register(ResourceKey<EdibleBlockType> key, EdibleBlockType value, Lifecycle registryLifecycle) {
                    throw new RuntimeException("Cannot register value.");
                }

                public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> registryKey) {
                    return ((RegistryOps.RegistryInfo)lookup.lookup(registryKey).orElseThrow()).getter();
                }
            }), RegistrationInfo.BUILT_IN);
        }
    }

    @Inject(method={"loadElementFromResource"}, at={@At(value="HEAD")}, cancellable=true)
    private static <E> void bovinesandbuttercups$loadContents(WritableRegistry<E> registry, Decoder<E> decoder, RegistryOps<JsonElement> ops, ResourceKey<E> key, Resource resource, RegistrationInfo info, CallbackInfo ci) {
        Optional<CowType> optional;
        if (info == NETWORK_REGISTRATION_INFO) {
            return;
        }
        if (registry.key() == BovinesRegistryKeys.COW_VARIANT && (optional = BovinesRegistries.COW_TYPE.stream().filter(k -> k.defaultKey().location().equals((Object)key.location())).findFirst()).isPresent()) {
            BovinesAndButtercups.LOG.error("Attempted modification of default cow type '{}'. (Skipping).", (Object)optional.get().defaultKey().location());
            ci.cancel();
        }
        if (registry.key() == BovinesRegistryKeys.CUSTOM_FLOWER_TYPE && key.location().equals((Object)CustomFlowerType.MISSING_KEY.location())) {
            BovinesAndButtercups.LOG.error("Attempted modification of default custom flower type '{}'. (Skipping).", (Object)CustomFlowerType.MISSING_KEY.location());
            ci.cancel();
        }
        if (registry.key() == BovinesRegistryKeys.CUSTOM_MUSHROOM_TYPE && key.location().equals((Object)CustomMushroomType.MISSING_KEY.location())) {
            BovinesAndButtercups.LOG.error("Attempted modification of default custom mushroom type '{}'. (Skipping).", (Object)CustomMushroomType.MISSING_KEY.location());
            ci.cancel();
        }
        if (registry.key() == BovinesRegistryKeys.EDIBLE_BLOCK_TYPE && key.location().equals((Object)EdibleBlockType.MISSING_KEY.location())) {
            BovinesAndButtercups.LOG.error("Attempted modification of default edible block type '{}'. (Skipping).", (Object)EdibleBlockType.MISSING_KEY.location());
            ci.cancel();
        }
    }
}

