/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.network.clientbound;

import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import house.greenhouse.bovinesandbuttercups.content.data.modifier.ConditionedTextureModifierFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record SyncConditionedTextureModifier(int entityId, ResourceLocation conditionId, boolean value) implements CustomPacketPayload
{
    public static final ResourceLocation ID = BovinesAndButtercups.asResource("sync_conditioned_texture_modifier");
    public static final CustomPacketPayload.Type<SyncConditionedTextureModifier> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncConditionedTextureModifier> STREAM_CODEC = StreamCodec.of(SyncConditionedTextureModifier::write, SyncConditionedTextureModifier::new);

    public SyncConditionedTextureModifier(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), buf.readResourceLocation(), buf.readBoolean());
    }

    public static void write(RegistryFriendlyByteBuf buf, SyncConditionedTextureModifier packet) {
        buf.writeInt(packet.entityId);
        buf.writeResourceLocation(packet.conditionId);
        buf.writeBoolean(packet.value);
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            CowVariantAttachment cowVariant = BovinesAndButtercups.getHelper().getCowVariantAttachment(living);
            if (cowVariant == null || !cowVariant.cowVariant().isBound()) {
                return;
            }
            ((CowVariant)cowVariant.cowVariant().value()).configuration().layers().stream().flatMap(cowModelLayer -> cowModelLayer.textureModifiers().stream()).filter(textureModifierFactory -> {
                if (textureModifierFactory instanceof ConditionedTextureModifierFactory) {
                    ConditionedTextureModifierFactory conditioned = (ConditionedTextureModifierFactory)textureModifierFactory;
                    return conditioned.getConditionId().equals((Object)this.conditionId);
                }
                return false;
            }).findFirst().ifPresent(condition -> ((ConditionedTextureModifierFactory)condition).setConditionValue(entity, this.value));
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

