/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util;

import house.greenhouse.bovinesandbuttercups.api.BovinesCowVariants;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.content.data.configuration.MooshroomConfiguration;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.level.LevelAccessor;

public class MooshroomSpawnUtil {
    public static int getTotalSpawnWeight(LevelAccessor level, BlockPos pos) {
        int totalWeight = 0;
        for (Holder.Reference cowVariant2 : level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).registryKeySet().stream().map(key -> level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).getOrThrow(key)).filter(cowVariant -> cowVariant.isBound() && ((CowVariant)cowVariant.value()).configuration() instanceof MooshroomConfiguration).toList()) {
            MooshroomConfiguration configuration;
            Optional<WeightedEntry.Wrapper> biome;
            Object c = ((CowVariant)cowVariant2.value()).configuration();
            if (!(c instanceof MooshroomConfiguration) || !(biome = (configuration = (MooshroomConfiguration)c).settings().biomes().unwrap().stream().filter(holderSetWrapper -> ((HolderSet)holderSetWrapper.data()).contains(level.getBiome(pos))).findFirst()).isPresent()) continue;
            totalWeight += biome.get().weight().asInt();
        }
        return totalWeight;
    }

    public static Holder<CowVariant<MooshroomConfiguration>> getMostCommonMooshroomSpawnType(LevelAccessor level, MushroomCow.Variant mushroomType) {
        int largestWeight = 0;
        Holder finalCowVariant = MooshroomSpawnUtil.getMooshroomTypeFromMushroomType(level, mushroomType);
        for (Holder holder : level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).registryKeySet().stream().map(key -> level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).getOrThrow(key)).filter(cowVariant -> {
            MooshroomConfiguration mc;
            Object patt0$temp;
            return cowVariant.isBound() && (patt0$temp = ((CowVariant)cowVariant.value()).configuration()) instanceof MooshroomConfiguration && !(mc = (MooshroomConfiguration)patt0$temp).settings().biomes().isEmpty();
        }).toList()) {
            MooshroomConfiguration configuration;
            int max;
            Object c = ((CowVariant)holder.value()).configuration();
            if (!(c instanceof MooshroomConfiguration) || (max = (configuration = (MooshroomConfiguration)c).settings().biomes().unwrap().stream().map(wrapper -> wrapper.weight().asInt()).max(Comparator.comparingInt(value -> value)).orElse(0).intValue()) <= largestWeight) continue;
            finalCowVariant = holder;
            largestWeight = max;
        }
        return finalCowVariant;
    }

    public static Holder<CowVariant<MooshroomConfiguration>> getMooshroomTypeFromMushroomType(LevelAccessor level, MushroomCow.Variant mushroomType) {
        Registry registry = level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT);
        return (Holder)registry.registryKeySet().stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).filter(cowVariant -> {
            MooshroomConfiguration mc;
            Object patt0$temp = ((CowVariant)cowVariant.value()).configuration();
            return patt0$temp instanceof MooshroomConfiguration && (mc = (MooshroomConfiguration)patt0$temp).vanillaType().isPresent() && mc.vanillaType().get() == mushroomType;
        }).findFirst().orElse(registry.getOrThrow(BovinesCowVariants.MooshroomKeys.MISSING_MOOSHROOM));
    }

    public static Holder<CowVariant<MooshroomConfiguration>> getMooshroomSpawnTypeDependingOnBiome(LevelAccessor level, BlockPos pos, RandomSource random) {
        ArrayList<Holder.Reference> moobloomList = new ArrayList<Holder.Reference>();
        int totalWeight = 0;
        for (Holder.Reference cowVariant2 : level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).registryKeySet().stream().map(key -> level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).getOrThrow(key)).filter(cowVariant -> cowVariant.isBound() && ((CowVariant)cowVariant.value()).configuration() instanceof MooshroomConfiguration && ((CowVariant)cowVariant.value()).configuration() != ((CowVariant)cowVariant.value()).type().defaultConfig()).toList()) {
            MooshroomConfiguration mooshroomConfiguration;
            Optional<WeightedEntry.Wrapper> biome;
            Object c = ((CowVariant)cowVariant2.value()).configuration();
            if (!(c instanceof MooshroomConfiguration) || !(biome = (mooshroomConfiguration = (MooshroomConfiguration)c).settings().biomes().unwrap().stream().filter(holderSetWrapper -> ((HolderSet)holderSetWrapper.data()).contains(level.getBiome(pos))).findFirst()).isPresent()) continue;
            moobloomList.add(cowVariant2);
            totalWeight += biome.get().weight().asInt();
        }
        if (moobloomList.size() == 1) {
            return (Holder)moobloomList.getFirst();
        }
        if (!moobloomList.isEmpty()) {
            int r = Mth.nextInt((RandomSource)random, (int)0, (int)(totalWeight - 1));
            for (Holder holder : moobloomList) {
                int max = ((MooshroomConfiguration)((CowVariant)holder.value()).configuration()).settings().biomes().unwrap().stream().filter(wrapper -> ((HolderSet)wrapper.data()).contains(level.getBiome(pos))).map(wrapper -> wrapper.weight().asInt()).max(Comparator.comparingInt(value -> value)).orElse(0);
                if (!((double)(r -= max) < 0.0)) continue;
                return holder;
            }
        }
        return level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).getOrThrow(BovinesCowVariants.MooshroomKeys.MISSING_MOOSHROOM);
    }
}

