/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util;

import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.attachment.MooshroomExtrasAttachment;
import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import house.greenhouse.bovinesandbuttercups.util.WeatherUtil;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.gameevent.GameEvent;

public class SnowLayerUtil {
    public static InteractionResult removeSnowIfShovel(Entity entity, Player player, InteractionHand hand, ItemStack stack) {
        if (stack.is(ItemTags.SHOVELS) && !WeatherUtil.isInSnowyWeather(entity) && SnowLayerUtil.hasSnow(entity) && !SnowLayerUtil.isSnowLayerPersistent(entity)) {
            entity.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            if (!entity.level().isClientSide) {
                SnowLayerUtil.removeSnowLayer((ServerLevel)entity.level(), entity, SoundSource.PLAYERS);
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void removeSnowLayer(ServerLevel level, Entity entity, SoundSource source) {
        AgeableMob ageable;
        entity.level().playSound(null, entity, SoundEvents.SNOW_BREAK, source, 1.0f, 1.0f);
        SnowLayerUtil.setSnow(entity, false);
        int snowAmount = entity instanceof AgeableMob && (ageable = (AgeableMob)entity).isBaby() ? 1 : 2;
        for (int j = 0; j < snowAmount; ++j) {
            ItemEntity item = entity.spawnAtLocation(level, (ItemLike)Items.SNOWBALL, 1);
            if (item == null) continue;
            item.setDeltaMovement(item.getDeltaMovement().add((double)((entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.1f), (double)(entity.getRandom().nextFloat() * 0.05f), (double)((entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.1f)));
            item.setNoPickUpDelay();
        }
    }

    public static boolean hasSnow(Entity entity) {
        if (entity instanceof Moobloom) {
            Moobloom moobloom = (Moobloom)entity;
            return moobloom.hasSnow();
        }
        if (entity.getType() == EntityType.MOOSHROOM && entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            return BovinesAndButtercups.getHelper().getMooshroomExtrasAttachment((LivingEntity)mooshroom).hasSnow();
        }
        return false;
    }

    public static boolean isSnowLayerPersistent(Entity entity) {
        if (entity instanceof Moobloom) {
            Moobloom moobloom = (Moobloom)entity;
            return moobloom.isSnowLayerPersistent();
        }
        if (entity.getType() == EntityType.MOOSHROOM && entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            return BovinesAndButtercups.getHelper().getMooshroomExtrasAttachment((LivingEntity)mooshroom).snowLayerPersistent();
        }
        return false;
    }

    public static void setSnow(Entity entity, boolean value) {
        if (entity instanceof Moobloom) {
            Moobloom moobloom = (Moobloom)entity;
            moobloom.setSnow(value);
        }
        if (entity.getType() == EntityType.MOOSHROOM && entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            MooshroomExtrasAttachment attachment = BovinesAndButtercups.getHelper().getMooshroomExtrasAttachment((LivingEntity)mooshroom);
            BovinesAndButtercups.getHelper().setMooshroomExtrasAttachment((LivingEntity)mooshroom, new MooshroomExtrasAttachment(value, attachment.snowLayerPersistent(), attachment.allowShearing(), attachment.allowConversion()));
        }
    }
}

