/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.access.MobEffectInstanceLockdownDataAccess;
import house.greenhouse.bovinesandbuttercups.content.effect.BovinesEffects;
import house.greenhouse.bovinesandbuttercups.util.LockdownData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class TooltipUtil {
    public static void millisecondAllowedPotionTooltip(Iterable<MobEffectInstance> effects, Consumer<Component> tooltipAdder, float durationFactor, float ticksPerSecond) {
        ArrayList list = Lists.newArrayList();
        boolean flag = true;
        for (MobEffectInstance effectInstance : effects) {
            flag = false;
            MutableComponent mutablecomponent = Component.translatable((String)effectInstance.getDescriptionId());
            Holder holder = effectInstance.getEffect();
            ((MobEffect)holder.value()).createModifiers(effectInstance.getAmplifier(), (p_331556_, p_330860_) -> list.add(new Pair(p_331556_, p_330860_)));
            if (effectInstance.is(BovinesEffects.LOCKDOWN)) {
                List<LockdownData> dataList = ((MobEffectInstanceLockdownDataAccess)effectInstance).bovinesandbuttercups$getLockdownData();
                for (LockdownData data : dataList) {
                    MobEffectInstance dataInstance = new MobEffectInstance(data.linkedEffect(), data.duration().orElse(effectInstance.getDuration()).intValue());
                    tooltipAdder.accept((Component)Component.translatable((String)"potion.bovinesandbuttercups.lockdown", (Object[])new Object[]{Component.translatable((String)dataInstance.getDescriptionId()), TooltipUtil.formatDuration(dataInstance, durationFactor, ticksPerSecond)}).withStyle(((MobEffect)effectInstance.getEffect().value()).getCategory().getTooltipFormatting()));
                }
                continue;
            }
            if (effectInstance.getAmplifier() > 0) {
                mutablecomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + effectInstance.getAmplifier()))});
            }
            mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, TooltipUtil.formatDuration(effectInstance, durationFactor, ticksPerSecond)});
            tooltipAdder.accept((Component)mutablecomponent.withStyle(((MobEffect)holder.value()).getCategory().getTooltipFormatting()));
        }
        if (flag) {
            tooltipAdder.accept((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        }
        if (!list.isEmpty()) {
            tooltipAdder.accept(CommonComponents.EMPTY);
            tooltipAdder.accept((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list) {
                AttributeModifier attributemodifier = (AttributeModifier)pair.getSecond();
                double d1 = attributemodifier.amount();
                double d0 = attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? attributemodifier.amount() : attributemodifier.amount() * 100.0;
                if (d1 > 0.0) {
                    tooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.plus." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d1 < 0.0)) continue;
                tooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.take." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d0 *= -1.0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }

    public static Component formatDuration(MobEffectInstance effect, float durationFactor, float ticksPerSecond) {
        if (effect.isInfiniteDuration()) {
            return Component.translatable((String)"effect.duration.infinite");
        }
        int i = Mth.floor((float)((float)effect.getDuration() * durationFactor));
        return Component.literal((String)(i < 20 ? TooltipUtil.formatMilliseconds(i, ticksPerSecond) : StringUtil.formatTickDuration((int)i, (float)ticksPerSecond)));
    }

    public static String formatMilliseconds(int ticks, float ticksPerSecond) {
        int m = ticks % 20 * 50;
        int i = Mth.floor((float)((float)ticks / ticksPerSecond));
        int j = i / 60;
        return String.format(Locale.ROOT, "%02d:%02d:%02d", j, i %= 60, m);
    }
}

