/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;

public class WeatherUtil {
    public static boolean isInSnowyWeather(Entity entity) {
        BlockPos pos = entity.blockPosition();
        if (WeatherUtil.isSnowingAt(pos, entity.level())) {
            return true;
        }
        pos = BlockPos.containing((double)pos.getX(), (double)entity.getBoundingBox().maxY, (double)pos.getZ());
        return WeatherUtil.isSnowingAt(pos, entity.level());
    }

    private static boolean isSnowingAt(BlockPos pos, Level level) {
        if (!level.isRaining()) {
            return false;
        }
        if (!level.canSeeSky(pos)) {
            return false;
        }
        if (level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() > pos.getY()) {
            return false;
        }
        Biome biome = (Biome)level.getBiome(pos).value();
        return biome.getPrecipitationAt(pos, level.getSeaLevel()) == Biome.Precipitation.SNOW;
    }
}

