/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util.dfu.fixer;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class NectarDecomponentizeFix
extends DataFix {
    private static final Map<String, String> COMPONENT_TO_ITEM;

    public NectarDecomponentizeFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder idFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), (Type)NamespacedSchema.namespacedString()));
        OpticFinder componentsFinder = type.findField("components");
        return this.fixTypeEverywhereTyped("Decomponentize Nectar fixer", type, typed -> {
            Optional componentTyped;
            Optional optional = typed.getOptional(idFinder);
            if (optional.isPresent() && Objects.equals(((Pair)optional.get()).getSecond(), "bovinesandbuttercups:nectar_bowl") && (componentTyped = typed.getOptionalTyped(componentsFinder)).isPresent()) {
                Typed nonOptionalComponent = (Typed)componentTyped.get();
                Dynamic dynamic = (Dynamic)nonOptionalComponent.getOrCreate(DSL.remainderFinder());
                String nectarId = dynamic.get("bovinesandbuttercups:nectar").asString("bovinesandbuttercups:buttercup_nectar_bowl");
                dynamic = dynamic.remove("bovinesandbuttercups:nectar");
                nonOptionalComponent = nonOptionalComponent.set(DSL.remainderFinder(), (Object)dynamic);
                return typed.set(componentsFinder, nonOptionalComponent).set(idFinder, (Object)Pair.of((Object)References.ITEM_NAME.typeName(), (Object)COMPONENT_TO_ITEM.getOrDefault(nectarId, "bovinesandbuttercups:buttercup_nectar_bowl")));
            }
            return typed;
        });
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"bovinesandbuttercups:bird_of_paradise", (Object)"bovinesandbuttercups:bird_of_paradise_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:buttercup", (Object)"bovinesandbuttercups:buttercup_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:camellia", (Object)"bovinesandbuttercups:camellia_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:chargelily", (Object)"bovinesandbuttercups:chargelily_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:freesia", (Object)"bovinesandbuttercups:freesia_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:hyacinth", (Object)"bovinesandbuttercups:hyacinth_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:limelight", (Object)"bovinesandbuttercups:limelight_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:lingholm", (Object)"bovinesandbuttercups:lingholm_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:pink_daisy", (Object)"bovinesandbuttercups:pink_daisy_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:snowdrop", (Object)"bovinesandbuttercups:snowdrop_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:sombercup", (Object)"bovinesandbuttercups:sombercup_nectar_bowl");
        builder.put((Object)"bovinesandbuttercups:tropical_blue", (Object)"bovinesandbuttercups:tropical_blue_nectar_bowl");
        COMPONENT_TO_ITEM = builder.build();
    }
}

