/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.brigadier.CommandDispatcher;
import io.wispforest.owo.Owo;
import io.wispforest.owo.client.screens.ScreenInternals;
import io.wispforest.owo.command.debug.OwoDebugCommands;
import io.wispforest.owo.config.OwoConfigCommand;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.itemgroup.json.OwoItemGroupLoader;
import io.wispforest.owo.moddata.ModDataLoader;
import io.wispforest.owo.shader.BlurProgram;
import io.wispforest.owo.shader.GlProgram;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import io.wispforest.owo.ui.util.NinePatchTexture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@Mod(value="owo", dist={Dist.CLIENT})
@ApiStatus.Internal
public class OwoClient {
    private static final String LINUX_RENDERDOC_WARNING = "\n========================================\nIgnored 'owo.renderdocPath' property as this Minecraft instance is not running on Windows.\nPlease populate the LD_PRELOAD environment variable instead\n========================================";
    private static final String MAC_RENDERDOC_WARNING = "\n========================================\nIgnored 'owo.renderdocPath' property as this Minecraft instance is not running on Windows.\nRenderDoc is not supported on macOS\n========================================";
    private static final String GENERIC_RENDERDOC_WARNING = "\n========================================\nIgnored 'owo.renderdocPath' property as this Minecraft instance is not running on Windows.\n========================================";
    public static final GlProgram HSV_PROGRAM = new GlProgram(ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"spectrum"), DefaultVertexFormat.POSITION_COLOR);
    public static final BlurProgram BLUR_PROGRAM = new BlurProgram();

    public OwoClient(IEventBus modBus) {
        ModDataLoader.load(OwoItemGroupLoader.INSTANCE);
        OwoItemGroupLoader.initItemGroupCallback();
        modBus.addListener(event -> {
            event.registerReloadListener((PreparableReloadListener)new UIModelLoader());
            event.registerReloadListener((PreparableReloadListener)new NinePatchTexture.MetadataLoader());
            event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(this){

                protected Void prepare(ResourceManager manager, ProfilerFiller profiler) {
                    return null;
                }

                protected void apply(Void prepared, ResourceManager manager, ProfilerFiller profiler) {
                    GlProgram.loadAndSetupPrograms();
                }
            });
        });
        ScreenInternals.Client.init();
        NeoForge.EVENT_BUS.addListener(event -> OwoConfigCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext()));
        if (Owo.DEBUG) {
            OwoDebugCommands.Client.register();
        }
        modBus.addListener(FMLClientSetupEvent.class, event -> ConfigScreenProviders.forEach((modId, screenFactory) -> ModList.get().getModContainerById(modId).ifPresent(mod -> mod.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer, modsScreen) -> (Screen)screenFactory.apply(modsScreen))))));
    }
}

