/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup;

import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import io.wispforest.owo.mixin.itemgroup.ItemGroupAccessor;
import io.wispforest.owo.util.pond.OwoItemExtensions;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public abstract class OwoItemGroup
extends CreativeModeTab {
    public static final BiConsumer<Item, CreativeModeTab.Output> DEFAULT_STACK_GENERATOR = (item, stacks) -> stacks.accept(item.getDefaultInstance());
    protected static final ItemGroupTab PLACEHOLDER_TAB = new ItemGroupTab(Icon.of((ItemLike)Items.AIR), (Component)Component.empty(), (br, uh) -> {}, ItemGroupTab.DEFAULT_TEXTURE, false);
    public final List<ItemGroupTab> tabs = new ArrayList<ItemGroupTab>();
    public final List<ItemGroupButton> buttons = new ArrayList<ItemGroupButton>();
    private final Consumer<OwoItemGroup> initializer;
    private final Supplier<Icon> iconSupplier;
    private Icon icon;
    private final IntSet activeTabs = new IntAVLTreeSet((Comparator)IntComparators.NATURAL_COMPARATOR);
    private final IntSet activeTabsView = IntSets.unmodifiable((IntSet)this.activeTabs);
    private boolean initialized = false;
    @Nullable
    private final ResourceLocation backgroundTexture;
    @Nullable
    private final ScrollerTextures scrollerTextures;
    @Nullable
    private final TabTextures tabTextures;
    private final int tabStackHeight;
    private final int buttonStackHeight;
    private final boolean useDynamicTitle;
    private final boolean displaySingleTab;
    private final boolean allowMultiSelect;

    protected OwoItemGroup(ResourceLocation id, Consumer<OwoItemGroup> initializer, Supplier<Icon> iconSupplier, int tabStackHeight, int buttonStackHeight, @Nullable ResourceLocation backgroundTexture, @Nullable ScrollerTextures scrollerTextures, @Nullable TabTextures tabTextures, boolean useDynamicTitle, boolean displaySingleTab, boolean allowMultiSelect) {
        super(null, -1, CreativeModeTab.Type.CATEGORY, (Component)Component.translatable((String)"itemGroup.%s.%s".formatted(id.getNamespace(), id.getPath())), () -> ItemStack.EMPTY, (displayContext, entries) -> {}, null, false, 89, ResourceLocation.withDefaultNamespace((String)"textures/gui/container/creative_inventory/tabs.png"), 0x404040, -2130706433, new ArrayList(), new ArrayList());
        this.initializer = initializer;
        this.iconSupplier = iconSupplier;
        this.tabStackHeight = tabStackHeight;
        this.buttonStackHeight = buttonStackHeight;
        this.backgroundTexture = backgroundTexture;
        this.scrollerTextures = scrollerTextures;
        this.tabTextures = tabTextures;
        this.useDynamicTitle = useDynamicTitle;
        this.displaySingleTab = displaySingleTab;
        this.allowMultiSelect = allowMultiSelect;
        ((ItemGroupAccessor)((Object)this)).owo$setEntryCollector((context, entries) -> {
            if (!this.initialized) {
                throw new IllegalStateException("o\u03c9o item group not initialized, was 'initialize()' called?");
            }
            this.activeTabs.forEach(tabIdx -> {
                this.tabs.get(tabIdx).contentSupplier().addItems(context, entries);
                this.collectItemsFromRegistry(entries, tabIdx);
            });
        });
    }

    public static Builder builder(ResourceLocation id, Supplier<Icon> iconSupplier) {
        return new Builder(id, iconSupplier);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.initializer.accept(this);
        }
        if (this.tabs.isEmpty()) {
            this.tabs.add(PLACEHOLDER_TAB);
        }
        if (this.allowMultiSelect) {
            for (int tabIdx = 0; tabIdx < this.tabs.size(); ++tabIdx) {
                if (!this.tabs.get(tabIdx).primary()) continue;
                this.activeTabs.add(tabIdx);
            }
            if (this.activeTabs.isEmpty()) {
                this.activeTabs.add(0);
            }
        } else {
            this.activeTabs.add(0);
        }
        this.initialized = true;
    }

    public void addButton(ItemGroupButton button) {
        this.buttons.add(button);
    }

    public void addTab(Icon icon, String name, @Nullable TagKey<Item> contentTag, ResourceLocation texture, boolean primary) {
        this.tabs.add(new ItemGroupTab(icon, ButtonDefinition.tooltipFor(this, "tab", name), contentTag == null ? (context, entries) -> {} : (context, entries) -> BuiltInRegistries.ITEM.stream().filter(item -> item.builtInRegistryHolder().is(contentTag)).forEach(arg_0 -> ((CreativeModeTab.Output)entries).accept(arg_0)), texture, primary));
    }

    public void addTab(Icon icon, String name, @Nullable TagKey<Item> contentTag, boolean primary) {
        this.addTab(icon, name, contentTag, ItemGroupTab.DEFAULT_TEXTURE, primary);
    }

    public void addCustomTab(Icon icon, String name, ItemGroupTab.ContentSupplier contentSupplier, ResourceLocation texture, boolean primary) {
        this.tabs.add(new ItemGroupTab(icon, ButtonDefinition.tooltipFor(this, "tab", name), contentSupplier, texture, primary));
    }

    public void addCustomTab(Icon icon, String name, ItemGroupTab.ContentSupplier contentSupplier, boolean primary) {
        this.addCustomTab(icon, name, contentSupplier, ItemGroupTab.DEFAULT_TEXTURE, primary);
    }

    public void buildContents(CreativeModeTab.ItemDisplayParameters context) {
        super.buildContents(context);
        SearchOnlyEntries searchEntries = new SearchOnlyEntries(this, context.enabledFeatures());
        this.collectItemsFromRegistry((CreativeModeTab.Output)searchEntries, -1);
        this.tabs.forEach(tab -> tab.contentSupplier().addItems(context, (CreativeModeTab.Output)searchEntries));
        ((ItemGroupAccessor)((Object)this)).owo$setSearchTabStacks(searchEntries.searchTabContents);
    }

    protected void collectItemsFromRegistry(CreativeModeTab.Output entries, int tab) {
        BuiltInRegistries.ITEM.stream().filter(item -> ((OwoItemExtensions)item).owo$group() == this && (tab < 0 || tab == ((OwoItemExtensions)item).owo$tab())).forEach(item -> ((OwoItemExtensions)item).owo$stackGenerator().accept((Item)item, entries));
    }

    public void selectSingleTab(int tab, CreativeModeTab.ItemDisplayParameters context) {
        this.activeTabs.clear();
        this.activeTabs.add(tab);
        this.buildContents(context);
    }

    public void selectTab(int tab, CreativeModeTab.ItemDisplayParameters context) {
        if (!this.allowMultiSelect) {
            this.activeTabs.clear();
        }
        this.activeTabs.add(tab);
        this.buildContents(context);
    }

    public void deselectTab(int tab, CreativeModeTab.ItemDisplayParameters context) {
        if (!this.allowMultiSelect) {
            return;
        }
        this.activeTabs.remove(tab);
        if (this.activeTabs.isEmpty()) {
            for (int tabIdx = 0; tabIdx < this.tabs.size(); ++tabIdx) {
                this.activeTabs.add(tabIdx);
            }
        }
        this.buildContents(context);
    }

    public void toggleTab(int tab, CreativeModeTab.ItemDisplayParameters context) {
        if (this.isTabSelected(tab)) {
            this.deselectTab(tab, context);
        } else {
            this.selectTab(tab, context);
        }
    }

    public IntSet selectedTabs() {
        return this.activeTabsView;
    }

    public boolean isTabSelected(int tab) {
        return this.activeTabs.contains(tab);
    }

    @Nullable
    public ResourceLocation getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Nullable
    public ScrollerTextures getScrollerTextures() {
        return this.scrollerTextures;
    }

    @Nullable
    public TabTextures getTabTextures() {
        return this.tabTextures;
    }

    public int getTabStackHeight() {
        return this.tabStackHeight;
    }

    public int getButtonStackHeight() {
        return this.buttonStackHeight;
    }

    public boolean hasDynamicTitle() {
        return this.useDynamicTitle && (this.tabs.size() > 1 || this.shouldDisplaySingleTab());
    }

    public boolean shouldDisplaySingleTab() {
        return this.displaySingleTab;
    }

    public boolean canSelectMultipleTabs() {
        return this.allowMultiSelect;
    }

    public List<ItemGroupButton> getButtons() {
        return this.buttons;
    }

    public ItemGroupTab getTab(int index) {
        return index < this.tabs.size() ? this.tabs.get(index) : null;
    }

    public Icon icon() {
        return this.icon == null ? (this.icon = this.iconSupplier.get()) : this.icon;
    }

    public boolean shouldDisplay() {
        return true;
    }

    public ResourceLocation id() {
        return BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)this);
    }

    public boolean hasAnyItems() {
        return true;
    }

    public record ScrollerTextures(ResourceLocation enabled, ResourceLocation disabled) {
    }

    public record TabTextures(ResourceLocation topSelected, ResourceLocation topSelectedFirstColumn, ResourceLocation topUnselected, ResourceLocation bottomSelected, ResourceLocation bottomSelectedFirstColumn, ResourceLocation bottomUnselected) {
    }

    public static class Builder {
        private final ResourceLocation id;
        private final Supplier<Icon> iconSupplier;
        private Consumer<OwoItemGroup> initializer = owoItemGroup -> {};
        private int tabStackHeight = 4;
        private int buttonStackHeight = 4;
        @Nullable
        private ResourceLocation backgroundTexture = null;
        @Nullable
        private ScrollerTextures scrollerTextures = null;
        @Nullable
        private TabTextures tabTextures = null;
        private boolean useDynamicTitle = true;
        private boolean displaySingleTab = false;
        private boolean allowMultiSelect = true;

        private Builder(ResourceLocation id, Supplier<Icon> iconSupplier) {
            this.id = id;
            this.iconSupplier = iconSupplier;
        }

        public Builder initializer(Consumer<OwoItemGroup> initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder tabStackHeight(int tabStackHeight) {
            this.tabStackHeight = tabStackHeight;
            return this;
        }

        public Builder buttonStackHeight(int buttonStackHeight) {
            this.buttonStackHeight = buttonStackHeight;
            return this;
        }

        public Builder backgroundTexture(@Nullable ResourceLocation backgroundTexture) {
            this.backgroundTexture = backgroundTexture;
            return this;
        }

        public Builder scrollerTextures(ScrollerTextures scrollerTextures) {
            this.scrollerTextures = scrollerTextures;
            return this;
        }

        public Builder tabTextures(TabTextures tabTextures) {
            this.tabTextures = tabTextures;
            return this;
        }

        public Builder disableDynamicTitle() {
            this.useDynamicTitle = false;
            return this;
        }

        public Builder displaySingleTab() {
            this.displaySingleTab = true;
            return this;
        }

        public Builder withoutMultipleSelection() {
            this.allowMultiSelect = false;
            return this;
        }

        public OwoItemGroup build() {
            OwoItemGroup group = new OwoItemGroup(this, this.id, this.initializer, this.iconSupplier, this.tabStackHeight, this.buttonStackHeight, this.backgroundTexture, this.scrollerTextures, this.tabTextures, this.useDynamicTitle, this.displaySingleTab, this.allowMultiSelect){};
            Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (ResourceLocation)this.id, (Object)((Object)group));
            return group;
        }
    }

    public static interface ButtonDefinition {
        public Icon icon();

        public ResourceLocation texture();

        public Component tooltip();

        public static Component tooltipFor(CreativeModeTab group, String component, String componentName) {
            ResourceLocation registryId = BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)group);
            String groupId = registryId.getNamespace().equals("minecraft") ? registryId.getPath() : registryId.getNamespace() + "." + registryId.getPath();
            return Component.translatable((String)("itemGroup." + groupId + "." + component + "." + componentName));
        }
    }

    protected static class SearchOnlyEntries
    extends CreativeModeTab.ItemDisplayBuilder {
        public SearchOnlyEntries(CreativeModeTab group, FeatureFlagSet enabledFeatures) {
            super(group, enabledFeatures);
        }

        public void accept(ItemStack stack, CreativeModeTab.TabVisibility visibility) {
            if (visibility == CreativeModeTab.TabVisibility.PARENT_TAB_ONLY) {
                return;
            }
            super.accept(stack, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        }
    }
}

