/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.edm;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.owo.serialization.format.ContextHolder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EdmOps
implements DynamicOps<EdmElement<?>>,
ContextHolder {
    private static final EdmOps NO_CONTEXT = new EdmOps(SerializationContext.empty());
    private final SerializationContext capturedContext;

    private EdmOps(SerializationContext capturedContext) {
        this.capturedContext = capturedContext;
    }

    public static EdmOps withContext(SerializationContext context) {
        return new EdmOps(context);
    }

    public static EdmOps withoutContext() {
        return NO_CONTEXT;
    }

    @Override
    public SerializationContext capturedContext() {
        return this.capturedContext;
    }

    public EdmElement<?> empty() {
        return EdmElement.EMPTY;
    }

    public EdmElement<?> createNumeric(Number number) {
        return EdmElement.f64((double)number.doubleValue());
    }

    public EdmElement<?> createByte(byte b) {
        return EdmElement.i8((byte)b);
    }

    public EdmElement<?> createShort(short s) {
        return EdmElement.i16((short)s);
    }

    public EdmElement<?> createInt(int i) {
        return EdmElement.i32((int)i);
    }

    public EdmElement<?> createLong(long l) {
        return EdmElement.i64((long)l);
    }

    public EdmElement<?> createFloat(float f) {
        return EdmElement.f32((float)f);
    }

    public EdmElement<?> createDouble(double d) {
        return EdmElement.f64((double)d);
    }

    public EdmElement<?> createBoolean(boolean bl) {
        return EdmElement.bool((boolean)bl);
    }

    public EdmElement<?> createString(String value) {
        return EdmElement.string((String)value);
    }

    public EdmElement<?> createByteList(ByteBuffer input) {
        return EdmElement.bytes((byte[])DataFixUtils.toArray((ByteBuffer)input));
    }

    public EdmElement<?> createList(Stream<EdmElement<?>> input) {
        return EdmElement.sequence(input.toList());
    }

    public DataResult<EdmElement<?>> mergeToList(EdmElement<?> list, EdmElement<?> value) {
        if (list == this.empty()) {
            return DataResult.success((Object)EdmElement.sequence(List.of(value)));
        }
        Object object = list.value();
        if (object instanceof List) {
            List properList = (List)object;
            ArrayList newList = new ArrayList(properList);
            newList.add(value);
            return DataResult.success((Object)EdmElement.sequence(newList));
        }
        return DataResult.error(() -> "Not a sequence: " + String.valueOf(list));
    }

    public EdmElement<?> createMap(Stream<Pair<EdmElement<?>, EdmElement<?>>> map) {
        return EdmElement.consumeMap(map.collect(Collectors.toMap(pair -> (String)((EdmElement)pair.getFirst()).cast(), Pair::getSecond)));
    }

    public DataResult<EdmElement<?>> mergeToMap(EdmElement<?> map, EdmElement<?> key, EdmElement<?> value) {
        if (!(key.value() instanceof String)) {
            return DataResult.error(() -> "Key is not a string: " + String.valueOf(key));
        }
        if (map == this.empty()) {
            return DataResult.success((Object)EdmElement.consumeMap(Map.of((String)key.cast(), value)));
        }
        Object object = map.value();
        if (object instanceof Map) {
            Map properMap = (Map)object;
            HashMap newMap = new HashMap(properMap);
            newMap.put((String)key.cast(), value);
            return DataResult.success((Object)EdmElement.consumeMap(newMap));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(map));
    }

    public DataResult<Number> getNumberValue(EdmElement<?> input) {
        Object object = input.value();
        if (object instanceof Number) {
            Number number = (Number)object;
            return DataResult.success((Object)number);
        }
        return DataResult.error(() -> "Not a number: " + String.valueOf(input));
    }

    public DataResult<Boolean> getBooleanValue(EdmElement<?> input) {
        Object object = input.value();
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return DataResult.success((Object)bl);
        }
        object = input.value();
        if (object instanceof Byte) {
            Byte b = (Byte)object;
            return DataResult.success((Object)(b == 1 ? 1 : 0));
        }
        return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
    }

    public DataResult<String> getStringValue(EdmElement<?> input) {
        Object object = input.value();
        if (object instanceof String) {
            String string = (String)object;
            return DataResult.success((Object)string);
        }
        return DataResult.error(() -> "Not a string: " + String.valueOf(input));
    }

    public DataResult<ByteBuffer> getByteBuffer(EdmElement<?> input) {
        Object object = input.value();
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return DataResult.success((Object)ByteBuffer.wrap(bytes));
        }
        return DataResult.error(() -> "Not bytes: " + String.valueOf(input));
    }

    public DataResult<Stream<EdmElement<?>>> getStream(EdmElement<?> input) {
        if (input == this.empty()) {
            return DataResult.success(Stream.of(new EdmElement[0]));
        }
        Object object = input.value();
        if (object instanceof List) {
            List list = (List)object;
            return DataResult.success(list.stream().map(o -> (EdmElement)o));
        }
        return DataResult.error(() -> "Not a sequence: " + String.valueOf(input));
    }

    public DataResult<Stream<Pair<EdmElement<?>, EdmElement<?>>>> getMapValues(EdmElement<?> input) {
        if (input == this.empty()) {
            return DataResult.success(Stream.of(new Pair[0]));
        }
        Object object = input.value();
        if (object instanceof Map) {
            Map map = (Map)object;
            return DataResult.success(map.entrySet().stream().map(entry -> new Pair((Object)EdmElement.string((String)((String)entry.getKey())), entry.getValue())));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(input));
    }

    public <U> U convertTo(DynamicOps<U> outOps, EdmElement<?> input) {
        if (input == this.empty()) {
            return (U)outOps.empty();
        }
        return (U)(switch (input.type()) {
            default -> throw new MatchException(null, null);
            case EdmElement.Type.I8, EdmElement.Type.U8 -> outOps.createByte(((Byte)input.cast()).byteValue());
            case EdmElement.Type.I16, EdmElement.Type.U16 -> outOps.createShort(((Short)input.cast()).shortValue());
            case EdmElement.Type.I32, EdmElement.Type.U32 -> outOps.createInt(((Integer)input.cast()).intValue());
            case EdmElement.Type.I64, EdmElement.Type.U64 -> outOps.createLong(((Long)input.cast()).longValue());
            case EdmElement.Type.F32 -> outOps.createFloat(((Float)input.cast()).floatValue());
            case EdmElement.Type.F64 -> outOps.createDouble(((Double)input.cast()).doubleValue());
            case EdmElement.Type.BOOLEAN -> outOps.createBoolean(((Boolean)input.cast()).booleanValue());
            case EdmElement.Type.STRING -> outOps.createString((String)input.cast());
            case EdmElement.Type.BYTES -> outOps.createByteList(ByteBuffer.wrap((byte[])input.cast()));
            case EdmElement.Type.OPTIONAL -> ((Optional)input.cast()).map(element -> this.convertTo(outOps, (EdmElement<?>)element)).orElse(outOps.empty());
            case EdmElement.Type.SEQUENCE -> outOps.createList(((List)input.cast()).stream().map(element -> this.convertTo(outOps, (EdmElement<?>)element)));
            case EdmElement.Type.MAP -> outOps.createMap(((Map)input.cast()).entrySet().stream().map(entry -> new Pair(outOps.createString((String)entry.getKey()), this.convertTo(outOps, (EdmElement)entry.getValue()))));
        });
    }

    public EdmElement<?> remove(EdmElement<?> input, String key) {
        Object object = input.value();
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap newMap = new HashMap(map);
            newMap.remove(key);
            return EdmElement.consumeMap(newMap);
        }
        return input;
    }
}

