/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.shader;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import io.wispforest.owo.shader.GlProgram;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL30;

public class BlurProgram
extends GlProgram {
    private Uniform inputResolution;
    private Uniform directions;
    private Uniform quality;
    private Uniform size;
    private RenderTarget input;

    public BlurProgram() {
        super(ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"blur"), DefaultVertexFormat.POSITION);
        WindowResizeCallback.EVENT.register((client, window) -> {
            if (this.input == null) {
                return;
            }
            this.input.resize(window.getWidth(), window.getHeight());
        });
    }

    public void setParameters(int directions, float quality, float size) {
        this.directions.set((float)directions);
        this.size.set(size);
        this.quality.set(quality);
    }

    @Override
    public void use() {
        RenderTarget buffer = Minecraft.getInstance().getMainRenderTarget();
        this.input.bindWrite(false);
        GL30.glBindFramebuffer((int)36008, (int)buffer.frameBufferId);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)buffer.width, (int)buffer.height, (int)0, (int)0, (int)buffer.width, (int)buffer.height, (int)16384, (int)9729);
        buffer.bindWrite(false);
        this.inputResolution.set((float)buffer.width, (float)buffer.height);
        this.backingProgram.bindSampler("InputSampler", this.input.getColorTextureId());
        super.use();
    }

    @Override
    protected void setup() {
        this.inputResolution = this.findUniform("InputResolution");
        this.directions = this.findUniform("Directions");
        this.quality = this.findUniform("Quality");
        this.size = this.findUniform("Size");
        Window window = Minecraft.getInstance().getWindow();
        this.input = new TextureTarget(window.getWidth(), window.getHeight(), false);
    }
}

