/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import io.wispforest.owo.ui.container.WrappingParentComponent;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.util.ScissorStack;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@ApiStatus.Experimental
public class RenderEffectWrapper<C extends Component>
extends WrappingParentComponent<C> {
    @Nullable
    private static RenderTarget currentFramebuffer = null;
    protected static final List<RenderTarget> FRAMEBUFFERS = new ArrayList<RenderTarget>();
    protected static int drawDepth = 0;
    protected final List<RenderEffectSlot> effects = new ArrayList<RenderEffectSlot>();

    protected RenderEffectWrapper(C child) {
        super(Sizing.content(), Sizing.content(), child);
        this.allowOverflow = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        context.flush();
        try {
            ++drawDepth;
            Window window = Minecraft.getInstance().getWindow();
            while (drawDepth > FRAMEBUFFERS.size()) {
                FRAMEBUFFERS.add((RenderTarget)new TextureTarget(window.getWidth(), window.getHeight(), true));
            }
            int previousFramebuffer = GlStateManager.getBoundFramebuffer();
            RenderTarget framebuffer = FRAMEBUFFERS.get(drawDepth - 1);
            framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            ScissorStack.drawUnclipped(() -> ((RenderTarget)framebuffer).clear());
            framebuffer.bindWrite(false);
            RenderTarget lastFramebuffer = currentFramebuffer;
            currentFramebuffer = framebuffer;
            this.drawChildren(context, mouseX, mouseY, partialTicks, delta, this.childView);
            context.flush();
            GlStateManager._glBindFramebuffer((int)36160, (int)previousFramebuffer);
            currentFramebuffer = lastFramebuffer;
            ListIterator<RenderEffectSlot> iter = this.effects.listIterator();
            while (iter.hasNext()) {
                iter.next().effect.setup(this, context, partialTicks, delta);
            }
            BufferBuilder buffer = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            Matrix4f matrix = context.pose().last().pose();
            buffer.addVertex(matrix, 0.0f, (float)window.getGuiScaledHeight(), 0.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.addVertex(matrix, (float)window.getGuiScaledWidth(), (float)window.getGuiScaledHeight(), 0.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.addVertex(matrix, (float)window.getGuiScaledWidth(), 0.0f, 0.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.setShaderTexture((int)0, (int)framebuffer.getColorTextureId());
            RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX_COLOR);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            while (iter.hasPrevious()) {
                iter.previous().effect.cleanup(this, context, partialTicks, delta);
            }
        }
        finally {
            --drawDepth;
        }
    }

    public RenderEffectSlot effect(RenderEffect effect) {
        RenderEffectSlot slot = new RenderEffectSlot(effect);
        this.effects.add(slot);
        return slot;
    }

    public void clearEffects() {
        this.effects.clear();
    }

    @ApiStatus.Internal
    @Nullable
    public static RenderTarget currentFramebuffer() {
        return currentFramebuffer;
    }

    static {
        WindowResizeCallback.EVENT.register((client, window) -> FRAMEBUFFERS.forEach(framebuffer -> framebuffer.resize(window.getWidth(), window.getHeight())));
    }

    public class RenderEffectSlot {
        protected RenderEffect effect;

        protected RenderEffectSlot(RenderEffect effect) {
            this.effect = effect;
        }

        public void update(RenderEffect newEffect) {
            this.effect = newEffect;
        }

        public void remove() {
            RenderEffectWrapper.this.effects.remove(this);
        }
    }

    public static interface RenderEffect {
        public void setup(Component var1, GuiGraphics var2, float var3, float var4);

        public void cleanup(Component var1, GuiGraphics var2, float var3, float var4);

        public static RenderEffect rotate(float angle) {
            return RenderEffect.rotate(Axis.ZP, angle);
        }

        public static RenderEffect rotate(final Axis axis, final float angle) {
            return new RenderEffect(){

                @Override
                public void setup(Component component, GuiGraphics context, float partialTicks, float delta) {
                    Size size = component.fullSize();
                    PoseStack matrices = context.pose();
                    matrices.pushPose();
                    matrices.translate((float)component.x() + (float)size.width() / 2.0f, (float)component.y() + (float)size.height() / 2.0f, 0.0f);
                    matrices.mulPose(axis.rotationDegrees(angle));
                    matrices.translate(-((float)component.x() + (float)size.width() / 2.0f), -((float)component.y() + (float)size.height() / 2.0f), 0.0f);
                }

                @Override
                public void cleanup(Component component, GuiGraphics context, float partialTicks, float delta) {
                    context.pose().popPose();
                }
            };
        }

        public static RenderEffect color(final Color color) {
            return new RenderEffect(){
                private float[] colors = null;

                @Override
                public void setup(Component component, GuiGraphics context, float partialTicks, float delta) {
                    this.colors = (float[])RenderSystem.getShaderColor().clone();
                    RenderSystem.setShaderColor((float)(this.colors[0] * color.red()), (float)(this.colors[1] * color.green()), (float)(this.colors[2] * color.blue()), (float)(this.colors[3] * color.alpha()));
                    if (color.alpha() != 1.0f) {
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                    }
                }

                @Override
                public void cleanup(Component component, GuiGraphics context, float partialTicks, float delta) {
                    RenderSystem.setShaderColor((float)this.colors[0], (float)this.colors[1], (float)this.colors[2], (float)this.colors[3]);
                }
            };
        }

        public static RenderEffect transform(Matrix4f transform) {
            return RenderEffect.transform((PoseStack matrices) -> matrices.mulPose(transform));
        }

        public static RenderEffect transform(final Consumer<PoseStack> transform) {
            return new RenderEffect(){

                @Override
                public void setup(Component component, GuiGraphics context, float partialTicks, float delta) {
                    context.pose().pushPose();
                    transform.accept(context.pose());
                }

                @Override
                public void cleanup(Component component, GuiGraphics context, float partialTicks, float delta) {
                    context.pose().popPose();
                }
            };
        }
    }
}

