/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.wispforest.owo.client.OwoClient;
import io.wispforest.owo.mixin.ScreenAccessor;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.w3c.dom.Element;

public interface Surface {
    public static final Surface PANEL = (context, component) -> context.drawPanel(component.x(), component.y(), component.width(), component.height(), false);
    public static final Surface DARK_PANEL = (context, component) -> context.drawPanel(component.x(), component.y(), component.width(), component.height(), true);
    public static final Surface PANEL_INSET = (context, component) -> NinePatchTexture.draw(OwoUIDrawContext.PANEL_INSET_NINE_PATCH_TEXTURE, context, component);
    public static final Surface VANILLA_TRANSLUCENT = (context, component) -> context.drawGradientRect(component.x(), component.y(), component.width(), component.height(), -1072689136, -1072689136, -804253680, -804253680);
    public static final Surface OPTIONS_BACKGROUND = Surface.panorama(ScreenAccessor.owo$ROTATING_PANORAMA_RENDERER(), false).and(Surface.blur(5.0f, 10.0f));
    public static final Surface TOOLTIP = Surface.tooltip(null);
    public static final Surface BLANK = (context, component) -> {};

    public static Surface tooltip(@Nullable ResourceLocation texture) {
        return (context, component) -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)context, (int)(component.x() + 4), (int)(component.y() + 4), (int)(component.width() - 8), (int)(component.height() - 8), (int)0, (ResourceLocation)texture);
    }

    public static Surface blur(float quality, float size) {
        return (context, component) -> {
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
            Matrix4f matrix = context.pose().last().pose();
            buffer.addVertex(matrix, (float)component.x(), (float)component.y(), 0.0f);
            buffer.addVertex(matrix, (float)component.x(), (float)(component.y() + component.height()), 0.0f);
            buffer.addVertex(matrix, (float)(component.x() + component.width()), (float)(component.y() + component.height()), 0.0f);
            buffer.addVertex(matrix, (float)(component.x() + component.width()), (float)component.y(), 0.0f);
            OwoClient.BLUR_PROGRAM.setParameters(16, quality, size);
            OwoClient.BLUR_PROGRAM.use();
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        };
    }

    public static Surface vanillaPanorama(boolean alwaysVisible) {
        return Surface.panorama(new PanoramaRenderer(ScreenAccessor.owo$PANORAMA_RENDERER()), alwaysVisible);
    }

    public static Surface panorama(PanoramaRenderer renderer, boolean alwaysVisible) {
        return (context, component) -> {
            if (!alwaysVisible && Minecraft.getInstance().level != null) {
                return;
            }
            Minecraft client = Minecraft.getInstance();
            int prevX = GlStateManager.Viewport.x();
            int prevY = GlStateManager.Viewport.y();
            int prevWidth = GlStateManager.Viewport.width();
            int prevHeight = GlStateManager.Viewport.height();
            Window window = client.getWindow();
            double scale = window.getGuiScale();
            int x = component.x();
            int y = component.y();
            int width = component.width();
            int height = component.height();
            RenderSystem.viewport((int)((int)((double)x * scale)), (int)((int)((double)window.getHeight() - (double)y * scale - (double)height * scale)), (int)Mth.clamp((int)((int)((double)width * scale)), (int)0, (int)window.getWidth()), (int)Mth.clamp((int)((int)((double)height * scale)), (int)0, (int)window.getHeight()));
            float delta = client.getDeltaTracker().getRealtimeDeltaTicks();
            RenderSystem.disableDepthTest();
            renderer.render((GuiGraphics)context, width, height, 1.0f, delta);
            RenderSystem.enableDepthTest();
            RenderSystem.viewport((int)prevX, (int)prevY, (int)prevWidth, (int)prevHeight);
        };
    }

    public static Surface flat(int color) {
        return (context, component) -> context.fill(component.x(), component.y(), component.x() + component.width(), component.y() + component.height(), color);
    }

    public static Surface outline(int color) {
        return (context, component) -> context.drawRectOutline(component.x(), component.y(), component.width(), component.height(), color);
    }

    public static Surface tiled(ResourceLocation texture, int textureWidth, int textureHeight) {
        return (context, component) -> context.blit(RenderType::guiTextured, texture, component.x(), component.y(), 0.0f, 0.0f, component.width(), component.height(), textureWidth, textureHeight);
    }

    public static Surface panelWithInset(int insetWidth) {
        return PANEL.and((context, component) -> NinePatchTexture.draw(OwoUIDrawContext.PANEL_INSET_NINE_PATCH_TEXTURE, context, component.x() + insetWidth, component.y() + insetWidth, component.width() - insetWidth * 2, component.height() - insetWidth * 2));
    }

    public void draw(OwoUIDrawContext var1, ParentComponent var2);

    default public Surface and(Surface surface) {
        return (context, component) -> {
            this.draw(context, component);
            surface.draw(context, component);
        };
    }

    public static Surface parse(Element surfaceElement) {
        List<Element> children = UIParsing.allChildrenOfType(surfaceElement, (short)1);
        Surface surface = BLANK;
        for (Element child : children) {
            surface = switch (child.getNodeName()) {
                case "panel" -> surface.and(child.getAttribute("dark").equalsIgnoreCase("true") ? DARK_PANEL : PANEL);
                case "tiled" -> {
                    UIParsing.expectAttributes(child, "texture-width", "texture-height");
                    yield surface.and(Surface.tiled(UIParsing.parseIdentifier(child), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-width")), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-height"))));
                }
                case "blur" -> {
                    UIParsing.expectAttributes(child, "size", "quality");
                    yield surface.and(Surface.blur(UIParsing.parseFloat(child.getAttributeNode("quality")), UIParsing.parseFloat(child.getAttributeNode("size"))));
                }
                case "panel-with-inset" -> surface.and(Surface.panelWithInset(UIParsing.parseUnsignedInt(child)));
                case "options-background" -> surface.and(OPTIONS_BACKGROUND);
                case "vanilla-translucent" -> surface.and(VANILLA_TRANSLUCENT);
                case "panel-inset" -> surface.and(PANEL_INSET);
                case "tooltip" -> surface.and(TOOLTIP);
                case "outline" -> surface.and(Surface.outline(Color.parseAndPack(child)));
                case "flat" -> surface.and(Surface.flat(Color.parseAndPack(child)));
                default -> throw new UIModelParsingException("Unknown surface type '" + child.getNodeName() + "'");
            };
        }
        return surface;
    }
}

