/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.util.StringUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static void tryMigrateOldSkinDirectory(Path oldDirectory, Path newDirectory) {
        try (Stream<Path> stream = Files.list(oldDirectory);){
            List<Path> files = stream.filter(file -> {
                String name = file.getFileName().toString();
                return Files.isRegularFile(file, new LinkOption[0]) && !name.startsWith("translation") && !name.startsWith("config.json") && !name.startsWith("mojang_profile_cache.json") && name.endsWith(".json");
            }).toList();
            if (!files.isEmpty() && !Files.exists(newDirectory, new LinkOption[0])) {
                Files.createDirectories(newDirectory, new FileAttribute[0]);
            }
            for (Path file2 : files) {
                Path newFile = newDirectory.resolve(file2.getFileName());
                if (!Files.exists(newFile, new LinkOption[0])) {
                    Files.move(file2, newFile, StandardCopyOption.ATOMIC_MOVE);
                    continue;
                }
                Files.delete(file2);
            }
        }
        catch (Exception e) {
            SkinRestorer.LOGGER.error("Could not migrate skin directory", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readResource(String name) {
        try (InputStream stream = SkinRestorer.class.getResourceAsStream(name);){
            String string;
            if (stream == null) {
                String string2 = null;
                return string2;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                string = StringUtils.readString(reader);
            }
            return string;
        }
        catch (IOException e) {
            SkinRestorer.LOGGER.error("Failed to read resource", (Throwable)e);
            return null;
        }
    }

    public static String readFile(Path file) {
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                return null;
            }
            return Files.readString(file);
        }
        catch (Exception e) {
            SkinRestorer.LOGGER.error("Failed to read file", (Throwable)e);
            return null;
        }
    }

    public static void writeFile(Path file, String content) {
        try {
            Path parent = file.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            SkinRestorer.LOGGER.error("Failed to write file", (Throwable)e);
        }
    }

    public static void deleteFile(Path file) {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                Files.delete(file);
            }
        }
        catch (IOException e) {
            SkinRestorer.LOGGER.error("Failed to delete file", (Throwable)e);
        }
    }
}

