/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.config.Proxy;

public final class WebUtils {
    public static final String USER_AGENT;
    private static HttpClient HTTP_CLIENT;

    private WebUtils() {
    }

    public static void recreateHttpClient() {
        HTTP_CLIENT = WebUtils.buildClient();
    }

    private static HttpClient buildClient() {
        HttpClient.Builder builder = HttpClient.newBuilder();
        Optional<Proxy> proxy = SkinRestorer.getConfig().proxy();
        proxy.ifPresent(value -> builder.proxy(ProxySelector.of(InetSocketAddress.createUnresolved(value.host(), value.port()))));
        try {
            builder.connectTimeout(Duration.of(SkinRestorer.getConfig().requestTimeout(), ChronoUnit.SECONDS));
        }
        catch (IllegalArgumentException e) {
            SkinRestorer.LOGGER.error("Failed to set request timeout", (Throwable)e);
            builder.connectTimeout(Duration.of(10L, ChronoUnit.SECONDS));
        }
        return builder.build();
    }

    public static HttpResponse<String> executeRequest(HttpRequest request) throws IOException {
        try {
            HttpRequest modifiedRequest = HttpRequest.newBuilder(request, (name, value) -> true).header("User-Agent", USER_AGENT).build();
            HttpResponse<String> response = HTTP_CLIENT.send(modifiedRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 500) {
                throw new IOException("server error " + response.statusCode());
            }
            return response;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public static void throwOnClientErrors(HttpResponse<?> response) {
        String message;
        switch (response.statusCode()) {
            case 400: {
                String string = "bad request";
                break;
            }
            case 401: {
                String string = "unauthorized";
                break;
            }
            case 403: {
                String string = "forbidden";
                break;
            }
            case 404: {
                String string = "not found";
                break;
            }
            case 405: {
                String string = "method not allowed";
                break;
            }
            case 408: {
                String string = "request timeout";
                break;
            }
            case 429: {
                String string = "too many requests";
                break;
            }
            default: {
                String string = message = null;
            }
        }
        if (message != null) {
            throw new IllegalStateException(message);
        }
    }

    static {
        HTTP_CLIENT = null;
        USER_AGENT = String.format("SkinRestorer/%d", System.currentTimeMillis() % 65535L);
    }
}

