/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.beacon;

import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.renderer.generic.BeaconRenderHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.sql.repo.BeaconBeamRepo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class BeaconBeamDataHandler {
    private final BeaconBeamRepo beaconBeamRepo;
    @Nullable
    private BeaconRenderHandler beaconRenderHandler;

    public BeaconBeamDataHandler(@NotNull BeaconBeamRepo beaconBeamRepo, @Nullable GenericObjectRenderer renderer) {
        this.beaconBeamRepo = beaconBeamRepo;
        if (renderer != null) {
            this.beaconRenderHandler = new BeaconRenderHandler(renderer);
        }
    }

    public void setBeaconBeamsForChunk(DhChunkPos chunkPos, List<BeaconBeamDTO> activeBeamList) {
        long sectionPos = DhSectionPos.encode((byte)4, chunkPos.getX(), chunkPos.getZ());
        this.setBeaconBeamsForPos(sectionPos, activeBeamList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeaconBeamsForPos(long sectionPos, List<BeaconBeamDTO> activeBeamList) {
        BeaconBeamDataHandler beaconBeamDataHandler = this;
        synchronized (beaconBeamDataHandler) {
            HashSet<DhBlockPos> allPosSet = new HashSet<DhBlockPos>();
            HashMap<DhBlockPos, BeaconBeamDTO> activeBeamByPos = new HashMap<DhBlockPos, BeaconBeamDTO>(activeBeamList.size());
            for (BeaconBeamDTO beam : activeBeamList) {
                activeBeamByPos.put(beam.blockPos, beam);
                allPosSet.add(beam.blockPos);
            }
            List<BeaconBeamDTO> existingBeamList = this.beaconBeamRepo.getAllBeamsForPos(sectionPos);
            HashMap<DhBlockPos, BeaconBeamDTO> existingBeamByPos = new HashMap<DhBlockPos, BeaconBeamDTO>(existingBeamList.size());
            for (BeaconBeamDTO beam : existingBeamList) {
                existingBeamByPos.put(beam.blockPos, beam);
                allPosSet.add(beam.blockPos);
            }
            for (DhBlockPos beaconPos : allPosSet) {
                if (!DhSectionPos.contains(sectionPos, beaconPos)) continue;
                BeaconBeamDTO existingBeam = (BeaconBeamDTO)existingBeamByPos.get(beaconPos);
                BeaconBeamDTO activeBeam = (BeaconBeamDTO)activeBeamByPos.get(beaconPos);
                if (activeBeam != null) {
                    if (existingBeam == null) {
                        this.beaconBeamRepo.save(activeBeam);
                        if (this.beaconRenderHandler == null) continue;
                        this.beaconRenderHandler.startRenderingBeacon(activeBeam);
                        continue;
                    }
                    if (existingBeam.color.equals(activeBeam.color)) continue;
                    this.beaconBeamRepo.save(activeBeam);
                    if (this.beaconRenderHandler == null) continue;
                    this.beaconRenderHandler.updateBeaconColor(activeBeam);
                    continue;
                }
                if (existingBeam == null) continue;
                this.beaconBeamRepo.deleteWithKey(beaconPos);
                if (this.beaconRenderHandler == null) continue;
                this.beaconRenderHandler.stopRenderingBeaconAtPos(beaconPos);
            }
        }
    }

    public void loadBeaconBeamsInPos(long pos) {
        if (this.beaconRenderHandler == null) {
            return;
        }
        List<BeaconBeamDTO> existingBeamList = this.beaconBeamRepo.getAllBeamsForPos(pos);
        for (BeaconBeamDTO newBeam : existingBeamList) {
            this.beaconRenderHandler.startRenderingBeacon(newBeam);
        }
    }

    public void unloadBeaconBeamsInPos(long pos) {
        if (this.beaconRenderHandler == null) {
            return;
        }
        List<BeaconBeamDTO> existingBeamList = this.beaconBeamRepo.getAllBeamsForPos(pos);
        for (BeaconBeamDTO beam : existingBeamList) {
            this.beaconRenderHandler.stopRenderingBeaconAtPos(beam.blockPos);
        }
    }
}

