/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.TimerUtil;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DelayedFullDataSourceSaveCache {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final Timer DELAY_UPDATE_TIMER = TimerUtil.CreateTimer("Delayed Full Datasource Save Timer");
    public final ConcurrentHashMap<Long, FullDataSourceV2> dataSourceByPosition = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, TimerTask> saveTimerTasksBySectionPos = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, CompletableFuture<Void>> futureBySectionPos = new ConcurrentHashMap();
    private final ISaveDataSourceFunc onSaveTimeoutFunc;
    private final int saveDelayInMs;

    public DelayedFullDataSourceSaveCache(@NotNull ISaveDataSourceFunc onSaveTimeoutFunc, int saveDelayInMs) {
        this.onSaveTimeoutFunc = onSaveTimeoutFunc;
        this.saveDelayInMs = saveDelayInMs;
    }

    public CompletableFuture<Void> writeDataSourceToMemoryAndQueueSave(FullDataSourceV2 inputDataSource) {
        final long dataSourcePos = inputDataSource.getPos();
        CompletableFuture future = this.futureBySectionPos.computeIfAbsent(dataSourcePos, inputPos -> new CompletableFuture());
        this.dataSourceByPosition.compute(dataSourcePos, (inputPos, memoryDataSource) -> {
            if (memoryDataSource == null) {
                memoryDataSource = FullDataSourceV2.createEmpty(inputPos);
            }
            memoryDataSource.update(inputDataSource);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    DelayedFullDataSourceSaveCache.this.saveTimerTasksBySectionPos.remove(dataSourcePos);
                    try {
                        FullDataSourceV2 dataSourceToSave = DelayedFullDataSourceSaveCache.this.dataSourceByPosition.remove(dataSourcePos);
                        if (dataSourceToSave != null) {
                            DelayedFullDataSourceSaveCache.this.onSaveTimeoutFunc.save(dataSourceToSave);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to save updated data for section [" + dataSourcePos + "], error: [" + e.getMessage() + "]", (Throwable)e);
                    }
                    finally {
                        CompletableFuture future = (CompletableFuture)DelayedFullDataSourceSaveCache.this.futureBySectionPos.remove(dataSourcePos);
                        if (future != null) {
                            future.complete(null);
                        }
                    }
                }
            };
            try {
                DELAY_UPDATE_TIMER.schedule(timerTask, this.saveDelayInMs);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            TimerTask oldTask = this.saveTimerTasksBySectionPos.put(dataSourcePos, timerTask);
            if (oldTask != null) {
                oldTask.cancel();
            }
            return memoryDataSource;
        });
        return future;
    }

    public int getUnsavedCount() {
        return this.dataSourceByPosition.size();
    }

    public void flush() {
        this.saveTimerTasksBySectionPos.forEach((pos, timerTask) -> timerTask.run());
    }

    @FunctionalInterface
    public static interface ISaveDataSourceFunc {
        public void save(FullDataSourceV2 var1);
    }
}

