/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.DelayedFullDataSourceSaveCache;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.structure.ISaveStructure;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.generation.tasks.IWorldGenTaskTracker;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListCheckout;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedFullDataSourceProvider
extends FullDataSourceProviderV2
implements IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final int MAX_WORLD_GEN_REQUESTS_PER_THREAD = 20;
    private final AtomicReference<IFullDataSourceRetrievalQueue> worldGenQueueRef = new AtomicReference<Object>(null);
    private final ArrayList<IOnWorldGenCompleteListener> onWorldGenTaskCompleteListeners = new ArrayList();
    protected final DelayedFullDataSourceSaveCache delayedFullDataSourceSaveCache = new DelayedFullDataSourceSaveCache(this::onDataSourceSave, 5000);
    public static final PhantomArrayListPool ARRAY_LIST_POOL = new PhantomArrayListPool("Generated Provider");

    public GeneratedFullDataSourceProvider(IDhLevel level, ISaveStructure saveStructure) {
        super(level, saveStructure);
    }

    public GeneratedFullDataSourceProvider(IDhLevel level, ISaveStructure saveStructure, @Nullable File saveDirOverride) {
        super(level, saveStructure, saveDirOverride);
    }

    public void addWorldGenCompleteListener(IOnWorldGenCompleteListener listener) {
        this.onWorldGenTaskCompleteListeners.add(listener);
    }

    public void removeWorldGenCompleteListener(IOnWorldGenCompleteListener listener) {
        this.onWorldGenTaskCompleteListeners.remove(listener);
    }

    private void onWorldGenTaskComplete(WorldGenResult genTaskResult, Throwable exception) {
        if (exception != null) {
            if (!(exception instanceof CancellationException) && !(exception.getCause() instanceof CancellationException)) {
                LOGGER.error("Uncaught Gen Task Exception at [" + genTaskResult.pos + "], error: [" + exception.getMessage() + "].", exception);
            }
        } else {
            if (genTaskResult.success) {
                this.fireOnGenPosSuccessListeners(genTaskResult.pos);
                return;
            }
            LOGGER.debug("Gen Task Failed at " + genTaskResult.pos);
        }
        for (CompletableFuture completableFuture : genTaskResult.childFutures) {
            completableFuture.whenComplete((siblingGenTaskResult, siblingEx) -> this.onWorldGenTaskComplete((WorldGenResult)siblingGenTaskResult, (Throwable)siblingEx));
        }
    }

    private void fireOnGenPosSuccessListeners(long pos) {
        for (IOnWorldGenCompleteListener listener : this.onWorldGenTaskCompleteListeners) {
            listener.onWorldGenTaskComplete(pos);
        }
    }

    public byte lowestDataDetailLevel() {
        IFullDataSourceRetrievalQueue fullDataSourceRetrievalQueue = this.worldGenQueueRef.get();
        if (fullDataSourceRetrievalQueue == null) {
            return 6;
        }
        return (byte)(6 + fullDataSourceRetrievalQueue.lowestDataDetail());
    }

    public void setWorldGenerationQueue(IFullDataSourceRetrievalQueue newWorldGenQueue) {
        boolean oldQueueExists = this.worldGenQueueRef.compareAndSet(null, newWorldGenQueue);
        LodUtil.assertTrue(oldQueueExists, "previous world gen queue is still here!");
        LOGGER.info("Set world gen queue for level [" + this.level.getLevelWrapper().getDhIdentifier() + "].");
    }

    @Override
    public boolean canRetrieveMissingDataSources() {
        return true;
    }

    @Override
    public void setEstimatedRemainingRetrievalChunkCount(int newCount) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue != null) {
            worldGenQueue.setRetrievalEstimatedRemainingChunkCount(newCount);
        }
    }

    @Override
    public boolean canQueueRetrieval() {
        return this.canQueueRetrieval(false);
    }

    public boolean canQueueRetrieval(boolean pruneWaitingTasksAboveLimit) {
        if (!super.canQueueRetrieval()) {
            return false;
        }
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return false;
        }
        PriorityTaskPicker.Executor updateExecutor = ThreadPoolUtil.getUpdatePropagatorExecutor();
        if (updateExecutor == null || updateExecutor.getQueueSize() >= MAX_UPDATE_TASK_COUNT / 2) {
            return false;
        }
        PriorityTaskPicker.Executor fileExecutor = ThreadPoolUtil.getFileHandlerExecutor();
        if (fileExecutor == null || fileExecutor.getQueueSize() >= MAX_UPDATE_TASK_COUNT / 2) {
            return false;
        }
        int maxQueueCount = 20 * Config.Common.MultiThreading.numberOfThreads.get();
        if (this.delayedFullDataSourceSaveCache.getUnsavedCount() >= maxQueueCount) {
            this.delayedFullDataSourceSaveCache.flush();
            return false;
        }
        int availableTaskSlots = maxQueueCount - worldGenQueue.getWaitingTaskCount();
        if (availableTaskSlots <= 0) {
            if (pruneWaitingTasksAboveLimit) {
                AtomicInteger tasksToCancel = new AtomicInteger(-availableTaskSlots + 1);
                worldGenQueue.removeRetrievalRequestIf(x -> tasksToCancel.getAndDecrement() > 0);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public CompletableFuture<WorldGenResult> queuePositionForRetrieval(Long genPos) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return null;
        }
        WorldGenTaskTracker genTaskTracker = new WorldGenTaskTracker(genPos);
        CompletableFuture<WorldGenResult> worldGenFuture = worldGenQueue.submitRetrievalTask(genPos, (byte)(DhSectionPos.getDetailLevel(genPos) - 6), genTaskTracker);
        worldGenFuture.whenComplete((genTaskResult, ex) -> {});
        return worldGenFuture;
    }

    @Override
    protected void updateDataSourceAtPos(long updatePos, @NotNull FullDataSourceV2 inputData, boolean lockOnUpdatePos) {
        super.updateDataSourceAtPos(updatePos, inputData, lockOnUpdatePos);
        this.onWorldGenTaskComplete(WorldGenResult.CreateSuccess(updatePos), null);
    }

    @Override
    public void removeRetrievalRequestIf(DhSectionPos.ICancelablePrimitiveLongConsumer removeIf) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue != null) {
            worldGenQueue.removeRetrievalRequestIf(removeIf);
        }
    }

    @Override
    public void clearRetrievalQueue() {
        this.worldGenQueueRef.set(null);
    }

    @Override
    public int getUnsavedDataSourceCount() {
        return this.delayedFullDataSourceSaveCache.getUnsavedCount();
    }

    public boolean isFullyGenerated(ByteArrayList columnGenerationSteps) {
        return IntStream.range(0, columnGenerationSteps.size()).noneMatch(i -> columnGenerationSteps.getByte(i) == EDhApiWorldGenerationStep.EMPTY.value);
    }

    @Override
    public LongArrayList getPositionsToRetrieve(Long pos) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return null;
        }
        if (((FullDataSourceV2Repo)this.repo).existsWithKey(pos)) {
            try (PhantomArrayListCheckout checkout = ARRAY_LIST_POOL.checkoutArrays(1, 0, 0);){
                ByteArrayList columnGenStepArray = checkout.getByteArray(0, 4096);
                ((FullDataSourceV2Repo)this.repo).getColumnGenerationStepForPos(pos, columnGenStepArray);
                if (!columnGenStepArray.isEmpty()) {
                    boolean positionFullyGenerated = true;
                    for (int i = 0; i < columnGenStepArray.size(); ++i) {
                        if (columnGenStepArray.getByte(i) != EDhApiWorldGenerationStep.EMPTY.value) continue;
                        positionFullyGenerated = false;
                        break;
                    }
                    if (positionFullyGenerated) {
                        LongArrayList longArrayList = new LongArrayList();
                        return longArrayList;
                    }
                }
            }
        }
        LongArrayList generationList = new LongArrayList();
        byte lowestGeneratorDetailLevel = (byte)Math.min(worldGenQueue.lowestDataDetail() + 6, DhSectionPos.getDetailLevel(pos));
        DhSectionPos.forEachChildAtDetailLevel(pos, lowestGeneratorDetailLevel, genPos -> {
            if (!((FullDataSourceV2Repo)this.repo).existsWithKey(genPos)) {
                generationList.add(genPos);
            } else {
                EDhApiWorldGenerationStep currentMinWorldGenStep;
                block14: {
                    currentMinWorldGenStep = EDhApiWorldGenerationStep.LIGHT;
                    try (PhantomArrayListCheckout checkout = ARRAY_LIST_POOL.checkoutArrays(1, 0, 0);){
                        ByteArrayList columnGenerationSteps = checkout.getByteArray(0, 4096);
                        ((FullDataSourceV2Repo)this.repo).getColumnGenerationStepForPos(genPos, columnGenerationSteps);
                        if (columnGenerationSteps.isEmpty()) {
                            return;
                        }
                        for (int x = 0; x < 64; ++x) {
                            for (int z = 0; z < 64; ++z) {
                                EDhApiWorldGenerationStep newWorldGenStep;
                                int index = FullDataSourceV2.relativePosToIndex(x, z);
                                byte genStepValue = columnGenerationSteps.getByte(index);
                                if (genStepValue < currentMinWorldGenStep.value && (newWorldGenStep = EDhApiWorldGenerationStep.fromValue(genStepValue)) != null && newWorldGenStep.value < currentMinWorldGenStep.value) {
                                    currentMinWorldGenStep = newWorldGenStep;
                                }
                                if (currentMinWorldGenStep != EDhApiWorldGenerationStep.EMPTY) continue;
                                break block14;
                            }
                        }
                    }
                }
                if (currentMinWorldGenStep != EDhApiWorldGenerationStep.EMPTY) {
                    return;
                }
                generationList.add(genPos);
            }
        });
        return generationList;
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        super.debugRender(renderer);
        this.delayedFullDataSourceSaveCache.dataSourceByPosition.forEach((pos, dataSource) -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 80.0f, 0.2f, Color.green.darker())));
    }

    private void onDataSourceSave(FullDataSourceV2 fullDataSource) {
        DhLightingEngine.INSTANCE.bakeDataSourceSkyLight(fullDataSource, 15);
        this.updateDataSourceAsync(fullDataSource);
    }

    public static interface IOnWorldGenCompleteListener {
        public boolean shouldDoWorldGen();

        @Nullable
        public DhBlockPos2D getTargetPosForGeneration();

        public void onWorldGenTaskComplete(long var1);
    }

    private class WorldGenTaskTracker
    implements IWorldGenTaskTracker {
        private final long pos;

        public WorldGenTaskTracker(long pos) {
            this.pos = pos;
        }

        @Override
        public Consumer<FullDataSourceV2> getDataSourceConsumer() {
            return dataSource -> GeneratedFullDataSourceProvider.this.delayedFullDataSourceSaveCache.writeDataSourceToMemoryAndQueueSave((FullDataSourceV2)dataSource);
        }
    }
}

