/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGeneratorReturnType;
import com.seibel.distanthorizons.api.interfaces.override.worldGenerator.IDhApiWorldGenerator;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.transformers.LodDataBuilder;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.generation.tasks.IWorldGenTaskTracker;
import com.seibel.distanthorizons.core.generation.tasks.InProgressWorldGenTaskGroup;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenTask;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenTaskGroup;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.objects.RollingAverage;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;

public class WorldGenerationQueue
implements IFullDataSourceRetrievalQueue,
IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
    private static final int MAX_QUEUED_TASKS_PER_THREAD = 3;
    private final IDhApiWorldGenerator generator;
    private final ConcurrentHashMap<Long, WorldGenTask> waitingTasks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, InProgressWorldGenTaskGroup> inProgressGenTasksByLodPos = new ConcurrentHashMap();
    public final byte lowestDataDetail;
    public final byte highestDataDetail;
    private volatile CompletableFuture<Void> generatorClosingFuture = null;
    private final ExecutorService queueingThread = ThreadUtil.makeSingleThreadPool("World Gen Queue");
    private boolean generationQueueRunning = false;
    private DhBlockPos2D generationTargetPos = DhBlockPos2D.ZERO;
    private int estimatedRemainingTaskCount = 0;
    private int estimatedRemainingChunkCount = 0;
    private final RollingAverage rollingAverageChunkGenTimeInMs = new RollingAverage(1000);

    @Override
    public RollingAverage getRollingAverageChunkGenTimeInMs() {
        return this.rollingAverageChunkGenTimeInMs;
    }

    public WorldGenerationQueue(IDhApiWorldGenerator generator) {
        LOGGER.info("Creating world gen queue");
        this.generator = generator;
        this.lowestDataDetail = generator.getLargestDataDetailLevel();
        this.highestDataDetail = generator.getSmallestDataDetailLevel();
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showWorldGenQueue);
        LOGGER.info("Created world gen queue");
    }

    @Override
    public CompletableFuture<WorldGenResult> submitRetrievalTask(long pos, byte requiredDataDetail, IWorldGenTaskTracker tracker) {
        if (this.generatorClosingFuture != null) {
            return CompletableFuture.completedFuture(WorldGenResult.CreateFail());
        }
        if (requiredDataDetail < this.highestDataDetail) {
            throw new UnsupportedOperationException("Current generator does not meet requiredDataDetail level");
        }
        if (requiredDataDetail > this.lowestDataDetail) {
            requiredDataDetail = this.lowestDataDetail;
        }
        LodUtil.assertTrue(DhSectionPos.getDetailLevel(pos) > requiredDataDetail + 4);
        CompletableFuture<WorldGenResult> future = new CompletableFuture<WorldGenResult>();
        this.waitingTasks.put(pos, new WorldGenTask(pos, requiredDataDetail, tracker, future));
        return future;
    }

    @Override
    public void removeRetrievalRequestIf(DhSectionPos.ICancelablePrimitiveLongConsumer removeIf) {
        this.waitingTasks.forEachKey(100L, genPos -> {
            if (removeIf.accept((long)genPos)) {
                this.waitingTasks.remove(genPos);
            }
        });
    }

    @Override
    public void startAndSetTargetPos(DhBlockPos2D targetPos) {
        this.generationTargetPos = targetPos;
        if (!this.generationQueueRunning) {
            this.startWorldGenQueuingThread();
        }
    }

    private void startWorldGenQueuingThread() {
        this.generationQueueRunning = true;
        this.queueingThread.execute(() -> {
            try {
                while (!Thread.interrupted() && DhApiWorldProxy.INSTANCE.worldLoaded() && !DhApiWorldProxy.INSTANCE.getReadOnly()) {
                    this.generator.preGeneratorTaskStart();
                    boolean taskStarted = true;
                    while (!this.isGeneratorBusy() && taskStarted) {
                        taskStarted = this.startNextWorldGenTask(this.generationTargetPos);
                        if (taskStarted) continue;
                        boolean bl = false;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException taskStarted) {
            }
            catch (Exception e) {
                LOGGER.error("queueing exception: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.generationQueueRunning = false;
            }
        });
    }

    public boolean isGeneratorBusy() {
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getWorldGenExecutor();
        if (executor == null) {
            return true;
        }
        int worldGenThreadCount = Math.max(Config.Common.MultiThreading.numberOfThreads.get(), 1);
        int maxWorldGenTaskCount = worldGenThreadCount * 3;
        return executor.getQueueSize() > maxWorldGenTaskCount;
    }

    private boolean startNextWorldGenTask(DhBlockPos2D targetPos) {
        if (this.waitingTasks.isEmpty()) {
            return false;
        }
        Mapper closestTaskMap = this.waitingTasks.reduceEntries(1024L, entry -> new Mapper((WorldGenTask)entry.getValue(), DhSectionPos.getSectionBBoxPos(((WorldGenTask)entry.getValue()).pos).getCenterBlockPos().toPos2D().chebyshevDist(targetPos.toPos2D())), (aMapper, bMapper) -> aMapper.dist < bMapper.dist ? aMapper : bMapper);
        if (closestTaskMap == null) {
            return false;
        }
        WorldGenTask closestTask = closestTaskMap.task;
        this.waitingTasks.remove(closestTask.pos, closestTask);
        if (this.canGeneratePos(closestTask.pos)) {
            InProgressWorldGenTaskGroup newTaskGroup;
            boolean taskStarted;
            WorldGenTaskGroup closestTaskGroup = new WorldGenTaskGroup(closestTask.pos, (byte)(closestTask.pos - 6L));
            closestTaskGroup.worldGenTasks.add(closestTask);
            if (this.inProgressGenTasksByLodPos.containsKey(closestTask.pos) || !(taskStarted = this.tryStartingWorldGenTaskGroup(newTaskGroup = new InProgressWorldGenTaskGroup(closestTaskGroup)))) {
                // empty if block
            }
            return true;
        }
        LinkedList<CompletableFuture<WorldGenResult>> childFutures = new LinkedList<CompletableFuture<WorldGenResult>>();
        long sectionPos = closestTask.pos;
        WorldGenTask finalClosestTask = closestTask;
        DhSectionPos.forEachChild(sectionPos, childDhSectionPos -> {
            CompletableFuture<WorldGenResult> newFuture = new CompletableFuture<WorldGenResult>();
            childFutures.add(newFuture);
            WorldGenTask newGenTask = new WorldGenTask(childDhSectionPos, DhSectionPos.getDetailLevel(childDhSectionPos), finalClosestTask.taskTracker, newFuture);
            this.waitingTasks.put(newGenTask.pos, newGenTask);
        });
        closestTask.future.complete(WorldGenResult.CreateSplit(childFutures));
        return true;
    }

    private boolean tryStartingWorldGenTaskGroup(InProgressWorldGenTaskGroup newTaskGroup) {
        byte taskDetailLevel = newTaskGroup.group.dataDetail;
        long taskPos = newTaskGroup.group.pos;
        LodUtil.assertTrue(taskDetailLevel >= this.highestDataDetail && taskDetailLevel <= this.lowestDataDetail);
        int generationRequestChunkWidthCount = BitShiftUtil.powerOfTwo(DhSectionPos.getDetailLevel(taskPos) - taskDetailLevel - 4);
        long generationStartMsTime = System.currentTimeMillis();
        CompletableFuture<Void> generationFuture = this.startGenerationEvent(taskPos, taskDetailLevel, generationRequestChunkWidthCount, newTaskGroup.group::consumeDataSource);
        generationFuture.thenRun(() -> {
            long totalGenTimeInMs = System.currentTimeMillis() - generationStartMsTime;
            int chunkCount = generationRequestChunkWidthCount * generationRequestChunkWidthCount;
            double timePerChunk = (double)totalGenTimeInMs / (double)chunkCount;
            this.rollingAverageChunkGenTimeInMs.addValue(timePerChunk);
        });
        newTaskGroup.genFuture = generationFuture;
        LodUtil.assertTrue(newTaskGroup.genFuture != null);
        newTaskGroup.genFuture.whenComplete((voidObj, exception) -> {
            try {
                if (exception != null) {
                    if (!LodUtil.isInterruptOrReject(exception)) {
                        LOGGER.error("Error generating data for pos: " + DhSectionPos.toString(taskPos), exception);
                    }
                    newTaskGroup.group.worldGenTasks.forEach(worldGenTask -> worldGenTask.future.complete(WorldGenResult.CreateFail()));
                } else {
                    newTaskGroup.group.worldGenTasks.forEach(worldGenTask -> worldGenTask.future.complete(WorldGenResult.CreateSuccess(taskPos)));
                }
                boolean worked = this.inProgressGenTasksByLodPos.remove(taskPos, newTaskGroup);
                LodUtil.assertTrue(worked, "Unable to find in progress generator task with position [" + DhSectionPos.toString(taskPos) + "]");
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error completing world gen task at pos: [" + DhSectionPos.toString(taskPos) + "].", (Throwable)e);
            }
        });
        this.inProgressGenTasksByLodPos.put(taskPos, newTaskGroup);
        return true;
    }

    private CompletableFuture<Void> startGenerationEvent(long requestPos, byte targetDataDetail, int generationRequestChunkWidthCount, Consumer<FullDataSourceV2> dataSourceConsumer) {
        DhChunkPos chunkPosMin = new DhChunkPos(DhSectionPos.getSectionBBoxPos(requestPos).getCornerBlockPos());
        EDhApiDistantGeneratorMode generatorMode = Config.Common.WorldGenerator.distantGeneratorMode.get();
        EDhApiWorldGeneratorReturnType returnType = this.generator.getReturnType();
        switch (returnType) {
            case VANILLA_CHUNKS: {
                return this.generator.generateChunks(chunkPosMin.getX(), chunkPosMin.getZ(), generationRequestChunkWidthCount, targetDataDetail, generatorMode, ThreadPoolUtil.getWorldGenExecutor(), generatedObjectArray -> {
                    try {
                        IChunkWrapper chunk = WRAPPER_FACTORY.createChunkWrapper((Object[])generatedObjectArray);
                        try (FullDataSourceV2 dataSource = LodDataBuilder.createFromChunk(chunk);){
                            LodUtil.assertTrue(dataSource != null);
                            dataSourceConsumer.accept(dataSource);
                        }
                    }
                    catch (ClassCastException e) {
                        LOGGER.error("World generator return type incorrect. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                        Config.Common.WorldGenerator.enableDistantGeneration.set(false);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected world generator error. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                        Config.Common.WorldGenerator.enableDistantGeneration.set(false);
                    }
                });
            }
            case API_CHUNKS: {
                return this.generator.generateApiChunks(chunkPosMin.getX(), chunkPosMin.getZ(), generationRequestChunkWidthCount, targetDataDetail, generatorMode, ThreadPoolUtil.getWorldGenExecutor(), dataPoints -> {
                    try {
                        FullDataSourceV2 dataSource = LodDataBuilder.createFromApiChunkData(dataPoints, this.generator.runApiValidation());
                        dataSourceConsumer.accept(dataSource);
                    }
                    catch (DataCorruptedException | IllegalArgumentException e) {
                        LOGGER.error("World generator returned a corrupt chunk. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                        Config.Common.WorldGenerator.enableDistantGeneration.set(false);
                    }
                    catch (ClassCastException e) {
                        LOGGER.error("World generator return type incorrect. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                        Config.Common.WorldGenerator.enableDistantGeneration.set(false);
                    }
                });
            }
            case API_DATA_SOURCES: {
                FullDataSourceV2 pooledDataSource = FullDataSourceV2.createEmpty(requestPos);
                pooledDataSource.setRunApiChunkValidation(this.generator.runApiValidation());
                return this.generator.generateLod(chunkPosMin.getX(), chunkPosMin.getZ(), DhSectionPos.getX(requestPos), DhSectionPos.getZ(requestPos), (byte)(DhSectionPos.getDetailLevel(requestPos) - 6), pooledDataSource, generatorMode, ThreadPoolUtil.getWorldGenExecutor(), dataSource -> {
                    try {
                        dataSourceConsumer.accept((FullDataSourceV2)dataSource);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("World generator returned a corrupt data source. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                        Config.Common.WorldGenerator.enableDistantGeneration.set(false);
                    }
                    catch (ClassCastException e) {
                        LOGGER.error("World generator return type incorrect. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                        Config.Common.WorldGenerator.enableDistantGeneration.set(false);
                    }
                });
            }
        }
        Config.Common.WorldGenerator.enableDistantGeneration.set(false);
        throw new LodUtil.AssertFailureException("Unknown return type: " + (Object)((Object)returnType));
    }

    @Override
    public int getWaitingTaskCount() {
        return this.waitingTasks.size();
    }

    @Override
    public int getInProgressTaskCount() {
        return this.inProgressGenTasksByLodPos.size();
    }

    @Override
    public byte lowestDataDetail() {
        return this.lowestDataDetail;
    }

    @Override
    public byte highestDataDetail() {
        return this.highestDataDetail;
    }

    @Override
    public int getEstimatedRemainingTaskCount() {
        return this.estimatedRemainingTaskCount;
    }

    @Override
    public void setEstimatedRemainingTaskCount(int newEstimate) {
        this.estimatedRemainingTaskCount = newEstimate;
    }

    @Override
    public int getRetrievalEstimatedRemainingChunkCount() {
        return this.estimatedRemainingChunkCount;
    }

    @Override
    public void setRetrievalEstimatedRemainingChunkCount(int newEstimate) {
        this.estimatedRemainingChunkCount = newEstimate;
    }

    @Override
    public void addDebugMenuStringsToList(List<String> messageList) {
    }

    @Override
    public int getQueuedChunkCount() {
        int chunkCount = 0;
        Iterator iterator = ((ConcurrentHashMap.KeySetView)this.waitingTasks.keySet()).iterator();
        while (iterator.hasNext()) {
            long pos = (Long)iterator.next();
            int chunkWidth = DhSectionPos.getBlockWidth(pos) / 16;
            chunkCount += chunkWidth * chunkWidth;
        }
        return chunkCount;
    }

    @Override
    public CompletableFuture<Void> startClosingAsync(boolean cancelCurrentGeneration, boolean alsoInterruptRunning) {
        LOGGER.info("Closing world gen queue");
        this.queueingThread.shutdownNow();
        ArrayList inProgressTasksCancelingFutures = new ArrayList(this.inProgressGenTasksByLodPos.size());
        this.inProgressGenTasksByLodPos.values().forEach(runningTaskGroup -> {
            CompletableFuture<Void> genFuture = runningTaskGroup.genFuture;
            if (genFuture == null) {
                LOGGER.info("Null gen future: " + runningTaskGroup.group.pos);
                return;
            }
            if (cancelCurrentGeneration) {
                genFuture.cancel(alsoInterruptRunning);
            }
            inProgressTasksCancelingFutures.add(genFuture.handle((voidObj, exception) -> {
                if (exception instanceof CompletionException) {
                    exception = exception.getCause();
                }
                if (!UncheckedInterruptedException.isInterrupt(exception) && !(exception instanceof CancellationException)) {
                    LOGGER.error("Error when terminating data generation for section " + runningTaskGroup.group.pos, exception);
                }
                return null;
            }));
        });
        this.generatorClosingFuture = CompletableFuture.allOf(inProgressTasksCancelingFutures.toArray(new CompletableFuture[0]));
        return this.generatorClosingFuture;
    }

    @Override
    public void close() {
        LOGGER.info("Closing " + WorldGenerationQueue.class.getSimpleName() + "...");
        if (this.generatorClosingFuture == null) {
            this.startClosingAsync(true, true);
        }
        LodUtil.assertTrue(this.generatorClosingFuture != null);
        LOGGER.info("Awaiting world generator thread pool termination...");
        try {
            int waitTimeInSeconds = 3;
            PriorityTaskPicker.Executor executor = ThreadPoolUtil.getWorldGenExecutor();
            if (executor != null && !executor.awaitTermination(waitTimeInSeconds, TimeUnit.SECONDS)) {
                LOGGER.warn("World generator thread pool shutdown didn't complete after [" + waitTimeInSeconds + "] seconds. Some world generator requests may still be running.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("World generator thread pool shutdown interrupted! Ignoring child threads...", (Throwable)e);
        }
        this.generator.close();
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showWorldGenQueue);
        try {
            this.generatorClosingFuture.cancel(true);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to close generation queue: ", e);
        }
        LOGGER.info("Finished closing " + WorldGenerationQueue.class.getSimpleName());
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        ((ConcurrentHashMap.KeySetView)this.waitingTasks.keySet()).forEach(pos -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 64.0f, 0.05f, Color.blue)));
        this.inProgressGenTasksByLodPos.forEach((pos, t) -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 64.0f, 0.05f, Color.red)));
    }

    private boolean canGeneratePos(long taskPos) {
        byte requestedDetailLevel = (byte)(DhSectionPos.getDetailLevel(taskPos) - 6);
        return this.highestDataDetail <= requestedDetailLevel && requestedDetailLevel <= this.lowestDataDetail;
    }

    private static class Mapper {
        public final WorldGenTask task;
        public final int dist;

        public Mapper(WorldGenTask task, int dist) {
            this.task = task;
            this.dist = dist;
        }
    }
}

