/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.multiplayer.config;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.network.INetworkObject;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SessionConfig
implements INetworkObject {
    private static final LinkedHashMap<String, Entry> CONFIG_ENTRIES = new LinkedHashMap();
    private final LinkedHashMap<String, Object> values = new LinkedHashMap();
    public SessionConfig constrainingConfig;

    public boolean isDistantGenerationEnabled() {
        return this.getValue(Config.Common.WorldGenerator.enableDistantGeneration);
    }

    public int getMaxGenerationRequestDistance() {
        return this.getValue(Config.Server.maxGenerationRequestDistance);
    }

    public int getGenerationRequestRateLimit() {
        return this.getValue(Config.Server.generationRequestRateLimit);
    }

    public boolean isRealTimeUpdatesEnabled() {
        return this.getValue(Config.Server.enableRealTimeUpdates);
    }

    public int getMaxUpdateDistanceRadius() {
        return this.getValue(Config.Server.realTimeUpdateDistanceRadiusInChunks);
    }

    public boolean getSynchronizeOnLoad() {
        return this.getValue(Config.Server.synchronizeOnLoad);
    }

    public int getMaxSyncOnLoadDistance() {
        return this.getValue(Config.Server.maxSyncOnLoadRequestDistance);
    }

    public int getSyncOnLoginRateLimit() {
        return this.getValue(Config.Server.syncOnLoadRateLimit);
    }

    public int getMaxDataTransferSpeed() {
        return this.getValue(Config.Server.maxDataTransferSpeed);
    }

    private static <T> void registerConfigEntry(ConfigEntry<T> configEntry, BiFunction<T, T, T> valueConstrainer) {
        CONFIG_ENTRIES.compute(Objects.requireNonNull(configEntry.getChatCommandName()), (key, existingEntry) -> {
            if (existingEntry != null) {
                throw new IllegalArgumentException("Attempted to register config entry with duplicate chatCommandName: " + key);
            }
            return new Entry(configEntry, valueConstrainer);
        });
    }

    private <T> T getValue(ConfigEntry<T> configEntry) {
        return this.getValue(configEntry.getChatCommandName());
    }

    private <T> T getValue(String name) {
        Entry entry = CONFIG_ENTRIES.get(name);
        Object value = this.values.get(name);
        if (value == null) {
            value = entry.supplier.get();
        }
        return (T)(this.constrainingConfig != null ? entry.valueConstrainer.apply(value, this.constrainingConfig.getValue(name)) : value);
    }

    private Map<String, ?> getValues() {
        return CONFIG_ENTRIES.keySet().stream().collect(Collectors.toMap(Function.identity(), this::getValue, (x, y) -> x, LinkedHashMap::new));
    }

    @Override
    public void encode(ByteBuf outBuffer) {
        this.writeFixedLengthCollection(outBuffer, this.getValues().values());
    }

    @Override
    public void decode(ByteBuf inBuffer) {
        for (String key : CONFIG_ENTRIES.keySet()) {
            Object currentValue = this.getValue(key);
            Object newValue = INetworkObject.Codec.getCodec(currentValue.getClass()).decode.apply(currentValue, inBuffer);
            this.values.put(key, newValue);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.getValues()).toString();
    }

    static {
        SessionConfig.registerConfigEntry(Config.Common.WorldGenerator.enableDistantGeneration, Boolean::logicalAnd);
        SessionConfig.registerConfigEntry(Config.Server.maxGenerationRequestDistance, Math::min);
        SessionConfig.registerConfigEntry(Config.Server.generationRequestRateLimit, Math::min);
        SessionConfig.registerConfigEntry(Config.Server.enableRealTimeUpdates, Boolean::logicalAnd);
        SessionConfig.registerConfigEntry(Config.Server.realTimeUpdateDistanceRadiusInChunks, Math::min);
        SessionConfig.registerConfigEntry(Config.Server.synchronizeOnLoad, Boolean::logicalAnd);
        SessionConfig.registerConfigEntry(Config.Server.maxSyncOnLoadRequestDistance, Math::min);
        SessionConfig.registerConfigEntry(Config.Server.syncOnLoadRateLimit, Math::min);
        SessionConfig.registerConfigEntry(Config.Server.maxDataTransferSpeed, (x, y) -> {
            if (x == 0 && y == 0) {
                return 0;
            }
            return Math.min(x > 0 ? x : Integer.MAX_VALUE, y > 0 ? y : Integer.MAX_VALUE);
        });
    }

    private static class Entry {
        public final ConfigEntry<Object> supplier;
        public final BiFunction<Object, Object, Object> valueConstrainer;

        private <T> Entry(ConfigEntry<T> supplier, BiFunction<T, T, T> valueConstrainer) {
            this.supplier = supplier;
            this.valueConstrainer = valueConstrainer;
        }
    }

    public static class AnyChangeListener
    implements Closeable {
        private final ArrayList<ConfigChangeListener<?>> changeListeners = new ArrayList(SessionConfig.access$000().size());

        public AnyChangeListener(Runnable runnable) {
            for (Entry entry : CONFIG_ENTRIES.values()) {
                this.changeListeners.add(new ConfigChangeListener<Object>(entry.supplier, ignored -> runnable.run()));
            }
        }

        @Override
        public void close() {
            for (ConfigChangeListener<?> changeListener : this.changeListeners) {
                changeListener.close();
            }
            this.changeListeners.clear();
        }
    }
}

