/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.multiplayer.server;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.GeneratedFullDataSourceProvider;
import com.seibel.distanthorizons.core.level.AbstractDhServerLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.multiplayer.fullData.FullDataPayload;
import com.seibel.distanthorizons.core.multiplayer.server.DataSourceRequestGroup;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerState;
import com.seibel.distanthorizons.core.network.exceptions.RequestRejectedException;
import com.seibel.distanthorizons.core.network.exceptions.SectionRequiresSplittingException;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceRequestMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceResponseMessage;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;

public class FullDataSourceRequestHandler {
    private static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Common.Logging.logNetworkEvent.get());
    private final AbstractDhServerLevel serverLevel;
    private final ConcurrentMap<Long, DataSourceRequestGroup> requestGroupsByPos = new ConcurrentHashMap<Long, DataSourceRequestGroup>();
    private final ConcurrentMap<Long, DataSourceRequestGroup> requestGroupsByFutureId = new ConcurrentHashMap<Long, DataSourceRequestGroup>();

    private String getLevelIdentifier() {
        return this.serverLevel.getLevelWrapper().getDhIdentifier();
    }

    private GeneratedFullDataSourceProvider fullDataSourceProvider() {
        return this.serverLevel.serverside.fullDataFileHandler;
    }

    private List<BeaconBeamDTO> getAllBeamsForPos(long pos) {
        return this.serverLevel.beaconBeamRepo.getAllBeamsForPos(pos);
    }

    public FullDataSourceRequestHandler(AbstractDhServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    public void queueLodSyncForRequestMessage(ServerPlayerState serverPlayerState, FullDataSourceRequestMessage message, ServerPlayerState.RateLimiterSet rateLimiterSet) {
        if (!serverPlayerState.sessionConfig.getSynchronizeOnLoad()) {
            message.sendResponse(new RequestRejectedException("Operation is disabled in config."));
            return;
        }
        if (!rateLimiterSet.syncOnLoginRateLimiter.tryAcquire(message)) {
            return;
        }
        long clientTimestamp = message.clientTimestamp != null ? message.clientTimestamp : -1L;
        Long serverTimestamp = this.fullDataSourceProvider().getTimestampForPos(message.sectionPos);
        if (serverTimestamp == null || serverTimestamp <= clientTimestamp) {
            rateLimiterSet.syncOnLoginRateLimiter.release();
            message.sendResponse(new FullDataSourceResponseMessage(null));
            return;
        }
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getNetworkCompressionExecutor();
        if (executor == null) {
            LOGGER.warn("Unable to send FullDataSourceResponseMessage - getNetworkCompressionExecutor() is null", new Object[0]);
            return;
        }
        this.fullDataSourceProvider().getAsync(message.sectionPos).thenAcceptAsync(fullDataSource -> {
            try (FullDataPayload payload = new FullDataPayload((FullDataSourceV2)fullDataSource, this.getAllBeamsForPos(message.sectionPos));){
                serverPlayerState.fullDataPayloadSender.sendInChunks(payload, () -> {
                    message.sendResponse(new FullDataSourceResponseMessage(payload));
                    rateLimiterSet.syncOnLoginRateLimiter.release();
                });
            }
        }, (Executor)executor);
    }

    public void queueWorldGenForRequestMessage(ServerPlayerState serverPlayerState, FullDataSourceRequestMessage message, ServerPlayerState.RateLimiterSet rateLimiterSet) {
        if (!serverPlayerState.sessionConfig.isDistantGenerationEnabled()) {
            message.sendResponse(new RequestRejectedException("Operation is disabled in config."));
            return;
        }
        if (!rateLimiterSet.generationRequestRateLimiter.tryAcquire(message)) {
            return;
        }
        this.doQueueWorldGenForRequestMessage(new DataSourceRequestGroup.RequestData(serverPlayerState, message, rateLimiterSet));
    }

    private void doQueueWorldGenForRequestMessage(DataSourceRequestGroup.RequestData requestData) {
        DataSourceRequestGroup requestGroup;
        while (true) {
            AtomicBoolean createdNewGroup = new AtomicBoolean(false);
            requestGroup = this.requestGroupsByPos.computeIfAbsent(requestData.sectionPos(), pos -> {
                DataSourceRequestGroup newGroup = new DataSourceRequestGroup((long)pos);
                newGroup.tryAddRequest(requestData);
                createdNewGroup.set(true);
                this.tryFulfillDataSourceRequestGroup(newGroup, (long)pos);
                LOGGER.debug("[" + this.getLevelIdentifier() + "] Created request group for pos [" + DhSectionPos.toString(pos) + "].", new Object[0]);
                return newGroup;
            });
            if (createdNewGroup.get() || requestGroup.tryAddRequest(requestData)) break;
            Thread.yield();
        }
        this.requestGroupsByFutureId.put(requestData.futureId(), requestGroup);
    }

    public void cancelRequest(long requestId) {
        DataSourceRequestGroup requestGroup = (DataSourceRequestGroup)this.requestGroupsByFutureId.remove(requestId);
        if (requestGroup == null) {
            return;
        }
        DataSourceRequestGroup.RequestData removedRequest = requestGroup.tryRemoveRequest(requestId, requestsToTransfer -> {
            LOGGER.debug("[" + this.getLevelIdentifier() + "] Cancelled request group [" + DhSectionPos.toString(requestGroup.pos) + "].", new Object[0]);
            this.requestGroupsByPos.remove(requestGroup.pos);
            if (!requestsToTransfer.isEmpty()) {
                for (DataSourceRequestGroup.RequestData requestToTransfer : requestsToTransfer) {
                    this.doQueueWorldGenForRequestMessage(requestToTransfer);
                }
            } else {
                this.fullDataSourceProvider().removeRetrievalRequestIf(pos -> pos == requestGroup.pos);
            }
        });
        if (removedRequest != null) {
            removedRequest.rateLimiterSet.generationRequestRateLimiter.release();
        }
    }

    public void tick() {
        for (Map.Entry entry : this.requestGroupsByPos.entrySet()) {
            DataSourceRequestGroup requestGroup = (DataSourceRequestGroup)entry.getValue();
            if (requestGroup.fullDataSource == null) continue;
            LOGGER.debug("[" + this.getLevelIdentifier() + "] Fulfilled request group [" + DhSectionPos.toString((Long)entry.getKey()) + "]", new Object[0]);
            this.requestGroupsByPos.remove(entry.getKey());
            if (!requestGroup.tryClose()) continue;
            PriorityTaskPicker.Executor executor = ThreadPoolUtil.getNetworkCompressionExecutor();
            if (executor == null) {
                LOGGER.warn("Unable to send FullDataSourceResponseMessage - getNetworkCompressionExecutor() is null", new Object[0]);
                continue;
            }
            CompletableFuture.runAsync(() -> {
                try (FullDataPayload payload = new FullDataPayload(requestGroup.fullDataSource, this.getAllBeamsForPos((Long)entry.getKey()));){
                    for (DataSourceRequestGroup.RequestData requestData : requestGroup.requestMessages.values()) {
                        this.requestGroupsByFutureId.remove(requestData.futureId());
                        requestData.serverPlayerState.fullDataPayloadSender.sendInChunks(payload, () -> {
                            requestData.message.sendResponse(new FullDataSourceResponseMessage(payload));
                            requestData.rateLimiterSet.generationRequestRateLimiter.release();
                        });
                    }
                }
            }, executor);
        }
    }

    private void tryFulfillDataSourceRequestGroup(DataSourceRequestGroup requestGroup, long pos) {
        this.fullDataSourceProvider().getAsync(pos).thenAccept(fullDataSource -> {
            if (this.fullDataSourceProvider().isFullyGenerated(fullDataSource.columnGenerationSteps)) {
                requestGroup.fullDataSource = fullDataSource;
            } else if (Config.Common.WorldGenerator.distantGeneratorMode.get() == EDhApiDistantGeneratorMode.INTERNAL_SERVER || DhSectionPos.getDetailLevel(pos) > this.serverLevel.serverside.fullDataFileHandler.lowestDataDetailLevel()) {
                this.requestGroupsByPos.remove(pos);
                if (!requestGroup.tryClose()) {
                    return;
                }
                for (DataSourceRequestGroup.RequestData requestData : requestGroup.requestMessages.values()) {
                    this.requestGroupsByFutureId.remove(requestData.futureId());
                    requestData.rateLimiterSet.generationRequestRateLimiter.release();
                    requestData.message.sendResponse(new SectionRequiresSplittingException());
                }
            } else if (requestGroup.isWorldGenTaskComplete()) {
                this.tryFulfillDataSourceRequestGroup(requestGroup, pos);
            } else {
                this.fullDataSourceProvider().queuePositionForRetrieval(pos);
            }
        });
    }

    public void onWorldGenTaskComplete(long pos) {
        DataSourceRequestGroup requestGroup = (DataSourceRequestGroup)this.requestGroupsByPos.get(pos);
        if (requestGroup != null) {
            requestGroup.markWorldGenTaskComplete();
            this.tryFulfillDataSourceRequestGroup(requestGroup, pos);
        }
    }
}

