/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pooling;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListCheckout;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListParent;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.coreapi.util.StringUtil;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PhantomArrayListPool {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final int PHANTOM_REF_CHECK_TIME_IN_MS = 1000;
    private static final ThreadPoolExecutor RECYCLER_THREAD = ThreadUtil.makeSingleDaemonThreadPool("Phantom Array Recycler");
    private static final ArrayList<PhantomArrayListPool> POOL_LIST = new ArrayList();
    private static final boolean LOG_ARRAY_RECOVERY = false;
    private static boolean lowMemoryWarningLogged = false;
    public final String name;
    public final ConcurrentHashMap<Reference<? extends PhantomArrayListParent>, PhantomArrayListCheckout> phantomRefToCheckout = new ConcurrentHashMap();
    public final ReferenceQueue<PhantomArrayListParent> phantomRefQueue = new ReferenceQueue();
    private final ConcurrentLinkedQueue<ByteArrayList> pooledByteArrays = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ShortArrayList> pooledShortArrays = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<SoftReference<LongArrayList>> pooledLongArrays = new ConcurrentLinkedQueue();
    private final AtomicInteger totalByteArrayCountRef = new AtomicInteger(0);
    private final AtomicInteger totalShortArrayCountRef = new AtomicInteger(0);
    private final AtomicInteger totalLongArrayCountRef = new AtomicInteger(0);
    private long lastBytePoolSizeInBytes = -1L;
    private long lastShortPoolSizeInBytes = -1L;
    private long lastLongPoolSizeInBytes = -1L;
    private boolean clearLastRefPoolSizes = false;

    private static void runPhantomReferenceCleanupLoop() {
        while (true) {
            try {
                block5: while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    int i = 0;
                    while (true) {
                        if (i >= POOL_LIST.size()) continue block5;
                        PhantomArrayListPool pool = POOL_LIST.get(i);
                        int returnedByteArrayCount = 0;
                        int returnedShortArrayCount = 0;
                        int returnedLongArrayCount = 0;
                        Reference<PhantomArrayListParent> phantomRef = pool.phantomRefQueue.poll();
                        while (phantomRef != null) {
                            PhantomArrayListCheckout checkout = pool.phantomRefToCheckout.remove(phantomRef);
                            if (checkout != null) {
                                returnedByteArrayCount += checkout.getByteArrayCount();
                                returnedShortArrayCount += checkout.getShortArrayCount();
                                returnedLongArrayCount += checkout.getLongArrayCount();
                                pool.returnCheckout(checkout);
                            } else {
                                LOGGER.warn("Pool: [" + pool.name + "]. Unable to find checkout for phantom reference [" + phantomRef + "], arrays will need to be recreated.");
                            }
                            phantomRef = pool.phantomRefQueue.poll();
                        }
                        pool.recalculateSizeForDebugging();
                        ++i;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in phantom pool return thread, error: [" + e.getMessage() + "].", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public PhantomArrayListPool(String name) {
        POOL_LIST.add(this);
        this.name = name;
    }

    public PhantomArrayListCheckout checkoutArrays(int byteArrayCount, int shortArrayCount, int longArrayCount) {
        int i;
        PhantomArrayListCheckout checkout = new PhantomArrayListCheckout(this);
        for (i = 0; i < byteArrayCount; ++i) {
            checkout.addByteArrayList(PhantomArrayListPool.getPooledArray(this.pooledByteArrays, () -> this.createEmptyByteArrayList()));
        }
        for (i = 0; i < shortArrayCount; ++i) {
            checkout.addShortArrayList(PhantomArrayListPool.getPooledArray(this.pooledShortArrays, () -> this.createEmptyShortArrayList()));
        }
        for (i = 0; i < longArrayCount; ++i) {
            PhantomArrayListPool.addRefPooledArray(this.pooledLongArrays, this::createEmptyLongArrayList, this::onLongArrayListGarbageCollected, checkout::addLongArrayListRef);
        }
        return checkout;
    }

    private ByteArrayList createEmptyByteArrayList() {
        this.totalByteArrayCountRef.getAndIncrement();
        return new ByteArrayList(0);
    }

    private ShortArrayList createEmptyShortArrayList() {
        this.totalShortArrayCountRef.getAndIncrement();
        return new ShortArrayList(0);
    }

    private LongArrayList createEmptyLongArrayList() {
        this.totalLongArrayCountRef.getAndIncrement();
        return new LongArrayList(0);
    }

    private void onLongArrayListGarbageCollected() {
        this.clearLastRefPoolSizes = true;
        this.totalLongArrayCountRef.getAndDecrement();
    }

    private static <T extends List<?>> T getPooledArray(ConcurrentLinkedQueue<T> pool, Supplier<T> emptyArrayCreatorFunc) {
        List array = (List)pool.poll();
        if (array != null) {
            array.clear();
            return (T)array;
        }
        return (T)((List)emptyArrayCreatorFunc.get());
    }

    private static <T extends List<?>> void addRefPooledArray(ConcurrentLinkedQueue<SoftReference<T>> arrayPool, Supplier<T> emptyArrayCreatorFunc, Runnable arrayGarbageCollectedFunc, BiConsumer<T, SoftReference<T>> putArrayFunc) {
        List array = null;
        SoftReference<Object> arrayRef = arrayPool.poll();
        while (arrayRef != null && array == null) {
            array = (List)arrayRef.get();
            if (array != null) continue;
            if (!lowMemoryWarningLogged) {
                lowMemoryWarningLogged = true;
                String message = "\u00a76Distant Horizons: Insufficient memory detected.\u00a7r \nThis may cause stuttering or crashing. \nEither: your allocated memory isn't high enough, \nyour DH CPU preset is too high, or your DH quality preset is too high.";
                LOGGER.warn(message);
                if (Config.Common.Logging.Warning.showPoolInsufficientMemoryWarning.get().booleanValue()) {
                    ClientApi.INSTANCE.showChatMessageNextFrame(message);
                }
            }
            arrayGarbageCollectedFunc.run();
            arrayRef = arrayPool.poll();
        }
        if (array != null) {
            LodUtil.assertTrue(arrayRef != null, "How did we get an array without it's reference?");
            array.clear();
        } else {
            array = (List)emptyArrayCreatorFunc.get();
            arrayRef = new SoftReference<List>(array);
        }
        putArrayFunc.accept(array, arrayRef);
    }

    public void returnCheckout(PhantomArrayListCheckout checkout) {
        if (checkout == null) {
            throw new IllegalArgumentException("Null phantom checkout, memory leak in progress...");
        }
        this.pooledByteArrays.addAll(checkout.getAllByteArrays());
        this.pooledShortArrays.addAll(checkout.getAllShortArrays());
        this.pooledLongArrays.addAll(checkout.getAllLongArrayRefs());
    }

    public static void addDebugMenuStringsToListForCombinedPools(List<String> messageList) {
        int totalByteArrayCount = 0;
        int totalShortArrayCount = 0;
        int totalLongArrayCount = 0;
        int pooledByteArraySize = 0;
        int pooledShortArraySize = 0;
        int pooledLongArraySize = 0;
        long lastBytePoolSizeInBytes = 0L;
        long lastShortPoolSizeInBytes = 0L;
        long lastLongPoolSizeInBytes = 0L;
        for (int i = 0; i < POOL_LIST.size(); ++i) {
            PhantomArrayListPool pool = POOL_LIST.get(i);
            totalByteArrayCount += pool.totalByteArrayCountRef.get();
            totalShortArrayCount += pool.totalShortArrayCountRef.get();
            totalLongArrayCount += pool.totalLongArrayCountRef.get();
            pooledByteArraySize += pool.pooledByteArrays.size();
            pooledShortArraySize += pool.pooledShortArrays.size();
            pooledLongArraySize += pool.pooledLongArrays.size();
            lastBytePoolSizeInBytes += pool.lastBytePoolSizeInBytes;
            lastShortPoolSizeInBytes += pool.lastShortPoolSizeInBytes;
            lastLongPoolSizeInBytes += pool.lastLongPoolSizeInBytes;
        }
        PhantomArrayListPool.addDebugMenuStringsToList(messageList, "Combined", totalByteArrayCount, totalShortArrayCount, totalLongArrayCount, pooledByteArraySize, pooledShortArraySize, pooledLongArraySize, lastBytePoolSizeInBytes, lastShortPoolSizeInBytes, lastLongPoolSizeInBytes);
    }

    public static void addDebugMenuStringsToListForSeparatePools(List<String> messageList) {
        for (int i = 0; i < POOL_LIST.size(); ++i) {
            PhantomArrayListPool pool = POOL_LIST.get(i);
            pool.addDebugMenuStringsToList(messageList);
        }
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        PhantomArrayListPool.addDebugMenuStringsToList(messageList, this.name, this.totalByteArrayCountRef.get(), this.totalShortArrayCountRef.get(), this.totalLongArrayCountRef.get(), this.pooledByteArrays.size(), this.pooledShortArrays.size(), this.pooledLongArrays.size(), this.lastBytePoolSizeInBytes, this.lastShortPoolSizeInBytes, this.lastLongPoolSizeInBytes);
    }

    private static void addDebugMenuStringsToList(List<String> messageList, String name, int totalByteArrayCount, int totalShortArrayCount, int totalLongArrayCount, int numbOfByteArraysInPool, int numbOfShortArraysInPool, int numbOfLongArraysInPool, long lastBytePoolSizeInBytes, long lastShortPoolSizeInBytes, long lastLongPoolSizeInBytes) {
        String byteArrayTotalCount = F3Screen.NUMBER_FORMAT.format(totalByteArrayCount);
        String shortArrayTotalCount = F3Screen.NUMBER_FORMAT.format(totalShortArrayCount);
        String longArrayTotalCount = F3Screen.NUMBER_FORMAT.format(totalLongArrayCount);
        String bytePoolCount = F3Screen.NUMBER_FORMAT.format(numbOfByteArraysInPool);
        String shortPoolCount = F3Screen.NUMBER_FORMAT.format(numbOfShortArraysInPool);
        String longPoolCount = F3Screen.NUMBER_FORMAT.format(numbOfLongArraysInPool);
        String bytePoolSizeInBytes = lastBytePoolSizeInBytes != -1L ? " ~" + StringUtil.convertBytesToHumanReadable(lastBytePoolSizeInBytes) : "";
        String shortPoolSizeInBytes = lastShortPoolSizeInBytes != -1L ? " ~" + StringUtil.convertBytesToHumanReadable(lastShortPoolSizeInBytes) : "";
        String longPoolSizeInBytes = lastLongPoolSizeInBytes != -1L ? " ~" + StringUtil.convertBytesToHumanReadable(lastLongPoolSizeInBytes) : "";
        messageList.add(name + " - Pools:");
        if (totalByteArrayCount != 0) {
            messageList.add("byte[]: " + bytePoolCount + "/" + byteArrayTotalCount + bytePoolSizeInBytes);
        }
        if (totalShortArrayCount != 0) {
            messageList.add("short[]: " + shortPoolCount + "/" + shortArrayTotalCount + shortPoolSizeInBytes);
        }
        if (totalLongArrayCount != 0) {
            messageList.add("long[]: " + longPoolCount + "/" + longArrayTotalCount + longPoolSizeInBytes);
        }
    }

    public void recalculateSizeForDebugging() {
        long bytePoolByteSize = PhantomArrayListPool.estimateMemoryUsage(this.pooledByteArrays, 1L);
        this.lastBytePoolSizeInBytes = Math.max(bytePoolByteSize, this.lastBytePoolSizeInBytes);
        long shortPoolByteSize = PhantomArrayListPool.estimateMemoryUsage(this.pooledShortArrays, 2L);
        this.lastShortPoolSizeInBytes = Math.max(shortPoolByteSize, this.lastShortPoolSizeInBytes);
        if (this.clearLastRefPoolSizes) {
            this.lastLongPoolSizeInBytes = 0L;
            this.clearLastRefPoolSizes = false;
        }
        long longPoolByteSize = PhantomArrayListPool.estimateRefMemoryUsage(this.pooledLongArrays, 8L);
        this.lastLongPoolSizeInBytes = Math.max(longPoolByteSize, this.lastLongPoolSizeInBytes);
    }

    private static <T extends Collection<?>> long estimateMemoryUsage(ConcurrentLinkedQueue<T> pool, long elementSizeInBytes) {
        long longByteSize = 0L;
        for (Collection array : pool) {
            long overhead = 32L;
            long elementCount = PhantomArrayListPool.getCollectionCount(array);
            long arraySize = elementCount * elementSizeInBytes;
            longByteSize += overhead + arraySize;
        }
        return longByteSize;
    }

    private static <T extends Collection<?>> long estimateRefMemoryUsage(ConcurrentLinkedQueue<SoftReference<T>> pool, long elementSizeInBytes) {
        long longByteSize = 0L;
        for (SoftReference<T> arrayRef : pool) {
            long overhead = 32L;
            Collection array = (Collection)arrayRef.get();
            if (array == null) continue;
            long elementCount = PhantomArrayListPool.getCollectionCount(array);
            long arraySize = elementCount * elementSizeInBytes;
            longByteSize += overhead + arraySize;
        }
        return longByteSize;
    }

    private static long getCollectionCount(@NotNull Collection<?> array) {
        long elementCount;
        if (array instanceof ByteArrayList) {
            elementCount = ((ByteArrayList)array).elements().length;
        } else if (array instanceof ShortArrayList) {
            elementCount = ((ShortArrayList)array).elements().length;
        } else if (array instanceof LongArrayList) {
            elementCount = ((LongArrayList)array).elements().length;
        } else {
            throw new UnsupportedOperationException("Not implemented for type [" + array.getClass().getSimpleName() + "].");
        }
        return elementCount;
    }

    static {
        RECYCLER_THREAD.execute(() -> PhantomArrayListPool.runPhantomReferenceCleanupLoop());
    }
}

