/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.shaders;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.ScreenQuad;
import com.seibel.distanthorizons.core.render.renderer.shaders.AbstractShaderRenderer;
import com.seibel.distanthorizons.core.render.renderer.shaders.SSAOShader;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import org.lwjgl.opengl.GL32;

public class SSAOApplyShader
extends AbstractShaderRenderer {
    public static SSAOApplyShader INSTANCE = new SSAOApplyShader();
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    public int ssaoTexture;
    public int gSSAOMapUniform;
    public int gDepthMapUniform;
    public int gViewSizeUniform;
    public int gBlurRadiusUniform;
    public int gNearUniform;
    public int gFarUniform;

    @Override
    public void onInit() {
        this.shader = new ShaderProgram("shaders/normal.vert", "shaders/ssao/apply.frag", "fragColor", new String[]{"vPosition"});
        this.gSSAOMapUniform = this.shader.getUniformLocation("gSSAOMap");
        this.gDepthMapUniform = this.shader.getUniformLocation("gDepthMap");
        this.gViewSizeUniform = this.shader.tryGetUniformLocation("gViewSize");
        this.gBlurRadiusUniform = this.shader.tryGetUniformLocation("gBlurRadius");
        this.gNearUniform = this.shader.tryGetUniformLocation("gNear");
        this.gFarUniform = this.shader.tryGetUniformLocation("gFar");
    }

    @Override
    protected void onApplyUniforms(float partialTicks) {
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(LodRenderer.getActiveDepthTextureId());
        GL32.glUniform1i((int)this.gDepthMapUniform, (int)0);
        GLMC.glActiveTexture(33985);
        GLMC.glBindTexture(this.ssaoTexture);
        GL32.glUniform1i((int)this.gSSAOMapUniform, (int)1);
        GL32.glUniform1i((int)this.gBlurRadiusUniform, (int)Config.Client.Advanced.Graphics.Ssao.blurRadius.get());
        if (this.gViewSizeUniform >= 0) {
            GL32.glUniform2f((int)this.gViewSizeUniform, (float)MC_RENDER.getTargetFrameBufferViewportWidth(), (float)MC_RENDER.getTargetFrameBufferViewportHeight());
        }
        if (this.gNearUniform >= 0) {
            GL32.glUniform1f((int)this.gNearUniform, (float)RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks));
        }
        if (this.gFarUniform >= 0) {
            float farClipPlane = RenderUtil.getFarClipPlaneDistanceInBlocks();
            GL32.glUniform1f((int)this.gFarUniform, (float)farClipPlane);
        }
    }

    @Override
    protected void onRender() {
        GLMC.enableBlend();
        GL32.glBlendEquation((int)32774);
        GLMC.glBlendFuncSeparate(0, 770, 0, 1);
        GLMC.disableDepthTest();
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(0);
        GLMC.glBindFramebuffer(36008, SSAOShader.INSTANCE.frameBuffer);
        GLMC.glBindFramebuffer(36009, LodRenderer.getActiveFramebufferId());
        ScreenQuad.INSTANCE.render();
    }
}

