/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.DbConnectionClosedException;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.core.util.ListUtil;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FullDataSourceV2Repo
extends AbstractDhRepo<Long, FullDataSourceV2DTO> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final String insertSqlTemplate = "INSERT INTO " + this.getTableName() + " (\n   DetailLevel, PosX, PosZ, \n   MinY, DataChecksum, \n   Data, ColumnGenerationStep, ColumnWorldCompressionMode, Mapping, \n   DataFormatVersion, CompressionMode, ApplyToParent, \n   LastModifiedUnixDateTime, CreatedUnixDateTime) \nVALUES( \n    ?, ?, ?, \n    ?, ?, \n    ?, ?, ?, ?, \n    ?, ?, ?, \n    ?, ? \n);";
    private final String updateSqlTemplate = "UPDATE " + this.getTableName() + " \nSET \n    MinY = ? \n   ,DataChecksum = ? \n   ,Data = ? \n   ,ColumnGenerationStep = ? \n   ,ColumnWorldCompressionMode = ? \n   ,Mapping = ? \n   ,DataFormatVersion = ? \n   ,CompressionMode = ? \n   ,ApplyToParent = ? \n   ,LastModifiedUnixDateTime = ? \n   ,CreatedUnixDateTime = ? \nWHERE DetailLevel = ? AND PosX = ? AND PosZ = ?";
    private final String setApplyToParentSql = "UPDATE " + this.getTableName() + " \nSET ApplyToParent = ? \nWHERE DetailLevel = ? AND PosX = ? AND PosZ = ?";
    private final String getPositionsToUpdateSql = "SELECT DetailLevel, PosX, PosZ,    (sqrt(pow(PosX - ?, 2) + pow(PosZ - ?, 2))) AS Distance FROM " + this.getTableName() + " WHERE ApplyToParent = 1 ORDER BY Distance ASC LIMIT ?; ";
    private final String getColumnGenerationStepSql = "select ColumnGenerationStep, CompressionMode from " + this.getTableName() + " WHERE DetailLevel = ? AND PosX = ? AND PosZ = ?";
    private final String getTimestampForPosSql = "SELECT LastModifiedUnixDateTime FROM " + this.getTableName() + " WHERE DetailLevel = ? AND PosX = ? AND PosZ = ?;";
    private final String getTimestampForRangeSql = "SELECT PosX, PosZ, LastModifiedUnixDateTime FROM " + this.getTableName() + " WHERE DetailLevel = ? AND PosX BETWEEN ? AND ? AND PosZ BETWEEN ? AND ?;";
    private final String getAllPositionsSql = "select DetailLevel, PosX, PosZ from " + this.getTableName() + "; ";
    private final String getDataSizeInBytesSql = "select LENGTH(Data) as dataSize from " + this.getTableName() + " WHERE DetailLevel = ? AND PosX = ? AND PosZ = ?";
    private final String getTotalDataSizeInBytesSql = "select SUM(LENGTH(Data)) as dataSize from " + this.getTableName() + "; ";

    public FullDataSourceV2Repo(String databaseType, File databaseFile) throws SQLException {
        super(databaseType, databaseFile, FullDataSourceV2DTO.class);
    }

    @Override
    public String getTableName() {
        return "FullData";
    }

    @Override
    protected String CreateParameterizedWhereString() {
        return "DetailLevel = ? AND PosX = ? AND PosZ = ?";
    }

    @Override
    protected int setPreparedStatementWhereClause(PreparedStatement statement, int index, Long pos) throws SQLException {
        int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
        statement.setInt(index++, detailLevel);
        statement.setInt(index++, DhSectionPos.getX(pos));
        statement.setInt(index++, DhSectionPos.getZ(pos));
        return index;
    }

    @Override
    @Nullable
    public FullDataSourceV2DTO convertResultSetToDto(ResultSet resultSet) throws ClassCastException, IOException, SQLException {
        byte detailLevel = resultSet.getByte("DetailLevel");
        byte sectionDetailLevel = (byte)(detailLevel + 6);
        int posX = resultSet.getInt("PosX");
        int posZ = resultSet.getInt("PosZ");
        long pos = DhSectionPos.encode(sectionDetailLevel, posX, posZ);
        int minY = resultSet.getInt("MinY");
        int dataChecksum = resultSet.getInt("DataChecksum");
        byte dataFormatVersion = resultSet.getByte("DataFormatVersion");
        byte compressionModeValue = resultSet.getByte("CompressionMode");
        boolean applyToParent = resultSet.getInt("ApplyToParent") == 1;
        long lastModifiedUnixDateTime = resultSet.getLong("LastModifiedUnixDateTime");
        long createdUnixDateTime = resultSet.getLong("CreatedUnixDateTime");
        FullDataSourceV2DTO dto = FullDataSourceV2DTO.CreateEmptyDataSourceForDecoding();
        dto.compressedDataByteArray = FullDataSourceV2Repo.putAllBytes(resultSet.getBinaryStream("Data"), dto.compressedDataByteArray);
        dto.compressedColumnGenStepByteArray = FullDataSourceV2Repo.putAllBytes(resultSet.getBinaryStream("ColumnGenerationStep"), dto.compressedColumnGenStepByteArray);
        dto.compressedWorldCompressionModeByteArray = FullDataSourceV2Repo.putAllBytes(resultSet.getBinaryStream("ColumnWorldCompressionMode"), dto.compressedWorldCompressionModeByteArray);
        dto.compressedMappingByteArray = FullDataSourceV2Repo.putAllBytes(resultSet.getBinaryStream("Mapping"), dto.compressedMappingByteArray);
        dto.pos = pos;
        dto.dataChecksum = dataChecksum;
        dto.dataFormatVersion = dataFormatVersion;
        dto.compressionModeValue = compressionModeValue;
        dto.lastModifiedUnixDateTime = lastModifiedUnixDateTime;
        dto.createdUnixDateTime = createdUnixDateTime;
        dto.applyToParent = applyToParent;
        dto.levelMinY = minY;
        return dto;
    }

    @Override
    public PreparedStatement createInsertStatement(FullDataSourceV2DTO dto) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(this.insertSqlTemplate);
        if (statement == null) {
            return null;
        }
        int i = 1;
        statement.setObject(i++, DhSectionPos.getDetailLevel(dto.pos) - 6);
        statement.setObject(i++, DhSectionPos.getX(dto.pos));
        statement.setObject(i++, DhSectionPos.getZ(dto.pos));
        statement.setObject(i++, dto.levelMinY);
        statement.setObject(i++, dto.dataChecksum);
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedDataByteArray.elements()), dto.compressedDataByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedColumnGenStepByteArray.elements()), dto.compressedColumnGenStepByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedWorldCompressionModeByteArray.elements()), dto.compressedWorldCompressionModeByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedMappingByteArray.elements()), dto.compressedMappingByteArray.size());
        statement.setObject(i++, dto.dataFormatVersion);
        statement.setObject(i++, dto.compressionModeValue);
        statement.setObject(i++, dto.applyToParent);
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, System.currentTimeMillis());
        return statement;
    }

    @Override
    public PreparedStatement createUpdateStatement(FullDataSourceV2DTO dto) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(this.updateSqlTemplate);
        if (statement == null) {
            return null;
        }
        int i = 1;
        statement.setObject(i++, dto.levelMinY);
        statement.setObject(i++, dto.dataChecksum);
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedDataByteArray.elements()), dto.compressedDataByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedColumnGenStepByteArray.elements()), dto.compressedColumnGenStepByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedWorldCompressionModeByteArray.elements()), dto.compressedWorldCompressionModeByteArray.size());
        statement.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(dto.compressedMappingByteArray.elements()), dto.compressedMappingByteArray.size());
        statement.setObject(i++, dto.dataFormatVersion);
        statement.setObject(i++, dto.compressionModeValue);
        statement.setObject(i++, dto.applyToParent);
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, dto.createdUnixDateTime);
        statement.setObject(i++, DhSectionPos.getDetailLevel(dto.pos) - 6);
        statement.setObject(i++, DhSectionPos.getX(dto.pos));
        statement.setObject(i++, DhSectionPos.getZ(dto.pos));
        return statement;
    }

    public void setApplyToParent(long pos, boolean applyToParent) {
        PreparedStatement statement = this.createPreparedStatement(this.setApplyToParentSql);
        if (statement == null) {
            return;
        }
        try {
            int i = 1;
            statement.setBoolean(i++, applyToParent);
            int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
            statement.setInt(i++, detailLevel);
            statement.setInt(i++, DhSectionPos.getX(pos));
            statement.setInt(i++, DhSectionPos.getZ(pos));
            this.query(statement);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public LongArrayList getPositionsToUpdate(int targetBlockPosX, int targetBlockPosZ, int returnCount) {
        LongArrayList list = new LongArrayList();
        PreparedStatement statement = this.createPreparedStatement(this.getPositionsToUpdateSql);
        if (statement == null) {
            return list;
        }
        try {
            int i = 1;
            statement.setInt(i++, targetBlockPosX);
            statement.setInt(i++, targetBlockPosZ);
            statement.setInt(i++, returnCount);
            ResultSet result = this.query(statement);
            while (result != null && result.next()) {
                byte detailLevel = result.getByte("DetailLevel");
                byte sectionDetailLevel = (byte)(detailLevel + 6);
                int posX = result.getInt("PosX");
                int posZ = result.getInt("PosZ");
                long pos = DhSectionPos.encode(sectionDetailLevel, posX, posZ);
                list.add(pos);
            }
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void getColumnGenerationStepForPos(long pos, ByteArrayList outputByteArray) {
        PreparedStatement statement = this.createPreparedStatement(this.getColumnGenerationStepSql);
        if (statement == null) {
            return;
        }
        try {
            int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
            int i = 1;
            statement.setInt(i++, detailLevel);
            statement.setInt(i++, DhSectionPos.getX(pos));
            statement.setInt(i++, DhSectionPos.getZ(pos));
            ResultSet result = this.query(statement);
            if (result == null || !result.next()) {
                return;
            }
            byte compressionModeEnumValue = result.getByte("CompressionMode");
            EDhApiDataCompressionMode compressionModeEnum = EDhApiDataCompressionMode.getFromValue(compressionModeEnumValue);
            try {
                DhDataInputStream compressedIn = new DhDataInputStream(result.getBinaryStream("ColumnGenerationStep"), compressionModeEnum);
                FullDataSourceV2Repo.putAllBytes(compressedIn, outputByteArray);
            }
            catch (IOException e) {
                LOGGER.warn("Decompression issue when getting column gen steps for pos: [" + DhSectionPos.toString(pos) + "], deleting corrupted data.", (Throwable)e);
                this.deleteWithKey(pos);
                ListUtil.clearAndSetSize(outputByteArray, 4096);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Long getTimestampForPos(long pos) {
        try {
            PreparedStatement preparedStatement = this.createPreparedStatement(this.getTimestampForPosSql);
            if (preparedStatement == null) {
                return null;
            }
            int i = 1;
            preparedStatement.setInt(i++, DhSectionPos.getDetailLevel(pos) - 6);
            preparedStatement.setInt(i++, DhSectionPos.getX(pos));
            preparedStatement.setInt(i++, DhSectionPos.getZ(pos));
            ResultSet result = this.query(preparedStatement);
            if (result == null || !result.next()) {
                return null;
            }
            return result.getLong("LastModifiedUnixDateTime");
        }
        catch (DbConnectionClosedException e) {
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Long, Long> getTimestampsForRange(byte detailLevel, int startPosX, int startPosZ, int endPosX, int endPosZ) {
        try {
            PreparedStatement preparedStatement = this.createPreparedStatement(this.getTimestampForRangeSql);
            if (preparedStatement == null) {
                return new HashMap<Long, Long>();
            }
            int i = 1;
            preparedStatement.setInt(i++, detailLevel - 6);
            preparedStatement.setInt(i++, startPosX);
            preparedStatement.setInt(i++, endPosX - 1);
            preparedStatement.setInt(i++, startPosZ);
            preparedStatement.setInt(i++, endPosZ - 1);
            ResultSet result = this.query(preparedStatement);
            HashMap<Long, Long> returnMap = new HashMap<Long, Long>();
            while (result != null && result.next()) {
                long key = DhSectionPos.encode(detailLevel, result.getInt("PosX"), result.getInt("PosZ"));
                long value = result.getLong("LastModifiedUnixDateTime");
                returnMap.put(key, value);
            }
            return returnMap;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public LongArrayList getAllPositions() {
        LongArrayList list = new LongArrayList();
        PreparedStatement statement = this.createPreparedStatement(this.getAllPositionsSql);
        if (statement == null) {
            return list;
        }
        try {
            ResultSet result = this.query(statement);
            while (result != null && result.next()) {
                byte detailLevel = result.getByte("DetailLevel");
                byte sectionDetailLevel = (byte)(detailLevel + 6);
                int posX = result.getInt("PosX");
                int posZ = result.getInt("PosZ");
                long pos = DhSectionPos.encode(sectionDetailLevel, posX, posZ);
                list.add(pos);
            }
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public long getDataSizeInBytes(long pos) {
        int detailLevel = DhSectionPos.getDetailLevel(pos) - 6;
        PreparedStatement statement = this.createPreparedStatement(this.getDataSizeInBytesSql);
        if (statement == null) {
            return 0L;
        }
        try {
            int i = 1;
            statement.setInt(i++, detailLevel);
            statement.setInt(i++, DhSectionPos.getX(pos));
            statement.setInt(i++, DhSectionPos.getZ(pos));
            ResultSet result = this.query(statement);
            if (result == null || !result.next()) {
                return 0L;
            }
            return result.getLong("dataSize");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public long getTotalDataSizeInBytes() {
        PreparedStatement statement = this.createPreparedStatement(this.getTotalDataSizeInBytesSql);
        try {
            ResultSet result = this.query(statement);
            if (result == null || !result.next()) {
                return 0L;
            }
            return result.getLong("dataSize");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static ByteArrayList putAllBytes(InputStream inputStream, @Nullable ByteArrayList existingArrayList) throws IOException {
        if (existingArrayList == null) {
            existingArrayList = new ByteArrayList(64);
        } else {
            existingArrayList.clear();
        }
        try {
            int nextByte = inputStream.read();
            while (nextByte != -1) {
                existingArrayList.add((byte)nextByte);
                nextByte = inputStream.read();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return existingArrayList;
    }
}

