/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.handler;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.block.v1.BlockConversionHelper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlockConversionHandler {
    public static final Component INVALID_BLOCK_COMPONENT = Component.translatable((String)"container.invalidBlock");
    private static final BiMap<Block, Block> BLOCK_CONVERSIONS = HashBiMap.create();
    private static final Map<BlockState, BlockState> BLOCK_STATE_CONVERSIONS_CACHE = new MapMaker().weakKeys().weakValues().makeMap();

    public static RegistryEntryAddedCallback<Block> onRegistryEntryAdded(Predicate<Block> filter, Function<BlockBehaviour.Properties, Block> factory, String modId) {
        return (registry, id, block, registrar) -> {
            if (filter.test((Block)block)) {
                ResourceLocation resourceLocation = ResourceLocationHelper.fromNamespaceAndPath((String)modId, (String)(id.getNamespace() + "/" + id.getPath()));
                registrar.accept(resourceLocation, () -> {
                    BlockBehaviour.Properties properties = BlockConversionHelper.copyBlockProperties((Block)block, (ResourceLocation)resourceLocation);
                    Block newBlock = (Block)factory.apply(properties);
                    BLOCK_CONVERSIONS.put(block, (Object)newBlock);
                    return newBlock;
                });
            }
        };
    }

    public static BiMap<Block, Block> getBlockConversions() {
        return Maps.unmodifiableBiMap(BLOCK_CONVERSIONS);
    }

    public static AddBlockEntityTypeBlocksCallback onAddBlockEntityTypeBlocks(Holder.Reference<? extends BlockEntityType<?>> blockEntityType) {
        return consumer -> {
            for (Map.Entry entry : BLOCK_CONVERSIONS.entrySet()) {
                consumer.accept((BlockEntityType)blockEntityType.value(), (Block)entry.getValue());
            }
        };
    }

    public static PlayerInteractEvents.UseBlock onUseBlock(TagKey<Block> unalteredBlocks, BooleanSupplier disableVanillaBlock) {
        return (player, level, interactionHand, hitResult) -> {
            if (!disableVanillaBlock.getAsBoolean()) {
                return EventResultHolder.pass();
            }
            BlockState blockState = level.getBlockState(hitResult.getBlockPos());
            if (BLOCK_CONVERSIONS.containsKey((Object)blockState.getBlock()) && !blockState.is(unalteredBlocks)) {
                player.displayClientMessage((Component)Component.empty().append(INVALID_BLOCK_COMPONENT).withStyle(ChatFormatting.RED), true);
                return EventResultHolder.interrupt((Object)InteractionResultHelper.sidedSuccess((boolean)level.isClientSide));
            }
            return EventResultHolder.pass();
        };
    }

    public static TagsUpdatedCallback onTagsUpdated(TagKey<Block> unalteredBlocks, Predicate<Block> filter) {
        return (registries, client) -> {
            for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
                Object patt0$temp = entry.getValue();
                if (!(patt0$temp instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)patt0$temp;
                Block block = blockItem.getBlock();
                BlockConversionHandler.setItemForBlock(filter, blockItem, block);
                BlockConversionHandler.setBlockForItem(unalteredBlocks, blockItem, block);
            }
            BLOCK_CONVERSIONS.forEach(BlockConversionHelper::copyBoundTags);
        };
    }

    private static void setItemForBlock(Predicate<Block> filter, BlockItem blockItem, Block block) {
        if (filter.test(block)) {
            BlockConversionHelper.setItemForBlock((Block)((Block)BLOCK_CONVERSIONS.get((Object)block)), (Item)blockItem);
        }
    }

    private static void setBlockForItem(TagKey<Block> tagKey, BlockItem blockItem, Block block) {
        Block oldBlock;
        Block newBlock = (Block)BLOCK_CONVERSIONS.get((Object)block);
        if (newBlock != null) {
            oldBlock = block;
        } else {
            oldBlock = (Block)BLOCK_CONVERSIONS.inverse().get((Object)block);
            if (oldBlock != null) {
                newBlock = block;
            } else {
                return;
            }
        }
        if (RegistryHelper.is(tagKey, (Object)oldBlock)) {
            BlockConversionHelper.setBlockForItem((BlockItem)blockItem, (Block)oldBlock);
        } else {
            BlockConversionHelper.setBlockForItem((BlockItem)blockItem, (Block)newBlock);
        }
    }

    @Nullable
    public static BlockState convertToVanillaBlock(@Nullable BlockState blockState) {
        return BlockConversionHandler.applyBlockConversion(blockState, true);
    }

    @Nullable
    public static BlockState convertFromVanillaBlock(@Nullable BlockState blockState) {
        return BlockConversionHandler.applyBlockConversion(blockState, false);
    }

    @Nullable
    private static BlockState applyBlockConversion(@Nullable BlockState blockState, boolean inverse) {
        if (blockState != null) {
            return BLOCK_STATE_CONVERSIONS_CACHE.computeIfAbsent(blockState, BlockConversionHandler.applyBlockConversion(inverse));
        }
        return null;
    }

    private static UnaryOperator<BlockState> applyBlockConversion(boolean inverse) {
        return blockState -> {
            BiMap blockConversions;
            BiMap biMap = blockConversions = inverse ? BLOCK_CONVERSIONS.inverse() : BLOCK_CONVERSIONS;
            if (blockState != null && blockConversions.containsKey((Object)blockState.getBlock())) {
                Block block = (Block)blockConversions.get((Object)blockState.getBlock());
                return BlockConversionHandler.copyAllProperties(blockState, block.defaultBlockState());
            }
            return blockState;
        };
    }

    private static <T extends Comparable<T>, V extends T> BlockState copyAllProperties(BlockState oldBlockState, BlockState newBlockState) {
        for (Map.Entry entry : oldBlockState.getValues().entrySet()) {
            newBlockState = (BlockState)newBlockState.trySetValue((Property)entry.getKey(), (Comparable)entry.getValue());
        }
        return newBlockState;
    }
}

