/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.anvilrestoration_common_neoforge.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class AnvilInteractEvent {
    public static InteractionResult onAnvilClick(Player player, Level world, InteractionHand hand, BlockHitResult blockHitResult) {
        BlockState newstate;
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (!item.equals(Items.IRON_INGOT) && !item.equals(Items.OBSIDIAN)) {
            return InteractionResult.PASS;
        }
        BlockPos pos = blockHitResult.getBlockPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block.equals(Blocks.ANVIL) && item.equals(Items.OBSIDIAN)) {
            newstate = Blocks.CHIPPED_ANVIL.defaultBlockState();
        } else if (block.equals(Blocks.CHIPPED_ANVIL)) {
            newstate = item.equals(Items.IRON_INGOT) ? Blocks.ANVIL.defaultBlockState() : Blocks.DAMAGED_ANVIL.defaultBlockState();
        } else if (block.equals(Blocks.DAMAGED_ANVIL) && item.equals(Items.IRON_INGOT)) {
            newstate = Blocks.CHIPPED_ANVIL.defaultBlockState();
        } else {
            return InteractionResult.PASS;
        }
        Direction rotation = (Direction)state.getValue((Property)AnvilBlock.FACING);
        world.setBlock(pos, (BlockState)newstate.setValue((Property)AnvilBlock.FACING, (Comparable)rotation), 3);
        if (item.equals(Items.IRON_INGOT)) {
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_PLACE, SoundSource.BLOCKS, 0.5f, 1.0f);
        } else {
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }
}

