/*
 * Decompiled with CFR 0.152.
 */
package betterdays.client;

import betterdays.config.ConfigHandler;
import betterdays.time.Time;
import betterdays.wrappers.ClientLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.LevelAccessor;

public class TimeInterpolator {
    public static TimeInterpolator instance;
    public final ClientLevelWrapper level;
    private boolean initialized;
    private long targetTime;
    private float timeVelocity;
    private long lastTime;
    private float lastPartialTickTime;

    public static void onWorldLoad(LevelAccessor level) {
        if (ClientLevelWrapper.isClientLevel(level)) {
            ClientLevelWrapper levelWrapper = new ClientLevelWrapper(level);
            instance = new TimeInterpolator(levelWrapper);
        }
    }

    public static void onWorldUnload(LevelAccessor level) {
        if (instance != null && ((ClientLevel)TimeInterpolator.instance.level.get()).equals(level)) {
            instance = null;
        }
    }

    public static void onRenderTickEvent(float renderTickTime) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.isPaused() && instance != null && ((ClientLevel)TimeInterpolator.instance.level.get()).equals(minecraft.level) && !ConfigHandler.Client.getBlacklistDimensions().contains(((ClientLevel)TimeInterpolator.instance.level.get()).dimension().location())) {
            instance.partialTick(renderTickTime);
        }
    }

    public static void onClientTickEvent(Minecraft minecraft) {
        if (!minecraft.isPaused() && instance != null && ((ClientLevel)TimeInterpolator.instance.level.get()).equals(minecraft.level)) {
            instance.undoVanillaTimeTicks();
        }
    }

    public TimeInterpolator(ClientLevelWrapper level) {
        this.level = level;
        this.initialized = false;
    }

    private void init() {
        long time;
        this.targetTime = time = ((ClientLevel)this.level.get()).getDayTime();
        this.lastTime = time;
        this.initialized = true;
    }

    public void partialTick(float partialTickTime) {
        if (!this.initialized) {
            this.init();
        }
        float tickTimeDelta = this.getPartialTimeDelta(partialTickTime);
        this.updateTargetTime();
        this.interpolateTime(tickTimeDelta);
    }

    private float getPartialTimeDelta(float partialTickTime) {
        float partialTimeDelta = partialTickTime - this.lastPartialTickTime;
        if (partialTimeDelta < 0.0f) {
            partialTimeDelta += 1.0f;
        }
        this.lastPartialTickTime = partialTickTime;
        return partialTimeDelta;
    }

    private void interpolateTime(float tickTimeDelta) {
        long time = ((ClientLevel)this.level.get()).getDayTime();
        float duration = 1.0f;
        float omega = 2.0f;
        float x = 2.0f * tickTimeDelta;
        float exp = 1.0f / (1.0f + x + 0.48f * x * x + 0.235f * x * x * x);
        float change = time - this.targetTime;
        float temp = (this.timeVelocity + 2.0f * change) * tickTimeDelta;
        time = this.targetTime + (long)((change + temp) * exp);
        this.timeVelocity = (this.timeVelocity - 2.0f * temp) * exp;
        if (change < 0.0f == time > this.targetTime) {
            time = this.targetTime;
            this.timeVelocity = 0.0f;
        }
        this.setDayTime(time);
    }

    private void updateTargetTime() {
        long time = ((ClientLevel)this.level.get()).getDayTime();
        if (time != this.lastTime) {
            this.targetTime = time;
            long discrepancy = this.lastTime - time;
            if (Math.abs(discrepancy) > 24000L) {
                long newTimeOfDay = Time.timeOfDay(time);
                long oldTimeOfDay = Time.timeOfDay(this.lastTime);
                this.lastTime = time - newTimeOfDay + oldTimeOfDay;
            }
            ((ClientLevel)this.level.get()).getLevelData().setDayTime(this.lastTime);
        }
    }

    private void setDayTime(long time) {
        ((ClientLevel)this.level.get()).getLevelData().setDayTime(time);
        this.lastTime = time;
    }

    private void undoVanillaTimeTicks() {
        if (this.level.daylightRuleEnabled()) {
            ((ClientLevel)this.level.get()).getLevelData().setDayTime(((ClientLevel)this.level.get()).getDayTime() - 1L);
        }
    }
}

