/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.blueprints;

import com.mistrx.prefabricated_structures.PrefabricatedStructures;
import com.mistrx.prefabricated_structures.blueprints.BlueprintsConfig;
import com.mistrx.prefabricated_structures.blueprints.BlueprintsData;
import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.rendering.RenderHandler;
import com.mistrx.prefabricated_structures.util.Functions;
import com.mistrx.prefabricated_structures.util.Variables;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class BlueprintItem {
    public static String status = "";
    public static boolean hasLoadedBuild = false;

    public static void handleRightClick(final Player player, final BlockPos hitPos, String blueprintItemName) {
        if (((List)BlueprintsConfig.DISALLOWED_BLUEPRINTS_ITEMS.get()).contains(blueprintItemName)) {
            player.displayClientMessage((Component)Component.literal((String)"This blueprint is disabled in the config and cannot be used"), true);
            return;
        }
        PrefabricatedStructures.LOGGER.info("handleRightClick: " + status);
        if (Objects.equals(status, "") && !hasLoadedBuild) {
            final String boundBuildId = BlueprintsData.blueprintIDs.get(blueprintItemName);
            PrefabricatedStructures.LOGGER.info("BoundBuildID: " + boundBuildId);
            if (boundBuildId == null) {
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        status = "loading";
                        player.displayClientMessage((Component)Component.translatable((String)"blueprint.loading").withStyle(ChatFormatting.GREEN), true);
                        String oldBuildID = Variables.buildID;
                        String status = Firebase.getSelectedBuildingID();
                        if (status.equals("error")) {
                            BlueprintItem.status = "";
                            MutableComponent buildpastecomponent = Component.literal((String)"Buildpaste.net");
                            Style componentStyle = Style.EMPTY;
                            componentStyle = componentStyle.applyFormat(ChatFormatting.GREEN);
                            componentStyle = componentStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://buildpaste.net/category?&player=" + player.getDisplayName().getString()));
                            componentStyle = componentStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open https://buildpaste.net, create an account and select one of 2500+ structures")));
                            buildpastecomponent.setStyle(componentStyle);
                            MutableComponent component1 = Component.literal((String)"Custom Blueprints");
                            componentStyle = Style.EMPTY;
                            component1.setStyle(componentStyle);
                            Variables.player.displayClientMessage((Component)Component.translatable((String)"blueprint.not-connected", (Object[])new Object[]{component1, buildpastecomponent}), false);
                            return;
                        }
                        String newBuildID = Variables.buildID;
                        PrefabricatedStructures.LOGGER.info(oldBuildID + ", " + newBuildID);
                        if (!Objects.equals(oldBuildID, newBuildID) || Firebase.blockIDs == null) {
                            String getBuildResult = Firebase.getBuilding(Variables.buildID, false, null, null, null);
                            if (getBuildResult.equals("error-404")) {
                                BlueprintItem.status = "error-404";
                                return;
                            }
                            if (getBuildResult.equals("error")) {
                                BlueprintItem.status = "error";
                                return;
                            }
                        }
                        hasLoadedBuild = true;
                        BlueprintItem.status = "in-preview";
                        RenderHandler.startPreviewPosition = BlueprintItem.calculateStartPosition(hitPos);
                        RenderHandler.isUsingPreviewCommand = true;
                        RenderHandler.prepareRenderBlocks(player);
                    }
                }, 1L);
            } else {
                Variables.buildID = boundBuildId;
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        status = "loading";
                        player.displayClientMessage((Component)Component.translatable((String)"blueprint.loading").withStyle(ChatFormatting.GREEN), true);
                        String getBuildResult = Firebase.getBuilding(boundBuildId, false, null, null, null);
                        if (getBuildResult.equals("error-404")) {
                            status = "error-404";
                            return;
                        }
                        if (getBuildResult.equals("error")) {
                            status = "error";
                            return;
                        }
                        hasLoadedBuild = true;
                        status = "in-preview";
                        RenderHandler.startPreviewPosition = BlueprintItem.calculateStartPosition(hitPos);
                        RenderHandler.isUsingPreviewCommand = true;
                        RenderHandler.prepareRenderBlocks(player);
                    }
                }, 1L);
            }
        } else if (Objects.equals(status, "") && hasLoadedBuild) {
            status = "in-preview";
            RenderHandler.startPreviewPosition = BlueprintItem.calculateStartPosition(hitPos);
            RenderHandler.isUsingPreviewCommand = true;
            RenderHandler.prepareRenderBlocks(player);
        } else if (Objects.equals(status, "in-preview") && hasLoadedBuild) {
            if (!player.isCreative()) {
                ServerPlayer serverPlayer = Minecraft.getInstance().getSingleplayerServer().getPlayerList().getPlayer(player.getUUID());
                if (blueprintItemName.equals("blueprint")) {
                    int xp = player.experienceLevel;
                    int blocksCount = (int)(Firebase.size.x * Firebase.size.y * Firebase.size.z);
                    int requiredXp = 0;
                    requiredXp = blocksCount < 10000 ? 1 : (blocksCount < 50000 ? 2 : (blocksCount < 100000 ? 3 : (blocksCount < 500000 ? 4 : 5)));
                    if (requiredXp > xp) {
                        player.displayClientMessage((Component)Component.translatable((String)"blueprint.xp.insufficient", (Object[])new Object[]{requiredXp}), false);
                        return;
                    }
                    serverPlayer.giveExperienceLevels(-requiredXp);
                } else {
                    serverPlayer.getInventory().setItem(player.getInventory().selected, new ItemStack((ItemLike)Items.AIR));
                }
            }
            status = "";
            Minecraft.getInstance().player.connection.sendUnsignedCommand("_pasteblueprint");
        }
    }

    public static void handleLeftClick(Player player) {
        status = "";
        RenderHandler.stopRendering();
    }

    private static BlockPos calculateStartPosition(BlockPos hitPos) {
        Vec3 startPos;
        String lookDirection = Functions.getLookDirection(Minecraft.getInstance().player.getViewYRot(1.0f));
        if (Firebase.uploadDirection.equals("north") || Firebase.uploadDirection.equals("south")) {
            switch (lookDirection) {
                case "east": {
                    startPos = new Vec3((double)(hitPos.getX() + 1), (double)hitPos.getY(), (double)hitPos.getZ() - Firebase.size.x / 2.0);
                    break;
                }
                case "south": {
                    startPos = new Vec3((double)hitPos.getX() + Firebase.size.x / 2.0 + 1.0, (double)hitPos.getY(), (double)(hitPos.getZ() + 1));
                    break;
                }
                case "west": {
                    startPos = new Vec3((double)hitPos.getX(), (double)hitPos.getY(), (double)hitPos.getZ() + Firebase.size.x / 2.0 + 1.0);
                    break;
                }
                default: {
                    startPos = new Vec3((double)hitPos.getX() - Firebase.size.x / 2.0, (double)hitPos.getY(), (double)hitPos.getZ());
                    break;
                }
            }
        } else {
            switch (lookDirection) {
                case "east": {
                    startPos = new Vec3((double)(hitPos.getX() + 1), (double)hitPos.getY(), (double)hitPos.getZ() - Firebase.size.z / 2.0);
                    break;
                }
                case "south": {
                    startPos = new Vec3((double)hitPos.getX() + Firebase.size.z / 2.0 + 1.0, (double)hitPos.getY(), (double)(hitPos.getZ() + 1));
                    break;
                }
                case "west": {
                    startPos = new Vec3((double)hitPos.getX(), (double)hitPos.getY(), (double)hitPos.getZ() + Firebase.size.z / 2.0 + 1.0);
                    break;
                }
                default: {
                    startPos = new Vec3((double)hitPos.getX() - Firebase.size.z / 2.0, (double)hitPos.getY(), (double)hitPos.getZ());
                }
            }
        }
        return new BlockPos((int)Math.floor(startPos.x), hitPos.getY(), (int)Math.floor(startPos.z));
    }
}

