/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.blueprints;

import com.mistrx.prefabricated_structures.PrefabricatedStructures;
import com.mistrx.prefabricated_structures.blueprints.BlueprintItem;
import com.mistrx.prefabricated_structures.blueprints.BlueprintsData;
import com.mistrx.prefabricated_structures.blueprints.BlueprintsFunctions;
import com.mistrx.prefabricated_structures.blueprints._PasteForBlueprint;
import com.mistrx.prefabricated_structures.commands.BindBuildCommand;
import com.mistrx.prefabricated_structures.commands.BuildPlacerCommand;
import com.mistrx.prefabricated_structures.commands.ConnectAccountsCommand;
import com.mistrx.prefabricated_structures.commands.ConstructCommand;
import com.mistrx.prefabricated_structures.commands.DisconnectAccountCommand;
import com.mistrx.prefabricated_structures.commands.PasteCommand;
import com.mistrx.prefabricated_structures.commands.PasteForBuildPlacerCommand;
import com.mistrx.prefabricated_structures.commands.PasteHistoryCommand;
import com.mistrx.prefabricated_structures.commands.PreviewCommand;
import com.mistrx.prefabricated_structures.commands.UndoPasteCommand;
import com.mistrx.prefabricated_structures.commands._ClearCommand;
import com.mistrx.prefabricated_structures.commands._FillCommandNoRestriction;
import com.mistrx.prefabricated_structures.commands._OpenAfterPasteMenuCommand;
import com.mistrx.prefabricated_structures.commands._OpenBuildPlacerMenu;
import com.mistrx.prefabricated_structures.commands._RemoveRenderCommand;
import com.mistrx.prefabricated_structures.commands._SetBlockCommand;
import com.mistrx.prefabricated_structures.items.build_placer.BuildPlacerHandler;
import com.mistrx.prefabricated_structures.rendering.RenderHandler;
import com.mistrx.prefabricated_structures.util.Functions;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="prefabricated_structures", bus=EventBusSubscriber.Bus.GAME)
public class BlueprintsEvents {
    public static int lastSelectedItemSlot = 0;
    public static String lastSelectedBlueprintItemID = "";

    @SubscribeEvent
    public static void registerCommandsEvent(RegisterCommandsEvent event) {
        if (!BlueprintsFunctions.hasBuildpasteLoaded().booleanValue()) {
            ConnectAccountsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            DisconnectAccountCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            PasteCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            ConstructCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            PreviewCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            BuildPlacerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            BindBuildCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            PasteHistoryCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            _OpenAfterPasteMenuCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            PasteForBuildPlacerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            _SetBlockCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
            _ClearCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
            _FillCommandNoRestriction.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
            _RemoveRenderCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            _OpenBuildPlacerMenu.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
        _PasteForBlueprint.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        UndoPasteCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        Functions.setItemEqualsBlockHashmap();
    }

    @SubscribeEvent
    public static void WorldEnterEvent(PlayerEvent.PlayerLoggedInEvent event) {
        BlueprintsData.loadTextures();
    }

    @SubscribeEvent
    public static void onLeftClickBlockWithSpecialItemEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (BlueprintsEvents.handleSpecialItemClick(event.getEntity(), event.getPos(), CLICK_TYPE.LEFT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLeftClickAirWithSpecialItemEvent(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlueprintsEvents.handleSpecialItemClick(event.getEntity(), null, CLICK_TYPE.LEFT);
    }

    @SubscribeEvent
    public static void onRightClickBlockWithSpecialItemEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (BlueprintsEvents.handleSpecialItemClick(event.getEntity(), event.getPos(), CLICK_TYPE.RIGHT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickAirWithSpecialItemEvent(PlayerInteractEvent.RightClickEmpty event) {
        BlueprintsEvents.handleSpecialItemClick(event.getEntity(), null, CLICK_TYPE.RIGHT);
    }

    @SubscribeEvent
    public static void onLeftClickBlockWithBlueprint(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        Level world = player.getCommandSenderWorld();
        ItemStack itemStack = event.getItemStack();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath();
        if (itemId.startsWith("blueprint")) {
            if (Objects.equals(BlueprintItem.status, "in-preview") && world.isClientSide) {
                BlueprintItem.handleLeftClick(player);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLeftClickAirWithBlueprint(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        Level world = player.getCommandSenderWorld();
        if (!world.isClientSide) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath();
        if (itemId.startsWith("blueprint")) {
            BlueprintItem.handleLeftClick(player);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlockWithBlueprint(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level world = player.getCommandSenderWorld();
        if (!world.isClientSide) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath();
        if (itemId.startsWith("blueprint")) {
            BlueprintItem.handleRightClick(player, event.getPos().above(), itemId);
        }
    }

    @SubscribeEvent
    public static void onRightClickAirWithBlueprint(PlayerInteractEvent.RightClickEmpty event) {
        Player player = event.getEntity();
        Level world = player.getCommandSenderWorld();
        if (!world.isClientSide) {
            return;
        }
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        String itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath();
        if (itemId.startsWith("blueprint")) {
            if (Objects.equals(BlueprintItem.status, "in-preview")) {
                BlueprintItem.handleRightClick(player, event.getPos(), itemId);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"blueprint.hint.air"), true);
            }
        }
    }

    private static boolean handleSpecialItemClick(Player player, BlockPos hitPos, CLICK_TYPE clickType) {
        Level world = player.getCommandSenderWorld();
        Item carriedItem = player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        if (carriedItem == PrefabricatedStructures.BUILD_PLACER.get()) {
            if (!world.isClientSide && hitPos == null) {
                return false;
            }
            if (world.isClientSide && hitPos != null) {
                return false;
            }
            if (clickType == CLICK_TYPE.LEFT) {
                BuildPlacerHandler.handleLeftClick(player);
            } else if (clickType == CLICK_TYPE.RIGHT) {
                BuildPlacerHandler.handleRightClick(player);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onTooltipHover(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.getItem().equals(PrefabricatedStructures.EMPTY_BLUEPRINT.get())) {
            event.getToolTip().add(Component.translatable((String)"tooltip.empty_blueprint.default"));
        } else if (itemStack.getItem().equals(PrefabricatedStructures.BLUEPRINT.get())) {
            event.getToolTip().add(Component.translatable((String)"tooltip.blueprint.default"));
        } else if (BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().startsWith("blueprint_")) {
            String itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath();
            event.getToolTip().add(Component.literal((String)BlueprintsData.tooltipCategories.get(BlueprintsData.blueprintCategories.get(itemId))).withStyle(ChatFormatting.BLUE));
            String name = itemStack.getHoverName().getString();
            MutableComponent nameComponent = Component.literal((String)name).withStyle(ChatFormatting.GOLD);
            event.getToolTip().add(Component.translatable((String)"tooltip.blueprint.set-build", (Object[])new Object[]{nameComponent}));
        }
        if (!BlueprintsFunctions.hasBuildpasteLoaded().booleanValue()) {
            if (itemStack.getItem().equals(PrefabricatedStructures.BUILD_PLACER.get())) {
                if (itemStack.get(DataComponents.CUSTOM_DATA) == null) {
                    event.getToolTip().add(Component.translatable((String)"tooltip.build_placer.default"));
                    return;
                }
                List allKeys = Objects.requireNonNull((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag().getAllKeys().stream().toList();
                if (allKeys.isEmpty()) {
                    return;
                }
                for (int i = 0; i < allKeys.size(); ++i) {
                    String key = (String)allKeys.get(i);
                    if (key.equals("buildpaste.bound-build-id")) continue;
                    String value = Objects.requireNonNull((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag().getString(key);
                    MutableComponent newComponent = Component.translatable((String)("tags." + key));
                    newComponent.append(": " + value);
                    if (value.equals("true")) {
                        newComponent.withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
                    } else {
                        newComponent.withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
                    }
                    event.getToolTip().add(newComponent);
                }
            } else {
                String menuActionHint;
                if (itemStack.get(DataComponents.CUSTOM_DATA) == null) {
                    return;
                }
                CompoundTag compoundTag = Objects.requireNonNull((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag();
                if (!compoundTag.contains("menu.action")) {
                    return;
                }
                if (compoundTag.contains("menu.active")) {
                    if (compoundTag.getString("menu.active").equals("true")) {
                        event.getToolTip().add(Component.literal((String)"Enabled").withStyle(ChatFormatting.GREEN));
                    } else {
                        event.getToolTip().add(Component.literal((String)"Disabled").withStyle(ChatFormatting.DARK_GRAY));
                    }
                    event.getToolTip().add(Component.literal((String)""));
                }
                if (!Component.translatable((String)("menu.action." + (menuActionHint = compoundTag.getString("menu.action")))).getString().isEmpty()) {
                    event.getToolTip().add(Component.translatable((String)("menu.action." + menuActionHint)).withStyle(ChatFormatting.GRAY));
                }
            }
        } else if (itemStack.getItem().equals(PrefabricatedStructures.BUILD_PLACER.get())) {
            event.getToolTip().add(Component.literal((String)"This Build Placer doesn't work when also using Buildpaste. Use the one provided by Buildpaste instead"));
        }
    }

    @SubscribeEvent
    public static void TickEvent(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        String itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath();
        if (!player.level().isClientSide) {
            return;
        }
        int currentItemSlot = player.getInventory().selected;
        if (itemId.startsWith("blueprint") && lastSelectedItemSlot == currentItemSlot && itemId.equals(lastSelectedBlueprintItemID)) {
            if (BlueprintItem.hasLoadedBuild && Objects.equals(BlueprintItem.status, "in-preview")) {
                player.displayClientMessage((Component)Component.translatable((String)"blueprint.message").withStyle(ChatFormatting.GREEN), true);
            }
        } else {
            BlueprintItem.hasLoadedBuild = false;
            if (Objects.equals(BlueprintItem.status, "in-preview")) {
                RenderHandler.stopRendering();
                BlueprintItem.status = "";
            }
        }
        lastSelectedItemSlot = currentItemSlot;
        lastSelectedBlueprintItemID = itemId;
    }

    private static enum CLICK_TYPE {
        LEFT,
        RIGHT;

    }
}

