/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.commands;

import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.util.Variables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ConnectAccountsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"connectaccounts").executes(source -> ConnectAccountsCommand.verifyCommand((CommandSourceStack)source.getSource(), ""))).then(Commands.argument((String)"email", (ArgumentType)MessageArgument.message()).executes(source -> ConnectAccountsCommand.verifyCommand((CommandSourceStack)source.getSource(), MessageArgument.getMessage((CommandContext)source, (String)"email").getString()))));
    }

    public static int verifyCommand(CommandSourceStack source, String email) {
        if (!email.contains("@") && !email.equals("")) {
            source.sendSuccess(() -> Component.translatable((String)"commands.verify.noemail", (Object[])new Object[]{email}), false);
            return 1;
        }
        if (email.equals("")) {
            source.sendSuccess(() -> Component.translatable((String)"commands.verify.help"), false);
        } else {
            try {
                Variables.mcname = source.getPlayerOrException().getName().getString();
                Variables.uuid = source.getPlayerOrException().getStringUUID();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            Integer responseCode = Firebase.connectAccounts(email);
            if (responseCode == 200) {
                source.sendSuccess(() -> Component.translatable((String)"commands.verify.verified", (Object[])new Object[]{email}), false);
            } else if (responseCode == 404) {
                MutableComponent buildpaste = Component.literal((String)"Buildpaste.net");
                Style buildpasteStyle = Style.EMPTY;
                buildpasteStyle = buildpasteStyle.applyFormat(ChatFormatting.GREEN);
                buildpasteStyle = buildpasteStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, Variables.url));
                buildpasteStyle = buildpasteStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Visit Buildpaste.net").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN))));
                buildpaste.setStyle(buildpasteStyle);
                MutableComponent profile = Component.literal((String)"Profile");
                Style profileStyle = Style.EMPTY;
                profileStyle = profileStyle.applyFormat(ChatFormatting.GREEN);
                profileStyle = profileStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, Variables.url + "/profileedit.html"));
                profileStyle = profileStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Edit your Profile").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN))));
                profile.setStyle(profileStyle);
                source.sendSuccess(() -> Component.translatable((String)"commands.verify.emailnotfound", (Object[])new Object[]{email, Variables.mcname, buildpaste, profile}), false);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"commands.verify.error"), false);
            }
        }
        return 1;
    }
}

