/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.commands;

import com.mistrx.prefabricated_structures.PrefabricatedStructures;
import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.util.Functions;
import com.mistrx.prefabricated_structures.util.Variables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3d;

public class ConstructCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"construct").executes(source -> ConstructCommand.constructCommand((CommandSourceStack)source.getSource(), null))).then(Commands.argument((String)"first argument", (ArgumentType)StringArgumentType.string()).executes(source -> ConstructCommand.constructCommand((CommandSourceStack)source.getSource(), StringArgumentType.getString((CommandContext)source, (String)"first argument")))));
    }

    public static int constructCommand(CommandSourceStack source, String firstarg) {
        String[] args = new String[]{firstarg, null};
        PrefabricatedStructures.LOGGER.info("firstarg: " + firstarg);
        if (firstarg != null && firstarg.equals("constructbuild")) {
            String direction = null;
            try {
                direction = Functions.getLookDirection(source.getPlayerOrException().getViewYRot(1.0f));
                Functions.setPlayerVariables((Player)source.getPlayerOrException());
                if (Functions.sendInvalidUUIDMessage((Player)source.getPlayerOrException()).booleanValue()) {
                    source.sendFailure((Component)Component.translatable((String)"util.doesnt-have-valid-uuid"));
                }
            }
            catch (CommandSyntaxException e) {
                PrefabricatedStructures.LOGGER.info("Error in try catch at constructCommand");
                e.printStackTrace();
            }
            Vector3d pos = new Vector3d(Math.floor(source.getPosition().x), Math.floor(source.getPosition().y), Math.floor(source.getPosition().z));
            Functions.pasteCurrentBuilding(pos, direction, "dontplaceair", false, true);
            source.sendSuccess(() -> Component.translatable((String)"commands.construct.success"), true);
            return 1;
        }
        Variables.playerItems = new HashMap();
        Variables.buildBlocks = new HashMap();
        try {
            Functions.setPlayerVariables((Player)source.getPlayerOrException());
            ServerPlayer player = source.getPlayerOrException();
            NonNullList inventory = player.getInventory().items;
            Integer inventorySize = inventory.size();
            for (int i = 0; i < inventorySize; ++i) {
                String[] itemArray = ((ItemStack)inventory.get(i)).toString().split(" ");
                String itemName = "minecraft:" + itemArray[1];
                Integer itemAmount = Integer.parseInt(itemArray[0]);
                Variables.playerItems.merge(itemName, itemAmount, Integer::sum);
            }
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        PrefabricatedStructures.LOGGER.info("Construct Command executed");
        String response = Functions.setBuilding(null, "south", args, false);
        if (response.equals("error")) {
            source.sendFailure((Component)Component.translatable((String)"commands.paste.error"));
            return 0;
        }
        if (response.equals("random-error")) {
            source.sendFailure((Component)Component.translatable((String)"commands.paste.random-error"));
            return 0;
        }
        if (response.equals("error-404")) {
            source.sendFailure((Component)Component.translatable((String)"commands.paste.error-404"));
            return 0;
        }
        for (int i = 0; i < Firebase.blockIDs.size(); ++i) {
            String block = Functions.getItemFromBlock(Functions.getBlockByIdOrName(Firebase.blockIDs.get(i)));
            Variables.buildBlocks.merge(block, 1, Integer::sum);
        }
        Variables.buildBlocks.remove("minecraft:air");
        Variables.playerItems.remove("minecraft:air");
        Boolean hasAllRequiredMaterials = true;
        Boolean hasAnyRequiredMaterials = false;
        Object requiredMaterials = "Needed Materials:\n";
        Object[] buildBlocksKeys = Variables.buildBlocks.keySet().toArray();
        for (int i = 0; i < buildBlocksKeys.length; ++i) {
            String key = buildBlocksKeys[i].toString();
            Integer amount = Variables.buildBlocks.get(key);
            Object endText = "";
            ChatFormatting color = ChatFormatting.WHITE;
            if (Variables.playerItems.containsKey(key)) {
                hasAnyRequiredMaterials = true;
                if (Variables.playerItems.get(key) >= amount) {
                    color = ChatFormatting.GREEN;
                } else {
                    endText = " (" + String.valueOf(Variables.playerItems.get(key)) + "/" + amount.toString() + ")";
                    hasAllRequiredMaterials = false;
                }
            } else {
                hasAllRequiredMaterials = false;
            }
            requiredMaterials = (String)requiredMaterials + String.valueOf(color) + amount.toString() + " x " + key.replace("minecraft:", "") + (String)endText + "\n";
        }
        String constructBuildCommand = "/construct constructbuild";
        String finalRequiredMaterials = requiredMaterials;
        source.sendSuccess(() -> Component.literal((String)finalRequiredMaterials), true);
        if (hasAllRequiredMaterials.booleanValue()) {
            construct = Component.literal((String)"Construct");
            constructStyle = Style.EMPTY;
            constructStyle = constructStyle.applyFormat(ChatFormatting.LIGHT_PURPLE);
            constructStyle = constructStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, constructBuildCommand));
            constructStyle = constructStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Construct the Build")));
            construct.setStyle(constructStyle);
            source.sendSuccess(() -> Component.translatable((String)"commands.construct.all-materials", (Object[])new Object[]{construct}), true);
        } else if (hasAnyRequiredMaterials.booleanValue()) {
            construct = Component.literal((String)"Construct Anyways");
            constructStyle = Style.EMPTY;
            constructStyle = constructStyle.applyFormat(ChatFormatting.LIGHT_PURPLE);
            constructStyle = constructStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, constructBuildCommand));
            constructStyle = constructStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"Construct the Build")));
            construct.setStyle(constructStyle);
            source.sendSuccess(() -> Component.translatable((String)"commands.construct.missing-materials", (Object[])new Object[]{construct}), true);
        }
        return 1;
    }
}

