/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.commands;

import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.items.build_placer.BuildPlacerHandler;
import com.mistrx.prefabricated_structures.rendering.RenderHandler;
import com.mistrx.prefabricated_structures.util.Variables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PreviewCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"preview").requires(source -> source.hasPermission(4))).executes(source -> PreviewCommand.preview((CommandSourceStack)source.getSource())));
    }

    public static Integer preview(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        new Timer().schedule(new TimerTask((Player)player){
            final /* synthetic */ Player val$player;
            {
                this.val$player = player;
            }

            @Override
            public void run() {
                String oldBuildID = Variables.buildID;
                String status = Firebase.getSelectedBuildingID();
                if (status.equals("error")) {
                    MutableComponent buildpastecomponent = Component.literal((String)"Buildpaste.net");
                    Style componentStyle = Style.EMPTY;
                    componentStyle = componentStyle.applyFormat(ChatFormatting.GREEN);
                    componentStyle = componentStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://buildpaste.net/category?&player=" + this.val$player.getDisplayName().getString()));
                    componentStyle = componentStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open buildpaste.net and create an account").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN))));
                    buildpastecomponent.setStyle(componentStyle);
                    Variables.player.displayClientMessage((Component)Component.translatable((String)"account.required", (Object[])new Object[]{buildpastecomponent}), false);
                    return;
                }
                String newBuildID = Variables.buildID;
                if (!Objects.equals(oldBuildID, newBuildID) || Firebase.blockIDs == null) {
                    String getBuildResult = Firebase.getBuilding(Variables.buildID, false, null, null, null);
                    if (getBuildResult.equals("error-404")) {
                        BuildPlacerHandler.status = "error-404";
                        return;
                    }
                    if (getBuildResult.equals("error")) {
                        BuildPlacerHandler.status = "error";
                        return;
                    }
                }
                RenderHandler.startPreviewPosition = this.val$player.blockPosition();
                RenderHandler.isUsingPreviewCommand = true;
                RenderHandler.prepareRenderBlocks(this.val$player);
                MutableComponent pastecomponent = Component.literal((String)"Paste");
                Style componentStyle = Style.EMPTY;
                componentStyle = componentStyle.applyFormat(ChatFormatting.LIGHT_PURPLE);
                componentStyle = componentStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/_pastebuildplacer"));
                componentStyle = componentStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Paste the build").setStyle(Style.EMPTY.applyFormat(ChatFormatting.LIGHT_PURPLE))));
                pastecomponent.setStyle(componentStyle);
                MutableComponent removecomponent = Component.literal((String)"Remove Preview");
                componentStyle = Style.EMPTY;
                componentStyle = componentStyle.applyFormat(ChatFormatting.RED);
                componentStyle = componentStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/_removerender"));
                componentStyle = componentStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Remove the preview").setStyle(Style.EMPTY.applyFormat(ChatFormatting.RED))));
                removecomponent.setStyle(componentStyle);
                Variables.player.displayClientMessage((Component)Component.translatable((String)"commands.preview.success", (Object[])new Object[]{pastecomponent, removecomponent}), false);
            }
        }, 1L);
        return 1;
    }
}

