/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.SetBlockCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class _FillCommandNoRestriction {
    private static final int MAX_FILL_AREA = 32768;
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((p_137392_, p_137393_) -> Component.translatable((String)"commands.fill.toobig", (Object[])new Object[]{p_137392_, p_137393_}));
    static final BlockInput HOLLOW_CORE = new BlockInput(Blocks.AIR.defaultBlockState(), Collections.emptySet(), (CompoundTag)null);
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.fill.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> p_214443_, CommandBuildContext p_214444_) {
        p_214443_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"_fillbuild").requires(p_137384_ -> p_137384_.hasPermission(2))).then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"block", (ArgumentType)BlockStateArgument.block((CommandBuildContext)p_214444_)).executes(p_137405_ -> _FillCommandNoRestriction.fillBlocks((CommandSourceStack)p_137405_.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137405_, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137405_, (String)"to")), BlockStateArgument.getBlock((CommandContext)p_137405_, (String)"block"), Mode.REPLACE, null))).then(((LiteralArgumentBuilder)Commands.literal((String)"replace").executes(p_137403_ -> _FillCommandNoRestriction.fillBlocks((CommandSourceStack)p_137403_.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137403_, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137403_, (String)"to")), BlockStateArgument.getBlock((CommandContext)p_137403_, (String)"block"), Mode.REPLACE, null))).then(Commands.argument((String)"filter", (ArgumentType)BlockPredicateArgument.blockPredicate((CommandBuildContext)p_214444_)).executes(p_137401_ -> _FillCommandNoRestriction.fillBlocks((CommandSourceStack)p_137401_.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137401_, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137401_, (String)"to")), BlockStateArgument.getBlock((CommandContext)p_137401_, (String)"block"), Mode.REPLACE, BlockPredicateArgument.getBlockPredicate((CommandContext)p_137401_, (String)"filter")))))).then(Commands.literal((String)"keep").executes(p_137399_ -> _FillCommandNoRestriction.fillBlocks((CommandSourceStack)p_137399_.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137399_, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137399_, (String)"to")), BlockStateArgument.getBlock((CommandContext)p_137399_, (String)"block"), Mode.REPLACE, p_180225_ -> p_180225_.getLevel().isEmptyBlock(p_180225_.getPos()))))).then(Commands.literal((String)"outline").executes(p_137397_ -> _FillCommandNoRestriction.fillBlocks((CommandSourceStack)p_137397_.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137397_, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137397_, (String)"to")), BlockStateArgument.getBlock((CommandContext)p_137397_, (String)"block"), Mode.OUTLINE, null)))).then(Commands.literal((String)"hollow").executes(p_137395_ -> _FillCommandNoRestriction.fillBlocks((CommandSourceStack)p_137395_.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137395_, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137395_, (String)"to")), BlockStateArgument.getBlock((CommandContext)p_137395_, (String)"block"), Mode.HOLLOW, null)))).then(Commands.literal((String)"destroy").executes(p_137382_ -> _FillCommandNoRestriction.fillBlocks((CommandSourceStack)p_137382_.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137382_, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)p_137382_, (String)"to")), BlockStateArgument.getBlock((CommandContext)p_137382_, (String)"block"), Mode.DESTROY, null)))))));
    }

    private static int fillBlocks(CommandSourceStack p_137386_, BoundingBox p_137387_, BlockInput p_137388_, Mode p_137389_, @Nullable Predicate<BlockInWorld> p_137390_) throws CommandSyntaxException {
        int i = p_137387_.getXSpan() * p_137387_.getYSpan() * p_137387_.getZSpan();
        ArrayList list = Lists.newArrayList();
        ServerLevel serverlevel = p_137386_.getLevel();
        int j = 0;
        for (BlockPos blockpos : BlockPos.betweenClosed((int)p_137387_.minX(), (int)p_137387_.minY(), (int)p_137387_.minZ(), (int)p_137387_.maxX(), (int)p_137387_.maxY(), (int)p_137387_.maxZ())) {
            BlockInput blockinput;
            if (p_137390_ != null && !p_137390_.test(new BlockInWorld((LevelReader)serverlevel, blockpos, true)) || (blockinput = p_137389_.filter.filter(p_137387_, blockpos, p_137388_, serverlevel)) == null) continue;
            BlockEntity blockentity = serverlevel.getBlockEntity(blockpos);
            Clearable.tryClear((Object)blockentity);
            if (!blockinput.place(serverlevel, blockpos, 2)) continue;
            list.add(blockpos.immutable());
            ++j;
        }
        for (BlockPos blockpos1 : list) {
            Block block = serverlevel.getBlockState(blockpos1).getBlock();
            serverlevel.blockUpdated(blockpos1, block);
        }
        if (j == 0) {
            throw ERROR_FAILED.create();
        }
        return j;
    }

    static enum Mode {
        REPLACE((p_137433_, p_137434_, p_137435_, p_137436_) -> p_137435_),
        OUTLINE((p_137428_, p_137429_, p_137430_, p_137431_) -> p_137429_.getX() != p_137428_.minX() && p_137429_.getX() != p_137428_.maxX() && p_137429_.getY() != p_137428_.minY() && p_137429_.getY() != p_137428_.maxY() && p_137429_.getZ() != p_137428_.minZ() && p_137429_.getZ() != p_137428_.maxZ() ? null : p_137430_),
        HOLLOW((p_137423_, p_137424_, p_137425_, p_137426_) -> p_137424_.getX() != p_137423_.minX() && p_137424_.getX() != p_137423_.maxX() && p_137424_.getY() != p_137423_.minY() && p_137424_.getY() != p_137423_.maxY() && p_137424_.getZ() != p_137423_.minZ() && p_137424_.getZ() != p_137423_.maxZ() ? HOLLOW_CORE : p_137425_),
        DESTROY((p_137418_, p_137419_, p_137420_, p_137421_) -> {
            p_137421_.destroyBlock(p_137419_, true);
            return p_137420_;
        });

        public final SetBlockCommand.Filter filter;

        private Mode(SetBlockCommand.Filter p_137416_) {
            this.filter = p_137416_;
        }
    }
}

